/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text.extractheadlines;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.jpedal.examples.text.ExtractTextInRectangle;
import org.jpedal.examples.text.extractheadlines.DateConfiguration;
import org.jpedal.examples.text.extractheadlines.SectionConfiguration;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfData;
import org.jpedal.utils.Strip;

public class ExtractDate
extends ExtractTextInRectangle {
    private static final boolean debug = false;
    DateConfiguration configDate;
    String[] dateTokens = null;
    private int[] date_x1;
    private int[] date_x2;
    private int[] date_y1;
    private int[] date_y2;
    private String day;
    private String date;
    private String month;
    private String year;
    SectionConfiguration sectionConfig;
    String[] sectionTokens = null;
    boolean isDate = false;
    private int[] section_x1;
    private int[] section_x2;
    private int[] section_y1;
    private int[] section_y2;
    private String section = null;
    private String folio = null;

    public String getFolio() {
        return this.folio;
    }

    public String getSection() {
        return this.section;
    }

    public String getDay() {
        return this.day;
    }

    public String getDate() {
        return this.date;
    }

    public String getMonth() {
        return this.month;
    }

    public String getYear() {
        return this.year;
    }

    private void initSection(String string) {
        this.sectionConfig = new SectionConfiguration(string);
        this.section = this.sectionConfig.getValue("default_section");
        int n = Integer.parseInt(this.sectionConfig.getValue("xmlCount"));
        this.sectionTokens = new String[n];
        for (int i = 0; i < n; ++i) {
            this.sectionTokens[i] = this.sectionConfig.getValue("xmlTag_" + i);
            if (!showMessages) continue;
            System.out.println(this.sectionTokens[i]);
        }
        n = Integer.parseInt(this.sectionConfig.getValue("locationCount"));
        this.section_x1 = new int[n];
        this.section_x2 = new int[n];
        this.section_y1 = new int[n];
        this.section_y2 = new int[n];
        String string2 = "locTag";
        String[] stringArray = new String[]{"x1", "y1", "x2", "y2"};
        for (int i = 0; i < n; ++i) {
            block8: for (int j = 0; j < 4; ++j) {
                String string3 = string2 + '_' + i + '_' + stringArray[j];
                String string4 = this.sectionConfig.getValue(string3);
                int n2 = Integer.parseInt(string4);
                switch (j) {
                    case 0: {
                        this.section_x1[i] = n2;
                        continue block8;
                    }
                    case 1: {
                        this.section_y1[i] = n2;
                        continue block8;
                    }
                    case 2: {
                        this.section_x2[i] = n2;
                        continue block8;
                    }
                    case 3: {
                        this.section_y2[i] = n2;
                    }
                }
            }
        }
    }

    private String extractSection(String string) {
        String string2 = null;
        try {
            if (showMessages) {
                System.out.println(string);
            }
            if (string == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = this.sectionTokens.length;
            for (int i = 0; i < n; ++i) {
                hashMap.put(this.sectionTokens[i], "x");
            }
            Object var2_8 = null;
            string2 = null;
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
            while (stringTokenizer.hasMoreTokens() && (string2 == null || var2_8 == null)) {
                string3 = stringTokenizer.nextToken();
                if (hashMap.get(string3) == null) continue;
                String string4 = string3;
                string3 = stringTokenizer.nextToken();
                boolean bl = false;
                if (bl || string3.length() <= 2) continue;
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens() && !string3.equals("/font")) {
                    if (string3.indexOf("SpaceC") != -1) {
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append(string3);
                    }
                    string3 = stringTokenizer.nextToken();
                }
                string2 = stringBuffer.toString().trim();
                if (!string4.equals("font face=\"TimesClassicDisplay\" style=\"font-size:16pt\"")) continue;
                break;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return string2;
    }

    private String extractDate(String string) {
        String string2 = "";
        try {
            if (showMessages) {
                System.out.println(string);
            }
            if (string == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = this.dateTokens.length;
            for (int i = 0; i < n; ++i) {
                hashMap.put(this.dateTokens[i], "x");
            }
            Object var2_8 = null;
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
            while (stringTokenizer.hasMoreTokens() && (string2 == null || var2_8 == null)) {
                string3 = stringTokenizer.nextToken();
                if (hashMap.get(string3) == null) continue;
                String string4 = string3;
                string3 = stringTokenizer.nextToken();
                boolean bl = false;
                if (bl || string3.length() <= 2) continue;
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens() && !string3.equals("/font")) {
                    if (string3.indexOf("SpaceC") != -1) {
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append(string3);
                    }
                    string3 = stringTokenizer.nextToken();
                }
                string2 = string2 + ' ' + stringBuffer.toString().trim();
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return string2;
    }

    public ExtractDate(String string, String string2, PdfData pdfData) {
        boolean bl = string.indexOf("TIM") != -1;
        try {
            showMessages = false;
            this.initDate(string2);
            this.initSection(string2);
            this.extractValues(pdfData, 1, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initDate(String string) {
        this.configDate = new DateConfiguration(string);
        this.date = this.configDate.getValue("default_date");
        int n = Integer.parseInt(this.configDate.getValue("xmlCount"));
        this.dateTokens = new String[n];
        for (int i = 0; i < n; ++i) {
            this.dateTokens[i] = this.configDate.getValue("xmlTag_" + i);
            if (!showMessages) continue;
            System.out.println(this.dateTokens[i]);
        }
        n = Integer.parseInt(this.configDate.getValue("locationCount"));
        this.date_x1 = new int[n];
        this.date_x2 = new int[n];
        this.date_y1 = new int[n];
        this.date_y2 = new int[n];
        String string2 = "locTag";
        String[] stringArray = new String[]{"x1", "y1", "x2", "y2"};
        for (int i = 0; i < n; ++i) {
            block8: for (int j = 0; j < 4; ++j) {
                String string3 = string2 + '_' + i + '_' + stringArray[j];
                String string4 = this.configDate.getValue(string3);
                int n2 = Integer.parseInt(string4);
                switch (j) {
                    case 0: {
                        this.date_x1[i] = n2;
                        continue block8;
                    }
                    case 1: {
                        this.date_y1[i] = n2;
                        continue block8;
                    }
                    case 2: {
                        this.date_x2[i] = n2;
                        continue block8;
                    }
                    case 3: {
                        this.date_y2[i] = n2;
                    }
                }
            }
        }
    }

    private void extractValues(PdfData pdfData, int n, boolean bl) {
        String string;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        PdfGroupingAlgorithms pdfGroupingAlgorithms = new PdfGroupingAlgorithms(pdfData);
        this.date = null;
        int n7 = this.date_x2.length;
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = this.date_x1[n6];
            n4 = this.date_x2[n6];
            n3 = this.date_y1[n6];
            n2 = this.date_y2[n6];
            try {
                StringTokenizer stringTokenizer;
                int n8;
                this.text = pdfGroupingAlgorithms.extractTextInRectangle(n5, n3, n4, n2, n, false, true);
                if (showMessages) {
                    System.out.println("Using (" + n5 + ',' + n3 + ") (" + n4 + ',' + n2 + ") text=" + this.text);
                }
                if (this.text == null) continue;
                string = this.extractDate(this.text);
                if (showMessages) {
                    System.out.println("Date=" + string + '<');
                }
                if (string != null && !string.equals(this.configDate.getValue("default_date")) && ((n8 = (stringTokenizer = new StringTokenizer(string, ", ")).countTokens()) >= 3 || bl && n8 >= 4)) {
                    if (bl) {
                        this.day = stringTokenizer.nextToken();
                    }
                    this.month = stringTokenizer.nextToken();
                    this.date = stringTokenizer.nextToken();
                    this.year = stringTokenizer.nextToken();
                    if (!(this.isString(this.month) && this.isNumber(this.date) && this.isNumber(this.year))) {
                        this.month = null;
                        string = null;
                        this.date = null;
                        this.year = null;
                    }
                }
                if (this.month == null || string == null || this.year == null) continue;
                n6 = n7;
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception);
                this.month = null;
                this.date = null;
                this.year = null;
            }
        }
        n6 = this.section_x2.length;
        string = null;
        for (int i = 0; i < n6; ++i) {
            n5 = this.section_x1[i];
            n4 = this.section_x2[i];
            n3 = this.section_y1[i];
            n2 = this.section_y2[i];
            if (showMessages) {
                System.out.println("Using (" + n5 + ',' + n3 + ") (" + n4 + ',' + n2 + ')');
            }
            try {
                this.text = pdfGroupingAlgorithms.extractTextInRectangle(n5, n3, n4, n2, n, false, true);
                if (this.text == null) continue;
                this.folio = Strip.stripXML(this.text).toString();
                string = this.extractSection(this.text);
                if (string == null) continue;
                i = n6;
                if (showMessages) {
                    System.out.println("section=" + string);
                }
                this.section = string;
                continue;
            }
            catch (PdfException pdfException) {
                this.text = null;
                System.err.println("Exception " + pdfException.getMessage() + " in file " + this.decodePdf.getObjectStore().fullFileName);
                pdfException.printStackTrace();
            }
        }
        if (string == null) {
            // empty if block
        }
    }

    private boolean isString(String string) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c)) continue;
            bl = false;
            i = n;
        }
        return bl;
    }

    private boolean isNumber(String string) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) continue;
            bl = false;
            i = n;
        }
        return bl;
    }
}

