/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.io.Serializable;
import org.jpedal.fonts.objects.FontData;

public class FontFile2
implements Serializable {
    private static final long serialVersionUID = -3097990864237320960L;
    public static final int HEAD = 0;
    public static final int MAPX = 1;
    public static final int CMAP = 2;
    public static final int LOCA = 3;
    public static final int GLYF = 4;
    public static final int HHEA = 5;
    public static final int HMTX = 6;
    public static final int NAME = 7;
    public static final int POST = 8;
    public static final int CVT = 9;
    public static final int FPGM = 10;
    public static final int HDMX = 11;
    public static final int KERN = 12;
    public static final int OS2 = 13;
    public static final int PREP = 14;
    public static final int DSIG = 15;
    public static final int CFF = 16;
    public static final int GSUB = 17;
    public static final int BASE = 18;
    public static final int EBDT = 19;
    public static final int EBLC = 20;
    public static final int GASP = 21;
    public static final int VHEA = 22;
    public static final int VMTX = 23;
    public static final int GDEF = 24;
    public static final int JSTF = 25;
    public static final int LTSH = 26;
    public static final int PCLT = 27;
    public static final int VDMX = 28;
    public static final int BSLN = 29;
    public static final int MORT = 30;
    public static final int FDSC = 31;
    private int tableCount = 32;
    private int[][] tables;
    private int[][] offsets;
    private FontData fontDataAsObject = null;
    private byte[] fontDataAsArray = null;
    private boolean useArray = true;
    private int pointer = 0;
    public static final int OPENTYPE = 1;
    public static final int TRUETYPE = 2;
    public static final int TTC = 3;
    int type = 2;
    private int currentFontID = 0;
    private int fontCount = 1;

    public FontFile2(FontData fontData) {
        this.useArray = false;
        this.fontDataAsObject = fontData;
        this.readHeader();
    }

    public FontFile2(byte[] byArray) {
        this.useArray = true;
        this.fontDataAsArray = byArray;
        this.readHeader();
    }

    public void setSelectedFontIndex(int n) {
        if (n < this.fontCount) {
            this.currentFontID = n;
        }
    }

    private final void readHeader() {
        int n = this.getNextUint32();
        if (n == 0x4F54544F) {
            this.type = 1;
        } else if (n == 1953784678) {
            this.type = 3;
        }
        if (this.type == 3) {
            int n2;
            int n3 = this.getNextUint32();
            this.fontCount = this.getNextUint32();
            this.tables = new int[this.tableCount][this.fontCount];
            this.offsets = new int[this.tableCount][this.fontCount];
            int[] nArray = new int[this.fontCount];
            for (n2 = 0; n2 < this.fontCount; ++n2) {
                int n4;
                this.currentFontID = n2;
                nArray[n2] = n4 = this.getNextUint32();
            }
            for (n2 = 0; n2 < this.fontCount; ++n2) {
                this.currentFontID = n2;
                this.pointer = nArray[n2];
                n = this.getNextUint32();
                this.readTablesForFont();
            }
            this.currentFontID = 0;
        } else {
            this.tables = new int[this.tableCount][1];
            this.offsets = new int[this.tableCount][1];
            this.readTablesForFont();
        }
    }

    private void readTablesForFont() {
        int n = this.getNextUint16();
        int n2 = this.getNextUint16();
        int n3 = this.getNextUint16();
        int n4 = this.getNextUint16();
        for (int i = 0; i < n; ++i) {
            String string = this.getNextUint32AsTag();
            int n5 = this.getNextUint32();
            int n6 = this.getNextUint32();
            int n7 = this.getNextUint32();
            int n8 = -1;
            if (string.equals("maxp")) {
                n8 = 1;
            } else if (string.equals("head")) {
                n8 = 0;
            } else if (string.equals("cmap")) {
                n8 = 2;
            } else if (string.equals("loca")) {
                n8 = 3;
            } else if (string.equals("glyf")) {
                n8 = 4;
            } else if (string.equals("hhea")) {
                n8 = 5;
            } else if (string.equals("hmtx")) {
                n8 = 6;
            } else if (string.equals("name")) {
                n8 = 7;
            } else if (string.equals("post")) {
                n8 = 8;
            } else if (string.equals("cvt ")) {
                n8 = 9;
            } else if (string.equals("fpgm")) {
                n8 = 10;
            } else if (string.equals("hdmx")) {
                n8 = 11;
            } else if (string.equals("kern")) {
                n8 = 12;
            } else if (string.equals("OS/2")) {
                n8 = 13;
            } else if (string.equals("prep")) {
                n8 = 14;
            } else if (string.equals("DSIG")) {
                n8 = 15;
            } else if (string.equals("BASE")) {
                n8 = 18;
            } else if (string.equals("CFF ")) {
                n8 = 16;
            } else if (string.equals("GSUB")) {
                n8 = 17;
            } else if (string.equals("EBDT")) {
                n8 = 19;
            } else if (string.equals("EBLC")) {
                n8 = 20;
            } else if (string.equals("gasp")) {
                n8 = 21;
            } else if (string.equals("vhea")) {
                n8 = 22;
            } else if (string.equals("vmtx")) {
                n8 = 23;
            } else if (string.equals("GDEF")) {
                n8 = 24;
            } else if (string.equals("JSTF")) {
                n8 = 25;
            } else if (string.equals("LTSH")) {
                n8 = 26;
            } else if (string.equals("PCLT")) {
                n8 = 27;
            } else if (string.equals("VDMX")) {
                n8 = 28;
            } else if (string.equals("mort")) {
                n8 = 30;
            } else if (string.equals("bsln")) {
                n8 = 29;
            } else if (string.equals("fdsc")) {
                n8 = 31;
            }
            if (n8 == -1) continue;
            this.tables[n8][this.currentFontID] = n6;
            this.offsets[n8][this.currentFontID] = n7;
        }
    }

    public int selectTable(int n) {
        this.pointer = this.tables[n][this.currentFontID];
        return this.pointer;
    }

    public int getTableSize(int n) {
        return this.offsets[n][this.currentFontID];
    }

    public final int getNextUint32() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (3 - i);
            ++this.pointer;
        }
        return n;
    }

    public final int getNextUint64() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 8; ++i) {
            n2 = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            n += n2 << 8 * (7 - i);
            ++this.pointer;
        }
        return n;
    }

    public final void setPointer(int n) {
        this.pointer = n;
    }

    public final int getOffset(int n) {
        return this.offsets[n][this.currentFontID];
    }

    public final int getTable(int n) {
        return this.tables[n][this.currentFontID];
    }

    public final int getPointer() {
        return this.pointer;
    }

    public final String getNextUint32AsTag() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            char c = this.useArray ? (char)this.fontDataAsArray[this.pointer] : (char)this.fontDataAsObject.getByte(this.pointer);
            stringBuffer.append(c);
            ++this.pointer;
        }
        return stringBuffer.toString();
    }

    public final int getNextUint16() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return n;
    }

    public final short getShort() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            byte by = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
            n += by << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public final int getNextUint8() {
        int n = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
        ++this.pointer;
        return n;
    }

    public final int getNextint8() {
        byte by = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
        ++this.pointer;
        return by;
    }

    public void skip(int n) {
        this.pointer += n;
    }

    public short getFWord() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public short getNextInt16() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public short getNextSignedInt16() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public short readUFWord() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public float getFixed() {
        int n = this.useArray ? (this.fontDataAsArray[this.pointer] & 0xFF) * 256 + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : (this.fontDataAsObject.getByte(this.pointer) & 0xFF) * 256 + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        if (n > 32768) {
            n -= 65536;
        }
        this.pointer += 2;
        int n2 = this.useArray ? (this.fontDataAsArray[this.pointer] & 0xFF) * 256 + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : (this.fontDataAsObject.getByte(this.pointer) & 0xFF) * 256 + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        this.pointer += 2;
        return (float)n + (float)n2 / 65536.0f;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        int n = 0;
        n = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
        ++this.pointer;
        for (int i = 0; i < n; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            ++this.pointer;
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public float getF2Dot14() {
        boolean bl;
        int n = this.useArray ? ((this.fontDataAsArray[this.pointer] & 0xFF) << 8) + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : ((this.fontDataAsObject.getByte(this.pointer) & 0xFF) << 8) + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        this.pointer += 2;
        if (n == 49152) {
            return -1.0f;
        }
        if (n == 16384) {
            return 1.0f;
        }
        boolean bl2 = bl = (n & 0x8000) == 32768;
        if (bl) {
            return -((float)(n & 0x8000) / 16384.0f);
        }
        return (float)n / 16384.0f;
    }

    public byte[] readBytes(int n, int n2) {
        if (this.useArray) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.fontDataAsArray, n, byArray, 0, n2);
            return byArray;
        }
        return this.fontDataAsObject.getBytes(n, n2);
    }

    public int getType() {
        return this.type;
    }

    public int getFontCount() {
        return this.fontCount;
    }
}

