/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_Int
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    protected int[] items = new int[this.max_size];
    protected int defaultValue = 0;
    private int checkPoint = -1;

    public Vector_Int() {
    }

    protected int incrementSize(int n) {
        n = n < 8000 ? (n *= 4) : (n < 16000 ? (n *= 2) : (n += 2000));
        return n;
    }

    public Vector_Int(int n) {
        this.max_size = n;
        this.items = new int[this.max_size];
    }

    public final synchronized int elementAt(int n) {
        if (n >= this.max_size) {
            return 0;
        }
        return this.items[n];
    }

    public final int[] get() {
        return this.items;
    }

    public final void setElementAt(int n, int n2) {
        if (n2 >= this.max_size) {
            this.checkSize(n2);
        }
        this.items[n2] = n;
    }

    public final void set(int[] nArray) {
        this.items = nArray;
    }

    public final void keep_larger(int n, int n2) {
        if (this.items[n] < this.items[n2]) {
            this.items[n] = this.items[n2];
        }
    }

    public final void keep_smaller(int n, int n2) {
        if (this.items[n] > this.items[n2]) {
            this.items[n] = this.items[n2];
        }
    }

    public final void clear() {
        this.items = null;
        this.items = new int[this.max_size];
        if (this.defaultValue != 0) {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = this.defaultValue;
            }
        } else if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = 0;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = 0;
            }
        }
        this.current_item = 0;
    }

    public final synchronized int size() {
        return this.current_item + 1;
    }

    public final synchronized int getCapacity() {
        return this.items.length;
    }

    public final void removeElementAt(int n) {
        if (n >= 0) {
            System.arraycopy(this.items, n + 1, this.items, n, this.current_item - 1 - n);
            this.items[this.current_item - 1] = 0;
        } else {
            this.items[0] = 0;
        }
        --this.current_item;
    }

    public final synchronized void deleteElementWithValue(int n) {
        int n2 = this.items.length;
        int[] nArray = new int[n2 - 1];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (this.items[i] == n) continue;
            nArray[n3] = this.items[i];
            ++n3;
        }
        this.items = nArray;
        --this.current_item;
    }

    public String toString() {
        String string = "{";
        for (int i = 0; i < this.items.length; ++i) {
            string = string + ' ' + this.items[i];
        }
        return string + "} " + this.current_item;
    }

    public final boolean contains(int n) {
        boolean bl = false;
        for (int i = 0; i < this.current_item; ++i) {
            if (this.items[i] != n) continue;
            i = this.current_item + 1;
            bl = true;
        }
        return bl;
    }

    public final int pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(int n) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = n;
        ++this.current_item;
        this.checkSize(this.current_item);
    }

    public final void addElement(int n) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = n;
        ++this.current_item;
        this.checkSize(this.current_item);
    }

    public final void add_together(int n, int n2) {
        this.items[n] = this.items[n] + this.items[n2];
    }

    private final void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            int[] nArray = this.items;
            this.items = new int[this.max_size];
            int n3 = 0;
            if (this.defaultValue != 0) {
                for (n3 = n2; n3 < this.max_size; ++n3) {
                    this.items[n3] = this.defaultValue;
                }
            }
            System.arraycopy(nArray, 0, this.items, 0, n2);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }

    public final void reuse() {
        this.current_item = 0;
    }

    public void trim() {
        int[] nArray = new int[this.current_item];
        System.arraycopy(this.items, 0, nArray, 0, this.current_item);
        this.items = nArray;
        this.max_size = this.current_item;
    }

    public void setSize(int n) {
        this.current_item = n;
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.current_item = this.checkPoint = this.current_item;
        }
    }
}

