/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibHistogramOpImage;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ROI;
import javax.media.jai.util.ImagingListener;

public class MlibHistogramRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, true)) {
            return null;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        int n = renderedImage.getSampleModel().getDataType();
        if (n == 4 || n == 5) {
            return null;
        }
        ROI rOI = (ROI)parameterBlock.getObjectParameter(0);
        if (rOI != null && !rOI.equals(new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight()))) {
            return null;
        }
        int n2 = parameterBlock.getIntParameter(1);
        int n3 = parameterBlock.getIntParameter(2);
        int[] nArray = (int[])parameterBlock.getObjectParameter(3);
        double[] dArray = (double[])parameterBlock.getObjectParameter(4);
        double[] dArray2 = (double[])parameterBlock.getObjectParameter(5);
        MlibHistogramOpImage mlibHistogramOpImage = null;
        try {
            mlibHistogramOpImage = new MlibHistogramOpImage(renderedImage, n2, n3, nArray, dArray, dArray2);
        }
        catch (Exception exception) {
            ImagingListener imagingListener = ImageUtil.getImagingListener(renderingHints);
            String string = JaiI18N.getString("MlibHistogramRIF0");
            imagingListener.errorOccurred(string, exception, this, false);
        }
        return mlibHistogramOpImage;
    }
}

