/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.ASCII;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import sun.text.Normalizer;

public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private static final long serialVersionUID = 5073258162644648461L;
    private String pattern;
    private int flags;
    private transient String normalizedPattern;
    transient Node root;
    transient Node matchRoot;
    transient char[] buffer;
    transient GroupHead[] groupNodes;
    private transient char[] temp;
    transient int groupCount;
    transient int localCount;
    private transient int cursor;
    private transient int patternLength;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static final int INDEPENDENT = 3;
    static Node accept = new Node();
    static Node lastAccept = new LastNode();
    static HashMap families = null;
    static HashMap categories = null;
    private static final String[] familyNames = new String[]{"BasicLatin", "Latin-1Supplement", "LatinExtended-A", "LatinExtended-Bound", "IPAExtensions", "SpacingModifierLetters", "CombiningDiacriticalMarks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "HangulJamo", "Ethiopic", "Cherokee", "UnifiedCanadianAboriginalSyllabics", "Ogham", "Runic", "Khmer", "Mongolian", "LatinExtendedAdditional", "GreekExtended", "GeneralPunctuation", "SuperscriptsandSubscripts", "CurrencySymbols", "CombiningMarksforSymbols", "LetterlikeSymbols", "NumberForms", "Arrows", "MathematicalOperators", "MiscellaneousTechnical", "ControlPictures", "OpticalCharacterRecognition", "EnclosedAlphanumerics", "BoxDrawing", "BlockElements", "GeometricShapes", "MiscellaneousSymbols", "Dingbats", "BraillePatterns", "CJKRadicalsSupplement", "KangxiRadicals", "IdeographicDescriptionCharacters", "CJKSymbolsandPunctuation", "Hiragana", "Katakana", "Bopomofo", "HangulCompatibilityJamo", "Kanbun", "BopomofoExtended", "EnclosedCJKLettersandMonths", "CJKCompatibility", "CJKUnifiedIdeographsExtensionA", "CJKUnifiedIdeographs", "YiSyllables", "YiRadicals", "HangulSyllables", "HighSurrogates", "HighPrivateUseSurrogates", "LowSurrogates", "PrivateUse", "CJKCompatibilityIdeographs", "AlphabeticPresentationForms", "ArabicPresentationForms-A", "CombiningHalfMarks", "CJKCompatibilityForms", "SmallFormVariants", "ArabicPresentationForms-Bound", "Specials", "HalfwidthandFullwidthForms"};
    private static final String[] categoryNames = new String[]{"Cn", "Lu", "Ll", "Lt", "Lm", "Lo", "Mn", "Me", "Mc", "Nd", "Nl", "No", "Zs", "Zl", "Zp", "Cc", "Cf", "Co", "Cs", "Pd", "Ps", "Pe", "Pc", "Po", "Sm", "Sc", "Sk", "So", "L", "M", "N", "Z", "C", "P", "S", "LD", "L1", "all", "ASCII", "Alnum", "Alpha", "Blank", "Cntrl", "Digit", "Graph", "Lower", "Print", "Punct", "Space", "Upper", "XDigit"};
    private static final Node[] familyNodes = new Node[]{new Range(127), new Range(0x8000FF), new Range(16777599), new Range(25166415), new Range(38797999), new Range(45089535), new Range(50332527), new Range(57672703), new Range(0x40004FF), new Range(87033231), new Range(93324799), new Range(0x60006FF), new Range(117442383), new Range(125831103), new Range(150997375), new Range(159386111), new Range(167774847), new Range(176163583), new Range(184552319), new Range(192941055), new Range(201329791), new Range(209718527), new Range(218107263), new Range(226495999), new Range(234884735), new Range(243273471), new Range(0xF000FFF), new Range(268439711), new Range(278925567), new Range(0x110011FF), new Range(301994879), new Range(329257983), new Range(335550079), new Range(377493151), new Range(379590399), new Range(394270719), new Range(402659503), new Range(503324415), new Range(0x1F001FFF), new Range(536879215), new Range(544219295), new Range(547365071), new Range(550510847), new Range(553656655), new Range(558899599), new Range(563094015), new Range(0x220022FF), new Range(587211775), new Range(603989055), new Range(608183391), new Range(610280703), new Range(620766591), new Range(629155231), new Range(631252479), new Range(637544191), new Range(654321599), new Range(671099135), new Range(780152575), new Range(788541407), new Range(0x2FF02FFF), new Range(0x3000303F), new Range(809513119), new Range(815804671), new Range(822096175), new Range(825241999), new Range(831533471), new Range(832582079), new Range(838873855), new Range(0x330033FF), new Range(872435125), new Range(1308663807), new Range(-1610570609), new Range(-1534024497), new Range(-1409230941), new Range(-671032449), new Range(-612312065), new Range(-603922433), new Range(-536807169), new Range(-117376257), new Range(-83821745), new Range(-78578177), new Range(-31392209), new Range(-30343601), new Range(-28246417), new Range(-26149122), new Specials(), new Range(-16711697)};
    private static final Node[] categoryNodes = new Node[]{new Category(1), new Category(2), new Category(4), new Category(8), new Category(16), new Category(32), new Category(64), new Category(128), new Category(256), new Category(512), new Category(1024), new Category(2048), new Category(4096), new Category(8192), new Category(16384), new Category(32768), new Category(65536), new Category(262144), new Category(524288), new Category(0x100000), new Category(0x200000), new Category(0x400000), new Category(0x800000), new Category(0x1000000), new Category(0x2000000), new Category(0x4000000), new Category(0x8000000), new Category(0x10000000), new Category(62), new Category(448), new Category(3584), new Category(28672), new Category(884736), new Category(0x1F00000), new Category(0x1E000000), new Category(574), new Range(255), new All(), new Range(127), new Ctype(1792), new Ctype(768), new Ctype(16384), new Ctype(8192), new Range(0x300039), new Ctype(5888), new Range(6357114), new Range(2097278), new Ctype(4096), new Ctype(2048), new Range(4259930), new Ctype(32768)};

    public static Pattern compile(String regex) {
        return new Pattern(regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        return new Pattern(regex, flags);
    }

    public String pattern() {
        return this.pattern;
    }

    public Matcher matcher(CharSequence input) {
        Matcher m = new Matcher(this, input);
        return m;
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String regex, CharSequence input) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        return m.matches();
    }

    public String[] split(CharSequence input, int limit) {
        int resultSize;
        int index = 0;
        boolean matchLimited = limit > 0;
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher m = this.matcher(input);
        while (m.find()) {
            String match;
            if (!matchLimited || matchList.size() < limit - 1) {
                match = ((Object)input.subSequence(index, m.start())).toString();
                matchList.add(match);
                index = m.end();
                continue;
            }
            if (matchList.size() != limit - 1) continue;
            match = ((Object)input.subSequence(index, input.length())).toString();
            matchList.add(match);
            index = m.end();
        }
        if (index == 0) {
            return new String[]{((Object)input).toString()};
        }
        if (!matchLimited || matchList.size() < limit) {
            matchList.add(((Object)input.subSequence(index, input.length())).toString());
        }
        if (limit == 0) {
            for (resultSize = matchList.size(); resultSize > 0 && matchList.get(resultSize - 1).equals(""); --resultSize) {
            }
        }
        String[] result = new String[resultSize];
        return matchList.subList(0, resultSize).toArray(result);
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.groupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
        }
    }

    private Pattern(String p, int f) {
        this.pattern = p;
        this.flags = f;
        this.groupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
        }
    }

    private void normalize() {
        boolean inCharClass = false;
        char lastChar = '\uffff';
        this.normalizedPattern = Normalizer.decompose((String)this.pattern, (boolean)false, (int)0);
        this.patternLength = this.normalizedPattern.length();
        StringBuffer newPattern = new StringBuffer(this.patternLength);
        for (int i = 0; i < this.patternLength; ++i) {
            char c = this.normalizedPattern.charAt(i);
            if (Character.getType(c) == 6 && lastChar != '\uffff') {
                StringBuffer sequenceBuffer = new StringBuffer();
                sequenceBuffer.append(lastChar);
                sequenceBuffer.append(c);
                while (Character.getType(c) == 6 && ++i < this.patternLength) {
                    c = this.normalizedPattern.charAt(i);
                    sequenceBuffer.append(c);
                }
                String ea = this.produceEquivalentAlternation(sequenceBuffer.toString());
                newPattern.setLength(newPattern.length() - 1);
                newPattern.append("(?:").append(ea).append(")");
            } else if (c == '[' && lastChar != '\\') {
                i = this.normalizeCharClass(newPattern, i);
            } else {
                newPattern.append(c);
            }
            lastChar = c;
        }
        this.normalizedPattern = newPattern.toString();
    }

    private int normalizeCharClass(StringBuffer newPattern, int i) {
        char c;
        StringBuffer charClass = new StringBuffer();
        StringBuffer eq = null;
        char lastChar = '\uffff';
        ++i;
        charClass.append("[");
        while (true) {
            if ((c = this.normalizedPattern.charAt(i)) == ']' && lastChar != '\\') break;
            if (Character.getType(c) == 6) {
                StringBuffer sequenceBuffer = new StringBuffer();
                sequenceBuffer.append(lastChar);
                while (Character.getType(c) == 6) {
                    sequenceBuffer.append(c);
                    if (++i >= this.normalizedPattern.length()) break;
                    c = this.normalizedPattern.charAt(i);
                }
                String ea = this.produceEquivalentAlternation(sequenceBuffer.toString());
                charClass.setLength(charClass.length() - 1);
                if (eq == null) {
                    eq = new StringBuffer();
                }
                eq.append('|');
                eq.append(ea);
            } else {
                charClass.append(c);
                ++i;
            }
            if (i == this.normalizedPattern.length()) {
                this.error("Unclosed character class");
            }
            lastChar = c;
        }
        charClass.append(c);
        String result = eq != null ? new String("(?:" + charClass.toString() + eq.toString() + ")") : charClass.toString();
        newPattern.append(result);
        return i;
    }

    private String produceEquivalentAlternation(String source) {
        if (source.length() == 1) {
            return new String(source);
        }
        String base = source.substring(0, 1);
        String combiningMarks = source.substring(1);
        String[] perms = this.producePermutations(combiningMarks);
        StringBuffer result = new StringBuffer(source);
        for (int x = 0; x < perms.length; ++x) {
            String next = base + perms[x];
            if (x > 0) {
                result.append("|" + next);
            }
            if ((next = this.composeOneStep(next)) == null) continue;
            result.append("|" + this.produceEquivalentAlternation(next));
        }
        return result.toString();
    }

    private String[] producePermutations(String input) {
        if (input.length() == 1) {
            return new String[]{input};
        }
        if (input.length() == 2) {
            if (this.getClass(input.charAt(1)) == this.getClass(input.charAt(0))) {
                return new String[]{input};
            }
            String[] result = new String[2];
            result[0] = input;
            StringBuffer sb = new StringBuffer(2);
            sb.append(input.charAt(1));
            sb.append(input.charAt(0));
            result[1] = sb.toString();
            return result;
        }
        int length = 1;
        for (int x = 1; x < input.length(); ++x) {
            length *= x + 1;
        }
        String[] temp = new String[length];
        int[] combClass = new int[input.length()];
        for (int x = 0; x < input.length(); ++x) {
            combClass[x] = this.getClass(input.charAt(x));
        }
        int index = 0;
        block2: for (int x = 0; x < input.length(); ++x) {
            boolean skip = false;
            for (int y = x - 1; y >= 0; --y) {
                if (combClass[y] == combClass[x]) continue block2;
            }
            StringBuffer sb = new StringBuffer(input);
            String otherChars = sb.delete(x, x + 1).toString();
            String[] subResult = this.producePermutations(otherChars);
            String prefix = input.substring(x, x + 1);
            for (int y = 0; y < subResult.length; ++y) {
                temp[index++] = prefix + subResult[y];
            }
        }
        String[] result = new String[index];
        for (int x = 0; x < index; ++x) {
            result[x] = temp[x];
        }
        return result;
    }

    private int getClass(char c) {
        return Normalizer.getClass((int)c);
    }

    private String composeOneStep(String input) {
        String firstTwoChars = input.substring(0, 2);
        String result = Normalizer.compose((String)firstTwoChars, (boolean)false, (int)0);
        if (result.equals(firstTwoChars)) {
            return null;
        }
        String remainder = input.substring(2);
        return result + remainder;
    }

    private void compile() {
        if (this.has(128)) {
            this.normalize();
        } else {
            this.normalizedPattern = this.pattern;
        }
        this.patternLength = this.normalizedPattern.length();
        this.temp = new char[this.patternLength + 2];
        this.normalizedPattern.getChars(0, this.patternLength, this.temp, 0);
        this.temp[this.patternLength] = '\u0000';
        this.temp[this.patternLength + 1] = '\u0000';
        this.buffer = new char[32];
        this.groupNodes = new GroupHead[10];
        this.matchRoot = this.expr(lastAccept);
        if (this.patternLength != this.cursor) {
            if (this.peek() == 41) {
                this.error("Unmatched closing ')'");
            } else {
                this.error("Unexpected internal error");
            }
        }
        if (this.matchRoot instanceof Slice) {
            this.root = BnM.optimize(this.matchRoot);
            if (this.root == this.matchRoot) {
                this.root = new Start(this.matchRoot);
            }
        } else {
            this.root = this.matchRoot instanceof Begin || this.matchRoot instanceof First ? this.matchRoot : new Start(this.matchRoot);
        }
        this.temp = null;
        this.buffer = null;
        this.groupNodes = null;
        this.patternLength = 0;
    }

    private static void printObjectTree(Node node) {
        while (node != null) {
            if (node instanceof Prolog) {
                System.out.println(node);
                Pattern.printObjectTree(((Prolog)node).loop);
                System.out.println("**** end contents prolog loop");
            } else if (node instanceof Loop) {
                System.out.println(node);
                Pattern.printObjectTree(((Loop)node).body);
                System.out.println("**** end contents Loop body");
            } else if (node instanceof Curly) {
                System.out.println(node);
                Pattern.printObjectTree(((Curly)node).atom);
                System.out.println("**** end contents Curly body");
            } else {
                if (node instanceof GroupTail) {
                    System.out.println(node);
                    System.out.println("Tail next is " + node.next);
                    return;
                }
                System.out.println(node);
            }
            node = node.next;
            if (node != null) {
                System.out.println("->next:");
            }
            if (node != accept) continue;
            System.out.println("Accept Node");
            node = null;
        }
    }

    private boolean has(int f) {
        return (this.flags & f) > 0;
    }

    private void accept(int ch, String s) {
        int testChar = this.temp[this.cursor++];
        if (this.has(4)) {
            testChar = this.parsePastWhitespace(testChar);
        }
        if (ch != testChar) {
            this.error(s);
        }
    }

    private void mark(char c) {
        this.temp[this.patternLength] = c;
    }

    private int peek() {
        int ch = this.temp[this.cursor];
        if (this.has(4)) {
            ch = this.peekPastWhitespace(ch);
        }
        return ch;
    }

    private int read() {
        int ch = this.temp[this.cursor++];
        if (this.has(4)) {
            ch = this.parsePastWhitespace(ch);
        }
        return ch;
    }

    private int readEscaped() {
        char ch = this.temp[this.cursor++];
        return ch;
    }

    private int next() {
        int ch = this.temp[++this.cursor];
        if (this.has(4)) {
            ch = this.peekPastWhitespace(ch);
        }
        return ch;
    }

    private int nextEscaped() {
        char ch = this.temp[++this.cursor];
        return ch;
    }

    private int peekPastWhitespace(int ch) {
        while (ASCII.isSpace(ch) || ch == 35) {
            while (ASCII.isSpace(ch)) {
                ch = this.temp[++this.cursor];
            }
            if (ch != 35) continue;
            ch = this.peekPastLine();
        }
        return ch;
    }

    private int parsePastWhitespace(int ch) {
        while (ASCII.isSpace(ch) || ch == 35) {
            while (ASCII.isSpace(ch)) {
                ch = this.temp[this.cursor++];
            }
            if (ch != 35) continue;
            ch = this.parsePastLine();
        }
        return ch;
    }

    private int parsePastLine() {
        char ch = this.temp[this.cursor++];
        while (ch != '\u0000' && !this.isLineSeparator(ch)) {
            ch = this.temp[this.cursor++];
        }
        return ch;
    }

    private int peekPastLine() {
        char ch = this.temp[++this.cursor];
        while (ch != '\u0000' && !this.isLineSeparator(ch)) {
            ch = this.temp[++this.cursor];
        }
        return ch;
    }

    private boolean isLineSeparator(int ch) {
        if (this.has(1)) {
            return ch == 10;
        }
        return ch == 10 || ch == 13 || (ch | 1) == 8233 || ch == 133;
    }

    private int skip() {
        int i = this.cursor;
        char ch = this.temp[i + 1];
        this.cursor = i + 2;
        return ch;
    }

    private void unread() {
        --this.cursor;
    }

    private Node error(String s) {
        throw new PatternSyntaxException(s, this.normalizedPattern, this.cursor - 1);
    }

    private Node expr(Node end) {
        Node prev = null;
        while (true) {
            Node node = this.sequence(end);
            prev = prev == null ? node : new Branch(prev, node);
            if (this.peek() != 124) {
                return prev;
            }
            this.next();
        }
    }

    private Node sequence(Node end) {
        Node head = null;
        Node tail = null;
        Node node = null;
        block12: while (true) {
            int ch = this.peek();
            switch (ch) {
                case 40: {
                    node = this.group0();
                    if (node == null) continue block12;
                    if (head == null) {
                        head = node;
                    } else {
                        tail.next = node;
                    }
                    tail = this.root;
                    continue block12;
                }
                case 91: {
                    node = this.clazz(true);
                    break;
                }
                case 92: {
                    ch = this.nextEscaped();
                    if (ch == 112 || ch == 80) {
                        boolean comp = ch == 80;
                        boolean oneLetter = true;
                        ch = this.next();
                        if (ch != 123) {
                            this.unread();
                        } else {
                            oneLetter = false;
                        }
                        node = this.family(comp, oneLetter);
                        break;
                    }
                    this.unread();
                    node = this.atom();
                    break;
                }
                case 94: {
                    this.next();
                    if (this.has(8)) {
                        if (this.has(1)) {
                            node = new UnixCaret();
                            break;
                        }
                        node = new Caret();
                        break;
                    }
                    node = new Begin();
                    break;
                }
                case 36: {
                    this.next();
                    if (this.has(1)) {
                        node = new UnixDollar(this.has(8));
                        break;
                    }
                    node = new Dollar(this.has(8));
                    break;
                }
                case 46: {
                    this.next();
                    if (this.has(32)) {
                        node = new All();
                        break;
                    }
                    if (this.has(1)) {
                        node = new UnixDot();
                        break;
                    }
                    node = new Dot();
                    break;
                }
                case 41: 
                case 124: {
                    break block12;
                }
                case 93: 
                case 125: {
                    node = this.atom();
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    this.next();
                    return this.error("Dangling meta character '" + (char)ch + "'");
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block12;
                }
                default: {
                    node = this.atom();
                }
            }
            node = this.closure(node);
            if (head == null) {
                head = tail = node;
                continue;
            }
            tail.next = node;
            tail = node;
        }
        if (head == null) {
            return end;
        }
        tail.next = end;
        return head;
    }

    private Node atom() {
        int first = 0;
        int prev = -1;
        int ch = this.peek();
        block6: while (true) {
            switch (ch) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (first <= true) break block6;
                    this.cursor = prev;
                    --first;
                    break block6;
                }
                case 36: 
                case 40: 
                case 41: 
                case 46: 
                case 91: 
                case 94: 
                case 124: {
                    break block6;
                }
                case 92: {
                    ch = this.nextEscaped();
                    if (ch == 112 || ch == 80) {
                        if (first > 0) {
                            this.unread();
                            break block6;
                        }
                        if (ch != 112 && ch != 80) break block6;
                        boolean comp = ch == 80;
                        boolean oneLetter = true;
                        ch = this.next();
                        if (ch != 123) {
                            this.unread();
                        } else {
                            oneLetter = false;
                        }
                        return this.family(comp, oneLetter);
                    }
                    this.unread();
                    prev = this.cursor;
                    ch = this.escape(false, first == 0);
                    if (ch >= 0) {
                        this.append(ch, first);
                        ++first;
                        ch = this.peek();
                        continue block6;
                    }
                    if (first == 0) {
                        return this.root;
                    }
                    this.cursor = prev;
                    break block6;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block6;
                }
                default: {
                    prev = this.cursor;
                    this.append(ch, first);
                    ++first;
                    ch = this.next();
                    continue block6;
                }
            }
            break;
        }
        if (first == 1) {
            return this.newSingle(this.buffer[0]);
        }
        return this.newSlice(this.buffer, first);
    }

    private void append(int ch, int len) {
        if (len >= this.buffer.length) {
            char[] tmp = new char[len + len];
            System.arraycopy(this.buffer, 0, tmp, 0, len);
            this.buffer = tmp;
        }
        this.buffer[len] = (char)ch;
    }

    private Node ref(int refNum) {
        boolean done = false;
        block3: while (!done) {
            int ch = this.peek();
            switch (ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int newRefNum = refNum * 10 + (ch - 48);
                    if (this.groupCount - 1 < newRefNum) {
                        done = true;
                        continue block3;
                    }
                    refNum = newRefNum;
                    this.read();
                    continue block3;
                }
            }
            done = true;
        }
        if (this.has(2)) {
            return new CIBackRef(refNum);
        }
        return new BackRef(refNum);
    }

    private int escape(boolean inclass, boolean create) {
        int ch = this.skip();
        switch (ch) {
            case 48: {
                return this.o();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (inclass) break;
                if (this.groupCount < ch - 48) {
                    this.error("No such group yet exists at this point in the pattern");
                }
                if (create) {
                    this.root = this.ref(ch - 48);
                }
                return -1;
            }
            case 65: {
                if (inclass) break;
                if (create) {
                    this.root = new Begin();
                }
                return -1;
            }
            case 66: {
                if (inclass) break;
                if (create) {
                    this.root = new Bound(Bound.NONE);
                }
                return -1;
            }
            case 67: {
                break;
            }
            case 68: {
                if (create) {
                    this.root = new NotCtype(1024);
                }
                return -1;
            }
            case 69: 
            case 70: {
                break;
            }
            case 71: {
                if (inclass) break;
                if (create) {
                    this.root = new LastMatch();
                }
                return -1;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                break;
            }
            case 81: {
                if (create) {
                    int c;
                    int i = this.cursor;
                    while ((c = this.readEscaped()) != 0 && (c != 92 || (c = this.readEscaped()) != 69 && c != 0)) {
                    }
                    int j = this.cursor - 1;
                    if (c == 69) {
                        --j;
                    } else {
                        this.unread();
                    }
                    for (int x = i; x < j; ++x) {
                        this.append(this.temp[x], x - i);
                    }
                    this.root = this.newSlice(this.buffer, j - i);
                }
                return -1;
            }
            case 82: {
                break;
            }
            case 83: {
                if (create) {
                    this.root = new NotCtype(2048);
                }
                return -1;
            }
            case 84: 
            case 85: 
            case 86: {
                break;
            }
            case 87: {
                if (create) {
                    this.root = new NotCtype(67328);
                }
                return -1;
            }
            case 88: 
            case 89: {
                break;
            }
            case 90: {
                if (inclass) break;
                if (create) {
                    this.root = this.has(1) ? new UnixDollar(false) : new Dollar(false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 98: {
                if (inclass) break;
                if (create) {
                    this.root = new Bound(Bound.BOTH);
                }
                return -1;
            }
            case 99: {
                return this.c();
            }
            case 100: {
                if (create) {
                    this.root = new Ctype(1024);
                }
                return -1;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                break;
            }
            case 110: {
                return 10;
            }
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            case 114: {
                return 13;
            }
            case 115: {
                if (create) {
                    this.root = new Ctype(2048);
                }
                return -1;
            }
            case 116: {
                return 9;
            }
            case 117: {
                return this.u();
            }
            case 118: {
                return 11;
            }
            case 119: {
                if (create) {
                    this.root = new Ctype(67328);
                }
                return -1;
            }
            case 120: {
                return this.x();
            }
            case 121: {
                break;
            }
            case 122: {
                if (inclass) break;
                if (create) {
                    this.root = new End();
                }
                return -1;
            }
            default: {
                return ch;
            }
        }
        this.error("Illegal/unsupported escape squence");
        return -2;
    }

    private Node clazz(boolean consume) {
        Node prev = null;
        Node node = null;
        BitClass bits = new BitClass(false);
        boolean include = true;
        boolean firstInClass = true;
        int ch = this.next();
        block7: while (true) {
            switch (ch) {
                case 94: {
                    if (!firstInClass || this.temp[this.cursor - 1] != '[') break;
                    ch = this.next();
                    include = !include;
                    continue block7;
                }
                case 91: {
                    firstInClass = false;
                    node = this.clazz(true);
                    prev = prev == null ? node : new Add(prev, node);
                    ch = this.peek();
                    continue block7;
                }
                case 38: {
                    firstInClass = false;
                    ch = this.next();
                    if (ch == 38) {
                        ch = this.next();
                        Node rightNode = null;
                        while (ch != 93 && ch != 38) {
                            if (ch == 91) {
                                rightNode = rightNode == null ? this.clazz(true) : new Add(rightNode, this.clazz(true));
                            } else {
                                this.unread();
                                rightNode = this.clazz(false);
                            }
                            ch = this.peek();
                        }
                        if (rightNode != null) {
                            node = rightNode;
                        }
                        if (prev == null) {
                            if (rightNode == null) {
                                return this.error("Bad class syntax");
                            }
                            prev = rightNode;
                            continue block7;
                        }
                        prev = new Both(prev, node);
                        continue block7;
                    }
                    this.unread();
                    break;
                }
                case 0: {
                    firstInClass = false;
                    if (this.cursor < this.patternLength) break;
                    return this.error("Unclosed character class");
                }
                case 93: {
                    firstInClass = false;
                    if (prev == null) break;
                    if (consume) {
                        this.next();
                    }
                    return prev;
                }
                default: {
                    firstInClass = false;
                }
            }
            node = this.range(bits);
            if (include) {
                if (prev == null) {
                    prev = node;
                } else if (prev != node) {
                    prev = new Add(prev, node);
                }
            } else if (prev == null) {
                prev = node.dup(true);
            } else if (prev != node) {
                prev = new Sub(prev, node);
            }
            ch = this.peek();
        }
    }

    private Node range(BitClass bits) {
        int ch = this.peek();
        if (ch == 92) {
            ch = this.nextEscaped();
            if (ch == 112 || ch == 80) {
                boolean comp = ch == 80;
                boolean oneLetter = true;
                ch = this.next();
                if (ch != 123) {
                    this.unread();
                } else {
                    oneLetter = false;
                }
                return this.family(comp, oneLetter);
            }
            this.unread();
            ch = this.escape(true, true);
            if (ch == -1) {
                return this.root;
            }
        } else {
            ch = this.single();
        }
        if (ch >= 0) {
            if (this.peek() == 45) {
                char endRange = this.temp[this.cursor + 1];
                if (endRange == '[') {
                    if (ch < 256) {
                        return bits.add(ch, this.flags());
                    }
                    return this.newSingle(ch);
                }
                if (endRange != ']') {
                    this.next();
                    int m = this.single();
                    if (m < ch) {
                        return this.error("Illegal character range");
                    }
                    if (this.has(2)) {
                        return new CIRange((ch << 16) + m);
                    }
                    return new Range((ch << 16) + m);
                }
            }
            if (ch < 256) {
                return bits.add(ch, this.flags());
            }
            return this.newSingle(ch);
        }
        return this.error("Unexpected character '" + (char)ch + "'");
    }

    private int single() {
        int ch = this.peek();
        switch (ch) {
            case 92: {
                return this.escape(true, false);
            }
        }
        this.next();
        return ch;
    }

    private Node family(boolean not, boolean singleLetter) {
        String name;
        this.next();
        if (singleLetter) {
            name = new String(this.temp, this.cursor, 1).intern();
            this.read();
        } else {
            int i = this.cursor;
            this.mark('}');
            while (this.read() != 125) {
            }
            this.mark('\u0000');
            int j = this.cursor;
            if (j > this.patternLength) {
                return this.error("Unclosed character family");
            }
            if (i + 1 >= j) {
                return this.error("Empty character family");
            }
            name = new String(this.temp, i, j - i - 1).intern();
        }
        if (name.startsWith("In")) {
            name = name.substring(2, name.length()).intern();
            return this.retrieveFamilyNode(name).dup(not);
        }
        if (name.startsWith("Is")) {
            name = name.substring(2, name.length()).intern();
        }
        return this.retrieveCategoryNode(name).dup(not);
    }

    private Node retrieveFamilyNode(String name) {
        Node n;
        if (families == null) {
            int fns = familyNodes.length;
            families = new HashMap((int)((double)fns / 0.75) + 1);
            for (int x = 0; x < fns; ++x) {
                families.put(familyNames[x], familyNodes[x]);
            }
        }
        if ((n = (Node)families.get(name)) != null) {
            return n;
        }
        return this.familyError(name, "Unknown character family {");
    }

    private Node retrieveCategoryNode(String name) {
        Node n;
        if (categories == null) {
            int cns = categoryNodes.length;
            categories = new HashMap((int)((double)cns / 0.75) + 1);
            for (int x = 0; x < cns; ++x) {
                categories.put(categoryNames[x], categoryNodes[x]);
            }
        }
        if ((n = (Node)categories.get(name)) != null) {
            return n;
        }
        return this.familyError(name, "Unknown character category {");
    }

    private Node familyError(String name, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append(type);
        sb.append(name);
        sb.append("}");
        name = sb.toString();
        return this.error(name);
    }

    private Node group0() {
        Node head = null;
        Node tail = null;
        int save = this.flags;
        this.root = null;
        int ch = this.next();
        if (ch == 63) {
            ch = this.skip();
            switch (ch) {
                case 58: {
                    head = this.createGroup(true);
                    tail = this.root;
                    head.next = this.expr(tail);
                    break;
                }
                case 33: 
                case 61: {
                    head = this.createGroup(true);
                    tail = this.root;
                    head.next = this.expr(tail);
                    if (ch == 61) {
                        head = tail = new Pos(head);
                        break;
                    }
                    head = tail = new Neg(head);
                    break;
                }
                case 62: {
                    head = this.createGroup(true);
                    tail = this.root;
                    head.next = this.expr(tail);
                    head = tail = new Ques(head, 3);
                    break;
                }
                case 60: {
                    ch = this.read();
                    head = this.createGroup(true);
                    tail = this.root;
                    head.next = this.expr(tail);
                    TreeInfo info = new TreeInfo();
                    head.study(info);
                    if (!info.maxValid) {
                        return this.error("Look-behind group does not have an obvious maximum length");
                    }
                    if (ch == 61) {
                        head = tail = new Behind(head, info.maxLength, info.minLength);
                        break;
                    }
                    if (ch == 33) {
                        head = tail = new NotBehind(head, info.maxLength, info.minLength);
                        break;
                    }
                    this.error("Unknown look-behind group");
                    break;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (this.groupNodes[ch - 48] != null) {
                        head = tail = new GroupRef(this.groupNodes[ch - 48]);
                        break;
                    }
                    return this.error("Unknown group reference");
                }
                case 36: 
                case 64: {
                    return this.error("Unknown group type");
                }
                default: {
                    this.unread();
                    this.addFlag();
                    ch = this.read();
                    if (ch == 41) {
                        return null;
                    }
                    if (ch != 58) {
                        return this.error("Unknown inline modifier");
                    }
                    head = this.createGroup(true);
                    tail = this.root;
                    head.next = this.expr(tail);
                    break;
                }
            }
        } else {
            head = this.createGroup(false);
            tail = this.root;
            head.next = this.expr(tail);
        }
        this.accept(41, "Unclosed group");
        this.flags = save;
        Node node = this.closure(head);
        if (node == head) {
            this.root = tail;
            return node;
        }
        if (head == tail) {
            this.root = node;
            return node;
        }
        if (node instanceof Ques) {
            Ques ques = (Ques)node;
            if (ques.type == 2) {
                this.root = node;
                return node;
            }
            tail = tail.next = new Dummy();
            head = ques.type == 0 ? new Branch(head, tail) : new Branch(tail, head);
            this.root = tail;
            return head;
        }
        if (node instanceof Curly) {
            Curly curly = (Curly)node;
            if (curly.type == 2) {
                this.root = node;
                return node;
            }
            TreeInfo info = new TreeInfo();
            if (head.study(info)) {
                GroupTail temp = (GroupTail)tail;
                head = this.root = new GroupCurly(head.next, curly.cmin, curly.cmax, curly.type, ((GroupTail)tail).localIndex, ((GroupTail)tail).groupIndex);
                return head;
            }
            int temp = ((GroupHead)head).localIndex;
            Loop loop = curly.type == 0 ? new Loop(this.localCount, temp) : new LazyLoop(this.localCount, temp);
            Prolog prolog = new Prolog(loop);
            ++this.localCount;
            loop.cmin = curly.cmin;
            loop.cmax = curly.cmax;
            loop.body = head;
            tail.next = loop;
            this.root = loop;
            return prolog;
        }
        if (node instanceof First) {
            this.root = node;
            return node;
        }
        return this.error("Internal logic error");
    }

    private Node createGroup(boolean anonymous) {
        int localIndex = this.localCount++;
        int groupIndex = 0;
        if (!anonymous) {
            groupIndex = this.groupCount++;
        }
        GroupHead head = new GroupHead(localIndex);
        this.root = new GroupTail(localIndex, groupIndex);
        if (!anonymous && groupIndex < 10) {
            this.groupNodes[groupIndex] = head;
        }
        return head;
    }

    private void addFlag() {
        int ch = this.peek();
        while (true) {
            switch (ch) {
                case 105: {
                    this.flags |= 2;
                    break;
                }
                case 109: {
                    this.flags |= 8;
                    break;
                }
                case 115: {
                    this.flags |= 0x20;
                    break;
                }
                case 100: {
                    this.flags |= 1;
                    break;
                }
                case 117: {
                    this.flags |= 0x40;
                    break;
                }
                case 99: {
                    this.flags |= 0x80;
                    break;
                }
                case 120: {
                    this.flags |= 4;
                    break;
                }
                case 45: {
                    ch = this.next();
                    this.subFlag();
                }
                default: {
                    return;
                }
            }
            ch = this.next();
        }
    }

    private void subFlag() {
        int ch = this.peek();
        while (true) {
            switch (ch) {
                case 105: {
                    this.flags &= 0xFFFFFFFD;
                    break;
                }
                case 109: {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 115: {
                    this.flags &= 0xFFFFFFDF;
                    break;
                }
                case 100: {
                    this.flags &= 0xFFFFFFFE;
                    break;
                }
                case 117: {
                    this.flags &= 0xFFFFFFBF;
                    break;
                }
                case 99: {
                    this.flags &= 0xFFFFFF7F;
                    break;
                }
                case 120: {
                    this.flags &= 0xFFFFFFFB;
                    break;
                }
                default: {
                    return;
                }
            }
            ch = this.next();
        }
    }

    private Node closure(Node prev) {
        int ch = this.peek();
        switch (ch) {
            case 63: {
                ch = this.next();
                if (ch == 63) {
                    this.next();
                    return new Ques(prev, 1);
                }
                if (ch == 43) {
                    this.next();
                    return new Ques(prev, 2);
                }
                return new Ques(prev, 0);
            }
            case 42: {
                ch = this.next();
                if (ch == 63) {
                    this.next();
                    return new Curly(prev, 0, Integer.MAX_VALUE, 1);
                }
                if (ch == 43) {
                    this.next();
                    return new Curly(prev, 0, Integer.MAX_VALUE, 2);
                }
                return new Curly(prev, 0, Integer.MAX_VALUE, 0);
            }
            case 43: {
                ch = this.next();
                if (ch == 63) {
                    this.next();
                    return new Curly(prev, 1, Integer.MAX_VALUE, 1);
                }
                if (ch == 43) {
                    this.next();
                    return new Curly(prev, 1, Integer.MAX_VALUE, 2);
                }
                return new Curly(prev, 1, Integer.MAX_VALUE, 0);
            }
            case 123: {
                ch = this.temp[this.cursor + 1];
                if (ASCII.isDigit(ch)) {
                    Curly curly;
                    this.skip();
                    int cmin = 0;
                    do {
                        cmin = cmin * 10 + (ch - 48);
                    } while (ASCII.isDigit(ch = this.read()));
                    int cmax = cmin;
                    if (ch == 44) {
                        ch = this.read();
                        cmax = Integer.MAX_VALUE;
                        if (ch != 125) {
                            cmax = 0;
                            while (ASCII.isDigit(ch)) {
                                cmax = cmax * 10 + (ch - 48);
                                ch = this.read();
                            }
                        }
                    }
                    if (ch != 125) {
                        return this.error("Unclosed counted closure");
                    }
                    if ((cmin | cmax | cmax - cmin) < 0) {
                        return this.error("Illegal repetition range");
                    }
                    ch = this.peek();
                    if (ch == 63) {
                        this.next();
                        curly = new Curly(prev, cmin, cmax, 1);
                    } else if (ch == 43) {
                        this.next();
                        curly = new Curly(prev, cmin, cmax, 2);
                    } else {
                        curly = new Curly(prev, cmin, cmax, 0);
                    }
                    return curly;
                }
                this.error("Illegal repetition");
                return prev;
            }
        }
        return prev;
    }

    private int c() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        this.error("Illegal control escape sequence");
        return -1;
    }

    private int o() {
        int n = this.read();
        if ((n - 48 | 55 - n) >= 0) {
            int m = this.read();
            if ((m - 48 | 55 - m) >= 0) {
                int o = this.read();
                if ((o - 48 | 55 - o) >= 0 && (n - 48 | 51 - n) >= 0) {
                    return (n - 48) * 64 + (m - 48) * 8 + (o - 48);
                }
                this.unread();
                return (n - 48) * 8 + (m - 48);
            }
            this.unread();
            return n - 48;
        }
        this.error("Illegal octal escape sequence");
        return -1;
    }

    private int x() {
        int m;
        int n = this.read();
        if (ASCII.isHexDigit(n) && ASCII.isHexDigit(m = this.read())) {
            return ASCII.toDigit(n) * 16 + ASCII.toDigit(m);
        }
        this.error("Illegal hexadecimal escape sequence");
        return -1;
    }

    private int u() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int ch = this.read();
            if (!ASCII.isHexDigit(ch)) {
                this.error("Illegal Unicode escape sequence");
            }
            n = n * 16 + ASCII.toDigit(ch);
        }
        return n;
    }

    private Node newSingle(int ch) {
        int f = this.flags;
        if ((f & 2) == 0) {
            return new Single(ch);
        }
        if ((f & 0x40) == 0) {
            return new SingleA(ch);
        }
        return new SingleU(ch);
    }

    private Node newSlice(char[] buf, int count) {
        char[] tmp = new char[count];
        int i = this.flags;
        if ((i & 2) == 0) {
            for (i = 0; i < count; ++i) {
                tmp[i] = buf[i];
            }
            return new Slice(tmp);
        }
        if ((i & 0x40) == 0) {
            for (i = 0; i < count; ++i) {
                tmp[i] = (char)ASCII.toLower(buf[i]);
            }
            return new SliceA(tmp);
        }
        for (i = 0; i < count; ++i) {
            char c = buf[i];
            c = Character.toUpperCase(c);
            tmp[i] = c = Character.toLowerCase(c);
        }
        return new SliceU(tmp);
    }

    static final class BnM
    extends Node {
        char[] buffer;
        int[] lastOcc;
        int[] optoSft;

        static Node optimize(Node node) {
            int i;
            if (!(node instanceof Slice)) {
                return node;
            }
            char[] src = ((Slice)node).buffer;
            int patternLength = src.length;
            if (patternLength < 4) {
                return node;
            }
            int[] lastOcc = new int[128];
            int[] optoSft = new int[patternLength];
            for (i = 0; i < patternLength; ++i) {
                lastOcc[src[i] & 0x7F] = i + 1;
            }
            block1: for (i = patternLength; i > 0; --i) {
                int j;
                for (j = patternLength - 1; j >= i; --j) {
                    if (src[j] != src[j - i]) continue block1;
                    optoSft[j - 1] = i;
                }
                while (j > 0) {
                    optoSft[--j] = i;
                }
            }
            optoSft[patternLength - 1] = 1;
            return new BnM(src, lastOcc, optoSft, node.next);
        }

        BnM(char[] src, int[] lastOcc, int[] optoSft, Node next) {
            this.buffer = src;
            this.lastOcc = lastOcc;
            this.optoSft = optoSft;
            this.next = next;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            char[] src = this.buffer;
            int patternLength = src.length;
            int last = matcher.to - patternLength;
            block0: while (i <= last) {
                for (int j = patternLength - 1; j >= 0; --j) {
                    char ch = seq.charAt(i + j);
                    if (ch == src[j]) continue;
                    i += Math.max(j + 1 - this.lastOcc[ch & 0x7F], this.optoSft[j]);
                    continue block0;
                }
                matcher.first = i;
                boolean ret = this.next.match(matcher, i + patternLength, seq);
                if (ret) {
                    matcher.groups[0] = matcher.first = i;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++i;
            }
            return false;
        }

        boolean study(TreeInfo info) {
            info.minLength += this.buffer.length;
            info.maxValid = false;
            return this.next.study(info);
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;

        Bound(int n) {
            this.type = n;
        }

        int check(Matcher matcher, int i, CharSequence seq) {
            char ch;
            boolean left = false;
            if (i > matcher.from) {
                ch = seq.charAt(i - 1);
                left = ch == '_' || Character.isLetterOrDigit(ch);
            }
            boolean right = false;
            if (i < matcher.to) {
                ch = seq.charAt(i);
                boolean bl = right = ch == '_' || Character.isLetterOrDigit(ch);
            }
            return left ^ right ? (right ? LEFT : RIGHT) : NONE;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return (this.check(matcher, i, seq) & this.type) > 0 && this.next.match(matcher, i, seq);
        }
    }

    static final class Sub
    extends Add {
        Sub(Node lhs, Node rhs) {
            super(lhs, rhs);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                return !this.rhs.match(matcher, i, seq) && this.lhs.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
            }
            return false;
        }

        boolean study(TreeInfo info) {
            this.lhs.study(info);
            return this.next.study(info);
        }
    }

    static class Both
    extends Node {
        Node lhs;
        Node rhs;

        Both(Node lhs, Node rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                return this.lhs.match(matcher, i, seq) && this.rhs.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
            }
            return false;
        }

        boolean study(TreeInfo info) {
            boolean maxV = info.maxValid;
            boolean detm = info.deterministic;
            int minL = info.minLength;
            int maxL = info.maxLength;
            this.lhs.study(info);
            int minL2 = info.minLength;
            int maxL2 = info.maxLength;
            info.minLength = minL;
            info.maxLength = maxL;
            this.rhs.study(info);
            info.minLength = Math.min(minL2, info.minLength);
            info.maxLength = Math.max(maxL2, info.maxLength);
            info.maxValid = maxV;
            info.deterministic = detm;
            return this.next.study(info);
        }
    }

    static class Add
    extends Node {
        Node lhs;
        Node rhs;

        Add(Node lhs, Node rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                return (this.lhs.match(matcher, i, seq) || this.rhs.match(matcher, i, seq)) && this.next.match(matcher, matcher.last, seq);
            }
            return false;
        }

        boolean study(TreeInfo info) {
            boolean maxV = info.maxValid;
            boolean detm = info.deterministic;
            int minL = info.minLength;
            int maxL = info.maxLength;
            this.lhs.study(info);
            int minL2 = info.minLength;
            int maxL2 = info.maxLength;
            info.minLength = minL;
            info.maxLength = maxL;
            this.rhs.study(info);
            info.minLength = Math.min(minL2, info.minLength);
            info.maxLength = Math.max(maxL2, info.maxLength);
            info.maxValid = maxV;
            info.deterministic = detm;
            return this.next.study(info);
        }
    }

    static final class NotBehind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        NotBehind(Node cond, int rmax, int rmin) {
            this.cond = cond;
            this.rmax = rmax;
            this.rmin = rmin;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int from = Math.max(i - this.rmax, matcher.from);
            for (int j = i - this.rmin; j >= from; --j) {
                if (!this.cond.match(matcher, j, seq) || matcher.last != i) continue;
                return false;
            }
            return this.next.match(matcher, i, seq);
        }
    }

    static final class Behind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        Behind(Node cond, int rmax, int rmin) {
            this.cond = cond;
            this.rmax = rmax;
            this.rmin = rmin;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int from = Math.max(i - this.rmax, matcher.from);
            for (int j = i - this.rmin; j >= from; --j) {
                if (!this.cond.match(matcher, j, seq) || matcher.last != i) continue;
                return this.next.match(matcher, i, seq);
            }
            return false;
        }
    }

    static final class Neg
    extends Node {
        Node cond;

        Neg(Node cond) {
            this.cond = cond;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return !this.cond.match(matcher, i, seq) && this.next.match(matcher, i, seq);
        }
    }

    static final class Pos
    extends Node {
        Node cond;

        Pos(Node cond) {
            this.cond = cond;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.cond.match(matcher, i, seq) && this.next.match(matcher, i, seq);
        }
    }

    static final class Conditional
    extends Node {
        Node cond;
        Node yes;
        Node not;

        Conditional(Node cond, Node yes, Node not) {
            this.cond = cond;
            this.yes = yes;
            this.not = not;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (this.cond.match(matcher, i, seq)) {
                return this.yes.match(matcher, i, seq);
            }
            return this.not.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            info.reset();
            this.yes.study(info);
            int minL2 = info.minLength;
            int maxL2 = info.maxLength;
            boolean maxV2 = info.maxValid;
            info.reset();
            this.not.study(info);
            info.minLength = minL + Math.min(minL2, info.minLength);
            info.maxLength = maxL + Math.max(maxL2, info.maxLength);
            info.maxValid = maxV & maxV2 & info.maxValid;
            info.deterministic = false;
            return this.next.study(info);
        }
    }

    static final class First
    extends Node {
        Node atom;

        First(Node node) {
            this.atom = BnM.optimize(node);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (this.atom instanceof BnM) {
                return this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
            }
            while (i <= matcher.to) {
                if (this.atom.match(matcher, i, seq)) {
                    return this.next.match(matcher, matcher.last, seq);
                }
                ++i;
                ++matcher.first;
            }
            return false;
        }

        boolean study(TreeInfo info) {
            this.atom.study(info);
            info.maxValid = false;
            info.deterministic = false;
            return this.next.study(info);
        }
    }

    static class CIBackRef
    extends Node {
        int groupIndex;

        CIBackRef(int groupCount) {
            this.groupIndex = groupCount + groupCount;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j = matcher.groups[this.groupIndex];
            int k = matcher.groups[this.groupIndex + 1];
            int groupSize = k - j;
            if (j < 0) {
                return false;
            }
            if (i + groupSize > matcher.to) {
                return false;
            }
            for (int index = 0; index < groupSize; ++index) {
                char c2;
                char c1 = seq.charAt(i + index);
                if (c1 == (c2 = seq.charAt(j + index)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return false;
            }
            return this.next.match(matcher, i + groupSize, seq);
        }

        boolean study(TreeInfo info) {
            info.maxValid = false;
            return this.next.study(info);
        }
    }

    static class BackRef
    extends Node {
        int groupIndex;

        BackRef(int groupCount) {
            this.groupIndex = groupCount + groupCount;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j = matcher.groups[this.groupIndex];
            int k = matcher.groups[this.groupIndex + 1];
            int groupSize = k - j;
            if (j < 0) {
                return false;
            }
            if (i + groupSize > matcher.to) {
                return false;
            }
            for (int index = 0; index < groupSize; ++index) {
                if (seq.charAt(i + index) == seq.charAt(j + index)) continue;
                return false;
            }
            return this.next.match(matcher, i + groupSize, seq);
        }

        boolean study(TreeInfo info) {
            info.maxValid = false;
            return this.next.study(info);
        }
    }

    static final class LazyLoop
    extends Loop {
        LazyLoop(int countIndex, int beginIndex) {
            super(countIndex, beginIndex);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.locals[this.beginIndex]) {
                int count = matcher.locals[this.countIndex];
                if (count < this.cmin) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean result = this.body.match(matcher, i, seq);
                    if (!result) {
                        matcher.locals[this.countIndex] = count;
                    }
                    return result;
                }
                if (this.next.match(matcher, i, seq)) {
                    return true;
                }
                if (count < this.cmax) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean result = this.body.match(matcher, i, seq);
                    if (!result) {
                        matcher.locals[this.countIndex] = count;
                    }
                    return result;
                }
                return false;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean matchInit(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.locals[this.countIndex];
            boolean ret = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
            } else if (this.next.match(matcher, i, seq)) {
                ret = true;
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
            }
            matcher.locals[this.countIndex] = save;
            return ret;
        }

        boolean study(TreeInfo info) {
            info.maxValid = false;
            info.deterministic = false;
            return false;
        }
    }

    static class Loop
    extends Node {
        Node body;
        int countIndex;
        int beginIndex;
        int cmin;
        int cmax;

        Loop(int countIndex, int beginIndex) {
            this.countIndex = countIndex;
            this.beginIndex = beginIndex;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.locals[this.beginIndex]) {
                int count = matcher.locals[this.countIndex];
                if (count < this.cmin) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean b = this.body.match(matcher, i, seq);
                    if (!b) {
                        matcher.locals[this.countIndex] = count;
                    }
                    return b;
                }
                if (count < this.cmax) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean b = this.body.match(matcher, i, seq);
                    if (!b) {
                        matcher.locals[this.countIndex] = count;
                    } else {
                        return true;
                    }
                }
            }
            return this.next.match(matcher, i, seq);
        }

        boolean matchInit(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.locals[this.countIndex];
            boolean ret = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
                if (!ret) {
                    ret = this.next.match(matcher, i, seq);
                }
            } else {
                ret = this.next.match(matcher, i, seq);
            }
            matcher.locals[this.countIndex] = save;
            return ret;
        }

        boolean study(TreeInfo info) {
            info.maxValid = false;
            info.deterministic = false;
            return false;
        }
    }

    static final class Prolog
    extends Node {
        Loop loop;

        Prolog(Loop loop) {
            this.loop = loop;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.loop.matchInit(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            return this.loop.study(info);
        }
    }

    static final class GroupTail
    extends Node {
        int localIndex;
        int groupIndex;

        GroupTail(int localCount, int groupCount) {
            this.localIndex = localCount;
            this.groupIndex = groupCount + groupCount;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int tmp = matcher.locals[this.localIndex];
            if (tmp >= 0) {
                int groupStart = matcher.groups[this.groupIndex];
                int groupEnd = matcher.groups[this.groupIndex + 1];
                matcher.groups[this.groupIndex] = tmp;
                matcher.groups[this.groupIndex + 1] = i;
                if (this.next.match(matcher, i, seq)) {
                    return true;
                }
                matcher.groups[this.groupIndex] = groupStart;
                matcher.groups[this.groupIndex + 1] = groupEnd;
                return false;
            }
            matcher.last = i;
            return true;
        }
    }

    static final class GroupRef
    extends Node {
        GroupHead head;

        GroupRef(GroupHead head) {
            this.head = head;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.head.matchRef(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
        }

        boolean study(TreeInfo info) {
            info.maxValid = false;
            info.deterministic = false;
            return this.next.study(info);
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;

        GroupHead(int localCount) {
            this.localIndex = localCount;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = i;
            boolean ret = this.next.match(matcher, i, seq);
            matcher.locals[this.localIndex] = save;
            return ret;
        }

        boolean matchRef(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = ~i;
            boolean ret = this.next.match(matcher, i, seq);
            matcher.locals[this.localIndex] = save;
            return ret;
        }
    }

    static final class Branch
    extends Node {
        Node prev;

        Branch(Node lhs, Node rhs) {
            this.prev = lhs;
            this.next = rhs;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.prev.match(matcher, i, seq) || this.next.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            info.reset();
            this.prev.study(info);
            int minL2 = info.minLength;
            int maxL2 = info.maxLength;
            boolean maxV2 = info.maxValid;
            info.reset();
            this.next.study(info);
            info.minLength = minL + Math.min(minL2, info.minLength);
            info.maxLength = maxL + Math.max(maxL2, info.maxLength);
            info.maxValid = maxV & maxV2 & info.maxValid;
            info.deterministic = false;
            return false;
        }
    }

    static final class GroupCurly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;
        int localIndex;
        int groupIndex;

        GroupCurly(Node node, int cmin, int cmax, int type, int local, int group) {
            this.atom = node;
            this.type = type;
            this.cmin = cmin;
            this.cmax = cmax;
            this.localIndex = local;
            this.groupIndex = group;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] groups = matcher.groups;
            int[] locals = matcher.locals;
            int save0 = locals[this.localIndex];
            int save1 = groups[this.groupIndex];
            int save2 = groups[this.groupIndex + 1];
            locals[this.localIndex] = -1;
            boolean ret = true;
            for (int j = 0; j < this.cmin; ++j) {
                if (!this.atom.match(matcher, i, seq)) {
                    ret = false;
                    break;
                }
                groups[this.groupIndex] = i;
                groups[this.groupIndex + 1] = i = matcher.last;
            }
            if (ret) {
                ret = this.type == 0 ? this.match0(matcher, i, this.cmin, seq) : (this.type == 1 ? this.match1(matcher, i, this.cmin, seq) : this.match2(matcher, i, this.cmin, seq));
            }
            if (!ret) {
                locals[this.localIndex] = save0;
                groups[this.groupIndex] = save1;
                groups[this.groupIndex + 1] = save2;
            }
            return ret;
        }

        boolean match0(Matcher matcher, int i, int j, CharSequence seq) {
            int[] groups = matcher.groups;
            int save0 = groups[this.groupIndex];
            int save1 = groups[this.groupIndex + 1];
            if (j < this.cmax && this.atom.match(matcher, i, seq)) {
                int k = matcher.last - i;
                if (k <= 0) {
                    groups[this.groupIndex] = i;
                    groups[this.groupIndex + 1] = i += k;
                } else {
                    block7: {
                        do {
                            groups[this.groupIndex] = i;
                            groups[this.groupIndex + 1] = i += k;
                            if (++j >= this.cmax || !this.atom.match(matcher, i, seq)) break block7;
                        } while (i + k == matcher.last);
                        if (this.match0(matcher, i, j, seq)) {
                            return true;
                        }
                    }
                    while (j > this.cmin) {
                        if (this.next.match(matcher, i, seq)) {
                            groups[this.groupIndex + 1] = i;
                            groups[this.groupIndex] = i -= k;
                            return true;
                        }
                        groups[this.groupIndex + 1] = i;
                        groups[this.groupIndex] = i -= k;
                        --j;
                    }
                }
            }
            groups[this.groupIndex] = save0;
            groups[this.groupIndex + 1] = save1;
            return this.next.match(matcher, i, seq);
        }

        boolean match1(Matcher matcher, int i, int j, CharSequence seq) {
            while (!this.next.match(matcher, i, seq)) {
                if (j >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, i, seq)) {
                    return false;
                }
                if (i == matcher.last) {
                    return false;
                }
                matcher.groups[this.groupIndex] = i;
                matcher.groups[this.groupIndex + 1] = i = matcher.last;
                ++j;
            }
            return true;
        }

        boolean match2(Matcher matcher, int i, int j, CharSequence seq) {
            while (j < this.cmax && this.atom.match(matcher, i, seq)) {
                matcher.groups[this.groupIndex] = i;
                matcher.groups[this.groupIndex + 1] = matcher.last;
                if (i == matcher.last) break;
                i = matcher.last;
                ++j;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            boolean detm = info.deterministic;
            info.reset();
            this.atom.study(info);
            int temp = info.minLength * this.cmin + minL;
            if (temp < minL) {
                temp = 0xFFFFFFF;
            }
            info.minLength = temp;
            if (maxV & info.maxValid) {
                info.maxLength = temp = info.maxLength * this.cmax + maxL;
                if (temp < maxL) {
                    info.maxValid = false;
                }
            } else {
                info.maxValid = false;
            }
            info.deterministic = info.deterministic && this.cmin == this.cmax ? detm : false;
            return this.next.study(info);
        }
    }

    static final class Curly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;

        Curly(Node node, int cmin, int cmax, int type) {
            this.atom = node;
            this.type = type;
            this.cmin = cmin;
            this.cmax = cmax;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j;
            for (j = 0; j < this.cmin; ++j) {
                if (!this.atom.match(matcher, i, seq)) {
                    return false;
                }
                i = matcher.last;
            }
            if (this.type == 0) {
                return this.match0(matcher, i, j, seq);
            }
            if (this.type == 1) {
                return this.match1(matcher, i, j, seq);
            }
            return this.match2(matcher, i, j, seq);
        }

        boolean match0(Matcher matcher, int i, int j, CharSequence seq) {
            int k;
            if (j >= this.cmax) {
                return this.next.match(matcher, i, seq);
            }
            int backLimit = j++;
            if (this.atom.match(matcher, i, seq) && (k = matcher.last - i) != 0) {
                i = matcher.last;
                while (j < this.cmax && this.atom.match(matcher, i, seq)) {
                    if (i + k != matcher.last) {
                        if (!this.match0(matcher, matcher.last, j + 1, seq)) break;
                        return true;
                    }
                    i += k;
                    ++j;
                }
                while (j >= backLimit) {
                    if (this.next.match(matcher, i, seq)) {
                        return true;
                    }
                    i -= k;
                    --j;
                }
                return false;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean match1(Matcher matcher, int i, int j, CharSequence seq) {
            while (!this.next.match(matcher, i, seq)) {
                if (j >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, i, seq)) {
                    return false;
                }
                if (i == matcher.last) {
                    return false;
                }
                i = matcher.last;
                ++j;
            }
            return true;
        }

        boolean match2(Matcher matcher, int i, int j, CharSequence seq) {
            while (j < this.cmax && this.atom.match(matcher, i, seq) && i != matcher.last) {
                i = matcher.last;
                ++j;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            boolean detm = info.deterministic;
            info.reset();
            this.atom.study(info);
            int temp = info.minLength * this.cmin + minL;
            if (temp < minL) {
                temp = 0xFFFFFFF;
            }
            info.minLength = temp;
            if (maxV & info.maxValid) {
                info.maxLength = temp = info.maxLength * this.cmax + maxL;
                if (temp < maxL) {
                    info.maxValid = false;
                }
            } else {
                info.maxValid = false;
            }
            info.deterministic = info.deterministic && this.cmin == this.cmax ? detm : false;
            return this.next.study(info);
        }
    }

    static final class Ques
    extends Node {
        Node atom;
        int type;

        Ques(Node node, int type) {
            this.atom = node;
            this.type = type;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            switch (this.type) {
                case 0: {
                    return this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq) || this.next.match(matcher, i, seq);
                }
                case 1: {
                    return this.next.match(matcher, i, seq) || this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
                }
                case 2: {
                    if (this.atom.match(matcher, i, seq)) {
                        i = matcher.last;
                    }
                    return this.next.match(matcher, i, seq);
                }
            }
            return this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
        }

        boolean study(TreeInfo info) {
            if (this.type != 3) {
                int minL = info.minLength;
                this.atom.study(info);
                info.minLength = minL;
                info.deterministic = false;
                return this.next.study(info);
            }
            this.atom.study(info);
            return this.next.study(info);
        }
    }

    static final class UnixDot
    extends Node {
        UnixDot() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                char ch = seq.charAt(i);
                return ch != '\n' && this.next.match(matcher, i + 1, seq);
            }
            return false;
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class Dot
    extends Node {
        Dot() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                char ch = seq.charAt(i);
                return ch != '\n' && ch != '\r' && (ch | '\u0001') != 8233 && ch != '\u0085' && this.next.match(matcher, i + 1, seq);
            }
            return false;
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class All
    extends Node {
        All() {
        }

        Node dup(boolean not) {
            if (not) {
                return new Single(-1);
            }
            return new All();
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return i < matcher.to && this.next.match(matcher, i + 1, seq);
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static class CINotRange
    extends NotRange {
        int lower;
        int upper;

        CINotRange(int n) {
            this.lower = n >>> 16;
            this.upper = n & 0xFFFF;
        }

        Node dup(boolean not) {
            if (not) {
                return new CIRange((this.lower << 16) + this.upper);
            }
            return new CINotRange((this.lower << 16) + this.upper);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                boolean m;
                char ch = seq.charAt(i);
                boolean bl = m = (ch - this.lower | this.upper - ch) < 0;
                if (m) {
                    boolean bl2 = m = ((ch = Character.toUpperCase(ch)) - this.lower | this.upper - ch) < 0;
                    if (m) {
                        m = ((ch = Character.toLowerCase(ch)) - this.lower | this.upper - ch) < 0;
                    }
                }
                return m && this.next.match(matcher, i + 1, seq);
            }
            return false;
        }
    }

    static class NotRange
    extends Node {
        int lower;
        int upper;

        NotRange() {
        }

        NotRange(int n) {
            this.lower = n >>> 16;
            this.upper = n & 0xFFFF;
        }

        Node dup(boolean not) {
            if (not) {
                return new Range((this.lower << 16) + this.upper);
            }
            return new NotRange((this.lower << 16) + this.upper);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                char ch = seq.charAt(i);
                return (ch - this.lower | this.upper - ch) < 0 && this.next.match(matcher, i + 1, seq);
            }
            return false;
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class CIRange
    extends Range {
        CIRange(int n) {
            this.lower = n >>> 16;
            this.upper = n & 0xFFFF;
        }

        Node dup(boolean not) {
            if (not) {
                return new CINotRange((this.lower << 16) + this.upper);
            }
            return new CIRange((this.lower << 16) + this.upper);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                boolean m;
                char ch = seq.charAt(i);
                boolean bl = m = (ch - this.lower | this.upper - ch) >= 0;
                if (!m) {
                    boolean bl2 = m = ((ch = Character.toUpperCase(ch)) - this.lower | this.upper - ch) >= 0;
                    if (!m) {
                        m = ((ch = Character.toLowerCase(ch)) - this.lower | this.upper - ch) >= 0;
                    }
                }
                return m && this.next.match(matcher, i + 1, seq);
            }
            return false;
        }
    }

    static class Range
    extends Node {
        int lower;
        int upper;

        Range() {
        }

        Range(int n) {
            this.lower = n >>> 16;
            this.upper = n & 0xFFFF;
        }

        Node dup(boolean not) {
            if (not) {
                return new NotRange((this.lower << 16) + this.upper);
            }
            return new Range((this.lower << 16) + this.upper);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                char ch = seq.charAt(i);
                return (ch - this.lower | this.upper - ch) >= 0 && this.next.match(matcher, i + 1, seq);
            }
            return false;
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class SliceU
    extends Node {
        char[] buffer;

        SliceU(char[] buf) {
            this.buffer = buf;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            char[] buf = this.buffer;
            int len = buf.length;
            if (i + len > matcher.to) {
                return false;
            }
            for (int j = 0; j < len; ++j) {
                char c = seq.charAt(i + j);
                c = Character.toUpperCase(c);
                if (buf[j] == (c = Character.toLowerCase(c))) continue;
                return false;
            }
            return this.next.match(matcher, i + len, seq);
        }

        boolean study(TreeInfo info) {
            info.minLength += this.buffer.length;
            info.maxLength += this.buffer.length;
            return this.next.study(info);
        }
    }

    static final class SliceA
    extends Node {
        char[] buffer;

        SliceA(char[] buf) {
            this.buffer = buf;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            char[] buf = this.buffer;
            int len = buf.length;
            if (i + len > matcher.to) {
                return false;
            }
            for (int j = 0; j < len; ++j) {
                int c = ASCII.toLower(seq.charAt(i + j));
                if (buf[j] == c) continue;
                return false;
            }
            return this.next.match(matcher, i + len, seq);
        }

        boolean study(TreeInfo info) {
            info.minLength += this.buffer.length;
            info.maxLength += this.buffer.length;
            return this.next.study(info);
        }
    }

    static final class Slice
    extends Node {
        char[] buffer;

        Slice(char[] buf) {
            this.buffer = buf;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            char[] buf = this.buffer;
            int len = buf.length;
            if (i + len > matcher.to) {
                return false;
            }
            for (int j = 0; j < len; ++j) {
                if (buf[j] == seq.charAt(i + j)) continue;
                return false;
            }
            return this.next.match(matcher, i + len, seq);
        }

        boolean study(TreeInfo info) {
            info.minLength += this.buffer.length;
            info.maxLength += this.buffer.length;
            return this.next.study(info);
        }
    }

    static final class Not
    extends Node {
        Node atom;

        Not(Node atom) {
            this.atom = atom;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return !this.atom.match(matcher, i, seq) && this.next.match(matcher, i + 1, seq);
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class Specials
    extends Node {
        Specials() {
        }

        Node dup(boolean not) {
            if (not) {
                return new Not(this);
            }
            return new Specials();
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                char ch = seq.charAt(i);
                return ((ch - 65520 | 65533 - ch) >= 0 || ch == '\ufeff') && this.next.match(matcher, i + 1, seq);
            }
            return false;
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class NotCtype
    extends Node {
        int ctype;

        NotCtype(int type) {
            this.ctype = type;
        }

        Node dup(boolean not) {
            if (not) {
                return new Ctype(this.ctype);
            }
            return new NotCtype(this.ctype);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return i < matcher.to && !ASCII.isType(seq.charAt(i), this.ctype) && this.next.match(matcher, i + 1, seq);
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class Ctype
    extends Node {
        int ctype;

        Ctype(int type) {
            this.ctype = type;
        }

        Node dup(boolean not) {
            if (not) {
                return new NotCtype(this.ctype);
            }
            return new Ctype(this.ctype);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return i < matcher.to && ASCII.isType(seq.charAt(i), this.ctype) && this.next.match(matcher, i + 1, seq);
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class Category
    extends Node {
        int atype;

        Category(int type) {
            this.atype = type;
        }

        Node dup(boolean not) {
            return new Category(not ? ~this.atype : this.atype);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return i < matcher.to && (this.atype & 1 << Character.getType(seq.charAt(i))) != 0 && this.next.match(matcher, i + 1, seq);
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class NotSingleU
    extends Node {
        int ch;

        NotSingleU(int c) {
            this.ch = Character.toLowerCase(Character.toUpperCase((char)c));
        }

        Node dup(boolean not) {
            if (not) {
                return new SingleU(this.ch);
            }
            return new NotSingleU(this.ch);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                char c = seq.charAt(i);
                if (c == this.ch) {
                    return false;
                }
                c = Character.toUpperCase(c);
                if ((c = Character.toLowerCase(c)) != this.ch) {
                    return this.next.match(matcher, i + 1, seq);
                }
            }
            return false;
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class SingleU
    extends Node {
        int ch;

        SingleU(int c) {
            this.ch = Character.toLowerCase(Character.toUpperCase((char)c));
        }

        Node dup(boolean not) {
            if (not) {
                return new NotSingleU(this.ch);
            }
            return new SingleU(this.ch);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                char c = seq.charAt(i);
                if (c == this.ch) {
                    return this.next.match(matcher, i + 1, seq);
                }
                c = Character.toUpperCase(c);
                if ((c = Character.toLowerCase(c)) == this.ch) {
                    return this.next.match(matcher, i + 1, seq);
                }
            }
            return false;
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class NotSingleA
    extends Node {
        int ch;

        NotSingleA(int n) {
            this.ch = ASCII.toLower(n);
        }

        Node dup(boolean not) {
            if (not) {
                return new SingleA(this.ch);
            }
            return new NotSingleA(this.ch);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            char c;
            if (i < matcher.to && (c = seq.charAt(i)) != this.ch && ASCII.toLower(c) != this.ch) {
                return this.next.match(matcher, i + 1, seq);
            }
            return false;
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class SingleA
    extends Node {
        int ch;

        SingleA(int n) {
            this.ch = ASCII.toLower(n);
        }

        Node dup(boolean not) {
            if (not) {
                return new NotSingleA(this.ch);
            }
            return new SingleA(this.ch);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            char c;
            if (i < matcher.to && ((c = seq.charAt(i)) == this.ch || ASCII.toLower(c) == this.ch)) {
                return this.next.match(matcher, i + 1, seq);
            }
            return false;
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class NotSingle
    extends Node {
        int ch;

        NotSingle(int n) {
            this.ch = n;
        }

        Node dup(boolean not) {
            if (not) {
                return new Single(this.ch);
            }
            return new NotSingle(this.ch);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return i < matcher.to && seq.charAt(i) != this.ch && this.next.match(matcher, i + 1, seq);
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class Single
    extends Node {
        int ch;

        Single(int n) {
            this.ch = n;
        }

        Node dup(boolean not) {
            if (not) {
                return new NotSingle(this.ch);
            }
            return new Single(this.ch);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return i < matcher.to && seq.charAt(i) == this.ch && this.next.match(matcher, i + 1, seq);
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean mul) {
            this.multiline = mul;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                char ch = seq.charAt(i);
                if (ch == '\n') {
                    if (!this.multiline && i != matcher.to - 1) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return this.next.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            this.next.study(info);
            return info.deterministic;
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean mul) {
            this.multiline = mul;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            char ch;
            if (!this.multiline) {
                if (i < matcher.to - 2) {
                    return false;
                }
                if (i == matcher.to - 2) {
                    ch = seq.charAt(i);
                    if (ch != '\r') {
                        return false;
                    }
                    ch = seq.charAt(i + 1);
                    if (ch != '\n') {
                        return false;
                    }
                }
            }
            if (i < matcher.to) {
                ch = seq.charAt(i);
                if (ch == '\n') {
                    if (i > 0 && seq.charAt(i - 1) == '\r') {
                        return false;
                    }
                } else if (ch != '\r' && ch != '\u0085' && (ch | '\u0001') != 8233) {
                    return false;
                }
            }
            return this.next.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            this.next.study(info);
            return info.deterministic;
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i != matcher.oldLast) {
                return false;
            }
            return this.next.match(matcher, i, seq);
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            char ch;
            if (i > matcher.from && (ch = seq.charAt(i - 1)) != '\n') {
                return false;
            }
            if (i == matcher.to) {
                return false;
            }
            return this.next.match(matcher, i, seq);
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.from) {
                char ch = seq.charAt(i - 1);
                if (ch != '\n' && ch != '\r' && (ch | '\u0001') != 8233 && ch != '\u0085') {
                    return false;
                }
                if (ch == '\r' && seq.charAt(i) == '\n') {
                    return false;
                }
            }
            if (i == matcher.to) {
                return false;
            }
            return this.next.match(matcher, i, seq);
        }
    }

    static final class End
    extends Node {
        End() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return i == matcher.to && this.next.match(matcher, i, seq);
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i == matcher.from && this.next.match(matcher, i, seq)) {
                matcher.first = i;
                matcher.groups[0] = i;
                matcher.groups[1] = matcher.last;
                return true;
            }
            return false;
        }
    }

    static final class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.next = node;
            TreeInfo info = new TreeInfo();
            this.next.study(info);
            this.minLength = info.minLength;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.to - this.minLength) {
                return false;
            }
            boolean ret = false;
            int guard = matcher.to - this.minLength;
            while (i <= guard && !(ret = this.next.match(matcher, i, seq))) {
                ++i;
            }
            if (ret) {
                matcher.groups[0] = matcher.first = i;
                matcher.groups[1] = matcher.last;
            }
            return ret;
        }

        boolean study(TreeInfo info) {
            this.next.study(info);
            info.maxValid = false;
            info.deterministic = false;
            return false;
        }
    }

    static class Dummy
    extends Node {
        Dummy() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.next.match(matcher, i, seq);
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (matcher.acceptMode == 1 && i != matcher.to) {
                return false;
            }
            matcher.last = i;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }
    }

    static class Node {
        Node next = accept;

        Node() {
        }

        Node dup(boolean not) {
            if (not) {
                return new Not(this);
            }
            throw new RuntimeException("internal error in Node dup()");
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            matcher.last = i;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }

        boolean study(TreeInfo info) {
            if (this.next != null) {
                return this.next.study(info);
            }
            return info.deterministic;
        }
    }

    static final class BitClass
    extends Node {
        boolean[] bits = new boolean[256];
        boolean complementMe = false;

        BitClass(boolean not) {
            this.complementMe = not;
        }

        BitClass(boolean[] newBits, boolean not) {
            this.complementMe = not;
            this.bits = newBits;
        }

        Node add(int c, int f) {
            if ((f & 2) == 0) {
                this.bits[c] = true;
                return this;
            }
            if (c < 128) {
                this.bits[c] = true;
                if (ASCII.isUpper(c)) {
                    this.bits[c += 32] = true;
                } else if (ASCII.isLower(c)) {
                    this.bits[c -= 32] = true;
                }
                return this;
            }
            c = Character.toLowerCase((char)c);
            this.bits[c] = true;
            c = Character.toUpperCase((char)c);
            this.bits[c] = true;
            return this;
        }

        Node dup(boolean not) {
            return new BitClass(this.bits, not);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i >= matcher.to) {
                return false;
            }
            char c = seq.charAt(i);
            boolean charMatches = c > '\u00ff' ? this.complementMe : this.bits[c] ^ this.complementMe;
            return charMatches && this.next.match(matcher, i + 1, seq);
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class TreeInfo {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }
    }
}

