/*
 * Decompiled with CFR 0.152.
 */
package jreepad;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Date;
import javax.swing.undo.UndoManager;
import jreepad.JreepadView;
import jreepad.JreepadViewer;
import org.philwilson.JTextile;

public class JreepadArticle {
    public static final String UNTITLED_NODE_TEXT = "<Untitled node>";
    public static final int ARTICLEMODE_ORDINARY = 1;
    public static final int ARTICLEMODE_HTML = 2;
    public static final int ARTICLEMODE_CSV = 3;
    public static final int ARTICLEMODE_TEXTILEHTML = 4;
    public static final int CSVPARSE_MODE_INQUOTES = 1;
    public static final int CSVPARSE_MODE_EXPECTINGDELIMITER = 2;
    public static final int CSVPARSE_MODE_EXPECTINGDATA = 3;
    public static final int EXPORT_HTML_NORMAL = 0;
    public static final int EXPORT_HTML_PREFORMATTED = 1;
    public static final int EXPORT_HTML_HTML = 2;
    public static final int EXPORT_HTML_TEXTILEHTML = 3;
    public static final int EXPORT_HTML_ANCHORS_PATH = 0;
    public static final int EXPORT_HTML_ANCHORS_WIKI = 1;
    private String title;
    private String content;
    private int articleMode;
    private UndoManager undoMgr;

    public JreepadArticle() {
        this(JreepadArticle.getNewContent());
    }

    public JreepadArticle(String content) {
        this(UNTITLED_NODE_TEXT, content);
    }

    public JreepadArticle(String title, String content) {
        this(title, content, 1);
    }

    public JreepadArticle(String title, String content, int articleMode) {
        this.title = title == null || title.equals("") ? UNTITLED_NODE_TEXT : title;
        this.content = content;
        this.articleMode = articleMode;
        this.undoMgr = new UndoManager();
    }

    public int getArticleMode() {
        return this.articleMode;
    }

    public void setArticleMode(int articleMode) {
        this.articleMode = articleMode;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title == null || title.equals("") ? UNTITLED_NODE_TEXT : title;
    }

    public UndoManager getUndoMgr() {
        return this.undoMgr;
    }

    public String toString() {
        return this.title;
    }

    public static final String[] getHtmlExportArticleTypes() {
        return new String[]{JreepadViewer.lang.getString("PREFS_EXPORTTYPE_TEXT"), JreepadViewer.lang.getString("PREFS_EXPORTTYPE_PREFORMATTED"), JreepadViewer.lang.getString("PREFS_EXPORTTYPE_HTML"), JreepadViewer.lang.getString("PREFS_EXPORTTYPE_TEXTILEHTML")};
    }

    public static final String[] getHtmlExportAnchorLinkTypes() {
        return new String[]{"node:// links", "WikiLike links"};
    }

    public String exportAsHtml(int exportMode, boolean urlsToLinks, int anchorType, boolean causeToPrint) {
        StringBuffer ret = new StringBuffer();
        ret.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">\n<head>\n<title>");
        ret.append(JreepadArticle.htmlSpecialChars(this.getTitle()));
        ret.append("</title>\n<style type=\"text/css\">\ndl {}\ndl dt { font-weight: bold; margin-top: 10px; font-size: 24pt; }\ndl dd {margin-left: 20px; padding-left: 0px;}\ndl dd dl dt {background: black; color: white; font-size: 12pt; }\ndl dd dl dd dl dt {background: white; color: black; }\n</style>\n</head>\n\n<body" + (causeToPrint ? " onload='print();'" : "") + ">\n<!-- Exported from Jreepad -->\n<dl>");
        ret.append(this.toHtml(exportMode, urlsToLinks, anchorType));
        ret.append("\n</dl>\n</body>\n</html>");
        return ret.toString();
    }

    public String toHtml(int exportMode, boolean urlsToLinks, int anchorType) {
        switch (this.articleMode) {
            case 2: {
                return this.getContent();
            }
            case 4: {
                try {
                    return JTextile.textile(this.getContent());
                }
                catch (Exception e) {
                    return this.getContent();
                }
            }
            case 3: {
                String[][] csv = this.interpretContentAsCsv();
                StringBuffer csvHtml = new StringBuffer("\n  <table border='1' cellspacing='0' cellpadding='2'>");
                for (int i = 0; i < csv.length; ++i) {
                    csvHtml.append("\n    <tr>");
                    for (int j = 0; j < csv[0].length; ++j) {
                        csvHtml.append("\n      <td>" + JreepadArticle.htmlSpecialChars(csv[i][j]) + "</td>");
                    }
                    csvHtml.append("\n    </tr>");
                }
                csvHtml.append("\n  </table>");
                return csvHtml.toString();
            }
        }
        switch (exportMode) {
            case 1: {
                return "<pre>" + (urlsToLinks ? this.urlsToHtmlLinksAndHtmlSpecialChars(this.getContent(), anchorType) : JreepadArticle.htmlSpecialChars(this.getContent())) + "</pre>";
            }
            case 2: {
                return this.getContent();
            }
            case 3: {
                try {
                    return JTextile.textile(this.getContent());
                }
                catch (Exception e) {
                    return this.getContent();
                }
            }
        }
        return urlsToLinks ? this.urlsToHtmlLinksAndHtmlSpecialChars(this.getContent(), anchorType) : JreepadArticle.htmlSpecialChars(this.getContent());
    }

    private static String htmlSpecialChars(String in) {
        char[] c = in.toCharArray();
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '<') {
                ret.append("&lt;");
                continue;
            }
            if (c[i] == '>') {
                ret.append("&gt;");
                continue;
            }
            if (c[i] == '&') {
                ret.append("&amp;");
                continue;
            }
            if (c[i] == '\n') {
                ret.append(" <br />\n");
                continue;
            }
            if (c[i] == '\"') {
                ret.append("&quot;");
                continue;
            }
            ret.append(c[i]);
        }
        return ret.toString();
    }

    private String urlsToHtmlLinksAndHtmlSpecialChars(String in, int anchorType) {
        StringCharacterIterator iter = new StringCharacterIterator(in);
        StringBuffer out = new StringBuffer("");
        StringBuffer currentWord = new StringBuffer("");
        char c = iter.current();
        while (true) {
            if (Character.isWhitespace(c) || c == '\"' || c == '\'' || c == '<' || c == '>' || c == '\n' || c == '\uffff') {
                String currentWordString;
                if (currentWord.toString().indexOf("://") > 0) {
                    char c2 = currentWord.charAt(0);
                    if (c2 == '\"' || c2 == '\'') {
                        currentWord.deleteCharAt(0);
                    }
                    if ((c2 = currentWord.charAt(currentWord.length() - 1)) == '\"' || c2 == '\'') {
                        currentWord.deleteCharAt(currentWord.length() - 1);
                    }
                    if ((currentWordString = currentWord.toString()).startsWith("node://")) {
                        String anchorLink = anchorType == 1 ? currentWordString.substring(currentWordString.lastIndexOf(47) + 1) : currentWordString.substring(7);
                        out.append("<a href=\"#" + anchorLink + "\">" + currentWordString + "</a>");
                    } else {
                        out.append("<a href=\"" + currentWord + "\">" + currentWordString + "</a>");
                    }
                } else if (anchorType == 1 && JreepadView.isWikiWord(currentWord.toString())) {
                    currentWordString = currentWord.toString();
                    if (currentWordString.length() > 4 && currentWordString.startsWith("[[") && currentWordString.endsWith("]]")) {
                        currentWordString = currentWordString.substring(2, currentWordString.length() - 2);
                    }
                    out.append("<a href=\"#" + currentWordString + "\">" + currentWordString + "</a>");
                } else {
                    out.append(currentWord.toString());
                }
                if (c == '<') {
                    out.append("&lt;");
                } else if (c == '>') {
                    out.append("&gt;");
                } else if (c == '\n') {
                    out.append(" <br />\n");
                } else if (c == '\"') {
                    out.append("&quot;");
                } else if (c == '&') {
                    out.append("&amp;");
                } else if (c != '\uffff') {
                    out.append(c);
                }
                currentWord.setLength(0);
                if (c == '\uffff') {
                    break;
                }
            } else {
                currentWord.append(c);
            }
            c = iter.next();
        }
        return out.toString();
    }

    public synchronized void wrapContentToCharWidth(int charWidth) {
        if (charWidth < 2) {
            return;
        }
        StringBuffer ret = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(this.content);
        int charsOnThisLine = 0;
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '\n') {
                charsOnThisLine = 0;
            } else if (++charsOnThisLine >= charWidth) {
                ret.append('\n');
                charsOnThisLine = 0;
            }
            ret.append(c);
            c = iter.next();
        }
        this.content = ret.toString();
    }

    public synchronized void stripAllTags() {
        StringBuffer ret = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(this.content);
        boolean on = true;
        char c = iter.first();
        while (c != '\uffff') {
            if (!on && c == '>') {
                on = true;
            } else if (on && c == '<') {
                on = false;
            } else if (on) {
                ret.append(c);
            }
            c = iter.next();
        }
        this.content = ret.toString();
    }

    public String[][] interpretContentAsCsv() {
        String theContent = this.getContent();
        int rows = 1;
        int cols = 1;
        theContent = theContent.trim();
        int curCols = 1;
        int parseMode = 3;
        StringBuffer curData = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(theContent);
        char c = iter.current();
        while (true) {
            if (c == '\uffff') break;
            if (parseMode == 1) {
                if (c == '\"') {
                    parseMode = 2;
                } else {
                    curData.append(c);
                }
            } else if (parseMode == 2 || parseMode == 3) {
                if (c == '\"') {
                    parseMode = 1;
                } else if (c == '\n' || c == '\r') {
                    parseMode = 3;
                    curData = new StringBuffer();
                    cols = curCols > cols ? curCols : cols;
                    curCols = 1;
                    ++rows;
                } else if (c == ',') {
                    parseMode = 3;
                    ++curCols;
                    curData = new StringBuffer();
                } else {
                    curData.append(c);
                }
            }
            c = iter.next();
        }
        cols = curCols > cols ? curCols : cols;
        String[][] csv = new String[rows][cols];
        for (int i = 0; i < csv.length; ++i) {
            Arrays.fill(csv[i], "");
        }
        iter = new StringCharacterIterator(theContent);
        parseMode = 3;
        curData = new StringBuffer();
        int col = 0;
        int row = 0;
        c = iter.current();
        while (true) {
            if (c == '\uffff') break;
            if (parseMode == 1) {
                if (c == '\"') {
                    parseMode = 2;
                } else {
                    curData.append(c);
                }
            } else if (parseMode == 2 || parseMode == 3) {
                if (c == '\"') {
                    parseMode = 1;
                } else if (c == '\n' || c == '\r') {
                    csv[row][col] = curData.toString();
                    parseMode = 3;
                    curData = new StringBuffer();
                    col = 0;
                    ++row;
                } else if (c == ',') {
                    csv[row][col] = curData.toString();
                    parseMode = 3;
                    ++col;
                    curData = new StringBuffer();
                } else {
                    curData.append(c);
                }
            }
            c = iter.next();
        }
        csv[row][col] = curData.toString();
        return csv;
    }

    protected void setContentAsCsv(String[][] in) {
        StringBuffer o = new StringBuffer();
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < in[0].length; ++j) {
                o.append("\"" + in[i][j] + "\"");
            }
            o.append("\n");
        }
        this.setContent(o.toString());
    }

    public static String getNewContent() {
        if (JreepadView.getPrefs().autoDateInArticles) {
            return JreepadArticle.getCurrentDate();
        }
        return "";
    }

    public static String getCurrentDate() {
        DateFormat dateFormat = null;
        String format = JreepadView.getPrefs().dateFormat;
        if (!format.equals("")) {
            try {
                dateFormat = new SimpleDateFormat(format);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateInstance();
        }
        return dateFormat.format(new Date());
    }
}

