/*
 * Decompiled with CFR 0.152.
 */
package jreepad.io;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jreepad.JreepadNode;
import jreepad.JreepadTreeModel;
import jreepad.io.JreepadReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReader
implements JreepadReader {
    public static final String NODE_TAG = "node";
    public static final String TITLE_ATTRIBUTE = "title";
    public static final String TYPE_ATTRIBUTE = "type";

    public JreepadTreeModel read(InputStream in) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Handler handler = null;
        try {
            SAXParser parser = factory.newSAXParser();
            handler = new Handler();
            parser.parse(in, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
        JreepadTreeModel document = new JreepadTreeModel(handler.getRoot());
        document.setFileType(0);
        return document;
    }

    private class Handler
    extends DefaultHandler {
        JreepadNode root = null;
        JreepadNode currentNode = null;
        StringBuffer content = null;
        int articleMode;

        private Handler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.content != null) {
                this.content.append(ch, start, length);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!qName.equals(XmlReader.NODE_TAG)) {
                throw new SAXException("Unknown tag " + qName);
            }
            if (this.currentNode != null && this.content != null) {
                this.currentNode.getArticle().setContent(this.content.toString());
            }
            this.content = new StringBuffer();
            String title = attributes.getValue(XmlReader.TITLE_ATTRIBUTE);
            String type = attributes.getValue(XmlReader.TYPE_ATTRIBUTE);
            JreepadNode newNode = new JreepadNode(title, "");
            if (this.currentNode != null) {
                this.currentNode.add(newNode);
            }
            this.currentNode = newNode;
            if (this.root == null) {
                this.root = this.currentNode;
            }
            int articleMode = 1;
            if (type.equals("text/csv")) {
                articleMode = 3;
            } else if (type.equals("text/html")) {
                articleMode = 2;
            } else if (type.equals("text/textile")) {
                articleMode = 4;
            }
            this.currentNode.getArticle().setArticleMode(articleMode);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.content != null) {
                this.currentNode.getArticle().setContent(this.content.toString());
            }
            this.currentNode = this.currentNode.getParentNode();
            this.content = null;
        }

        public JreepadNode getRoot() {
            return this.root;
        }
    }
}

