/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.makagiga.commons.FS;
import org.makagiga.commons.TK;

public abstract class AbstractMarkupBuilder
implements Appendable,
CharSequence {
    protected boolean xml;
    @Deprecated
    protected int indent;
    @Deprecated
    protected String eol = "\n";
    @Deprecated
    protected String indentString = "\t";
    protected String tagEnd;
    protected StringBuilder buf = new StringBuilder(4096);

    public AbstractMarkupBuilder(boolean bl) {
        this.xml = bl;
        this.tagEnd = bl ? " />" : ">";
    }

    public void addComment(String string) {
        if (string != null) {
            this.doIndent();
            this.buf.append("<!-- ").append(string).append(" -->").append(this.eol);
        }
    }

    public void appendLine() {
        this.buf.append(this.eol);
    }

    public void appendLine(String string) {
        if (string != null) {
            this.doIndent();
            this.buf.append(string).append(this.eol);
        }
    }

    public void appendLine(String string, Object ... objectArray) {
        this.appendLine(String.format(string, objectArray));
    }

    public void beginTag(String string) {
        if (string != null) {
            this.doIndent();
            this.buf.append('<').append(string).append('>').append(this.eol);
        }
        ++this.indent;
    }

    public void beginTag(String string, Object ... objectArray) {
        this.doIndent();
        this.buf.append('<').append(string);
        this.addAttributes(objectArray);
        this.buf.append('>').append(this.eol);
        ++this.indent;
    }

    public void decIndent() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    public void doubleTag(String string, String string2, Object ... objectArray) {
        this.doIndent();
        this.buf.append('<').append(string);
        this.addAttributes(objectArray);
        this.buf.append('>');
        if (!TK.isEmpty(string2)) {
            this.buf.append(string2);
        }
        this.buf.append("</").append(string).append('>').append(this.eol);
    }

    public void endTag(String string) {
        this.decIndent();
        if (string != null) {
            this.doIndent();
            this.buf.append("</").append(string).append('>').append(this.eol);
        }
    }

    public AbstractMarkupBuilder emit(Object object) {
        this.buf.append(object);
        return this;
    }

    public static String escape(String string) {
        return TK.escapeXML(string);
    }

    public String getEOL() {
        return this.eol;
    }

    public void setEOL(String string) {
        TK.checkNull(string, "value");
        this.eol = string;
    }

    public int getIndentLevel() {
        return this.indent;
    }

    public void setIndentLevel(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("\"indentLevel\" cannot be less than zero");
        }
        this.indent = n;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String string) {
        TK.checkNull(string, "value");
        this.indentString = string;
    }

    public void incIndent() {
        ++this.indent;
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save(outputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(OutputStream outputStream, boolean bl) throws IOException {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(outputStream, false, "UTF8");
            printStream.print(this.buf.toString());
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            FS.close(printStream);
            FS.close(outputStream);
            throw throwable;
        }
        FS.close(printStream);
        FS.close(outputStream);
    }

    public void save(String string) throws IOException {
        FS.write(string, this.toString());
    }

    public void singleTag(String string, Object ... objectArray) {
        this.doIndent();
        this.buf.append('<').append(string);
        this.addAttributes(objectArray);
        this.buf.append(this.tagEnd).append(this.eol);
    }

    @Override
    public AbstractMarkupBuilder append(CharSequence charSequence) {
        this.buf.append(charSequence);
        return this;
    }

    @Override
    public AbstractMarkupBuilder append(CharSequence charSequence, int n, int n2) {
        this.buf.append(charSequence, n, n2);
        return this;
    }

    @Override
    public AbstractMarkupBuilder append(char c) {
        this.buf.append(c);
        return this;
    }

    @Override
    public char charAt(int n) {
        return this.buf.charAt(n);
    }

    @Override
    public int length() {
        return this.buf.length();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.buf.subSequence(n, n2);
    }

    @Override
    public String toString() {
        return this.buf.toString();
    }

    protected void addAttributes(Object ... objectArray) {
        if (objectArray != null) {
            boolean bl = true;
            for (Object object : objectArray) {
                if (bl) {
                    this.buf.append(' ').append(object).append("=\"");
                    bl = false;
                    continue;
                }
                this.buf.append(AbstractMarkupBuilder.escape(String.valueOf(object))).append('\"');
                bl = true;
            }
        }
    }

    protected void doIndent() {
        if (this.indent == 0) {
            return;
        }
        if (this.indentString.length() == 1) {
            char[] cArray = new char[this.indent];
            Arrays.fill(cArray, this.indentString.charAt(0));
            this.buf.append(cArray);
        } else {
            for (int i = 0; i < this.indent; ++i) {
                this.buf.append(this.indentString);
            }
        }
    }
}

