/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.text.ParseException;
import org.makagiga.commons.Property;
import org.makagiga.commons.TK;

public class ColorProperty
extends Property<Color> {
    public ColorProperty() {
        super(Color.BLACK);
    }

    public ColorProperty(Color color) {
        super(color);
    }

    public ColorProperty(int n) {
        super(new Color(n));
    }

    public ColorProperty(String string) throws ParseException {
        super(ColorProperty.parseColor(string));
    }

    @Override
    public Class<Color> getType() {
        return Color.class;
    }

    @Override
    public void parse(String string) throws ParseException {
        this.set(ColorProperty.parseColor(string));
    }

    public static Color parseColor(String string) throws ParseException {
        if (TK.isEmpty(string)) {
            throw new ParseException("Null or empty color value", 0);
        }
        if (string.charAt(0) == '#') {
            string = string.substring(1);
        }
        try {
            switch (string.length()) {
                case 3: {
                    String string2 = Character.toString(string.charAt(0));
                    String string3 = Character.toString(string.charAt(1));
                    String string4 = Character.toString(string.charAt(2));
                    return new Color(Integer.parseInt(string2 + string2 + string3 + string3 + string4 + string4, 16));
                }
                case 6: {
                    return new Color(Integer.parseInt(string, 16));
                }
            }
            throw new ParseException("Invalid color value: \"" + string + "\"", 0);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid color value: \"" + string + "\"", 0);
        }
    }

    @Override
    public String toString() {
        return ColorProperty.toString((Color)this.get());
    }

    public static String toString(Color color) {
        if (color == null) {
            return "#000000";
        }
        return '#' + TK.toByteHex(color.getRed()) + TK.toByteHex(color.getGreen()) + TK.toByteHex(color.getBlue());
    }
}

