/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.ConfigEntry;
import org.makagiga.commons.DateProperty;
import org.makagiga.commons.DoubleProperty;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.FS;
import org.makagiga.commons.Flags;
import org.makagiga.commons.FloatProperty;
import org.makagiga.commons.FontProperty;
import org.makagiga.commons.Immutable;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.OS;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.PlatformConfig;
import org.makagiga.commons.Property;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.RegExp;
import org.makagiga.commons.SecureProperty;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.script.ScriptExecutor;
import org.makagiga.commons.security.MPermission;

public class Config
implements Immutable<Config>,
Serializable {
    public static final int READ_ONLY = 1;
    public static final int RESOURCE = 2;
    @Deprecated
    public static final int USE_GLOBAL_DEFAULTS = 4;
    @Deprecated
    public static final int NO_LOAD = 8;
    @Deprecated
    public static final int SECURE = 16;
    protected MProperties properties;
    private List<Class<?>> registeredClasses;
    private static List<Class<?>> defaultClasses;
    private boolean loadError;
    private boolean modified;
    private boolean readOnly;
    private static Config global;
    private Flags flags;
    private static MLogger log;
    private static String defaultComment;
    private static String langKey;
    private String path;

    public Config() {
        this((String)null, 0);
    }

    public Config(MProperties mProperties, int n) {
        this.flags = new Flags(n);
        this.readOnly = this.flags.isSet(1L);
        this.path = "";
        this.properties = mProperties;
    }

    public Config(String string, int n) {
        this.flags = new Flags(n);
        this.readOnly = this.flags.isSet(1L);
        this.path = string;
        if (this.flags.isClear(8L)) {
            this.loadError = !this.load();
        }
    }

    public Config(String string) {
        this(string, 0);
    }

    @Deprecated
    public Config(File file) {
        this(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config getDefault() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(null, "DEFAULT", "get-default"));
        }
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (global != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return global;
            }
            if (FS.isRestricted()) {
                global = new Config();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return global;
            }
            int n = 28;
            global = new Config(FS.makeConfigPath(MApplication.getInternalName() + ".properties"), n);
            global.registerClass(Kiosk.class);
            global.registerClass(MApplication.class);
            global.registerClass(MLogger.class);
            global.registerClass(OS.class);
            global.registerClass(ScriptExecutor.class);
            global.registerClass(UI.class);
            if (defaultClasses != null) {
                for (Class<?> clazz2 : defaultClasses) {
                    global.registerClass(clazz2);
                }
            }
            global.load();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return global;
        }
    }

    public static synchronized String getDefaultComment() {
        return defaultComment;
    }

    public static synchronized void setDefaultComment(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(null, string, "write"));
        }
        defaultComment = string;
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized void setPath(String string) {
        this.checkPermission(null, "write");
        this.path = string;
    }

    public static String getPlatformKey(String string) {
        return string + "@" + OS.getInternalName();
    }

    public synchronized MProperties getProperties() {
        this.checkPermission(null, "write");
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PropertyAccess<?>> getRegisteredProperties() {
        Map<String, PropertyAccess<?>> map = TK.newHashMap();
        Config config = this;
        synchronized (config) {
            if (this.registeredClasses == null) {
                return map;
            }
            for (Class<?> clazz : this.registeredClasses) {
                try {
                    for (Map.Entry<Field, PropertyAccess<?>> entry : Property.listStatic(clazz).entrySet()) {
                        Field field = entry.getKey();
                        if (!field.isAnnotationPresent(ConfigEntry.class)) continue;
                        map.put(field.getAnnotation(ConfigEntry.class).value(), entry.getValue());
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    MLogger.exception(illegalAccessException);
                }
            }
        }
        return map;
    }

    public synchronized boolean isError() {
        return this.loadError || this.path == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean load() {
        MProperties mProperties;
        this.checkPermission(null, "read");
        if (this.path == null) {
            return false;
        }
        boolean bl = false;
        MProperties mProperties2 = mProperties = this.flags.isSet(4L) ? Config.getGlobalDefaults() : null;
        if (mProperties == null) {
            this.properties = new MProperties();
        } else if ("true".equals(mProperties.getProperty("IMMUTABLE"))) {
            bl = true;
            this.readOnly = true;
            this.properties = mProperties;
        } else {
            this.properties = new MProperties(mProperties);
        }
        try {
            if (!bl) {
                if (this.flags.isSet(2L)) {
                    this.properties.loadUTF8(this.getClass().getClassLoader().getResourceAsStream(this.path));
                } else {
                    this.properties.loadUTF8(this.path);
                }
            }
            this.modified = false;
            boolean bl2 = true;
            return bl2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl3 = false;
            return bl3;
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            if (this.registeredClasses != null) {
                for (Class<?> clazz : this.registeredClasses) {
                    this.read(clazz);
                }
            }
        }
    }

    public void read(Class<?> clazz) {
        this.read(clazz, null);
    }

    public synchronized void read(Class<?> clazz, Object object) {
        try {
            Map<Field, PropertyAccess<?>> map = object == null ? Property.listStatic(clazz) : Property.list(object);
            for (Map.Entry<Field, PropertyAccess<?>> entry : map.entrySet()) {
                Field field = entry.getKey();
                if (!field.isAnnotationPresent(ConfigEntry.class)) continue;
                String string = field.getAnnotation(ConfigEntry.class).value();
                if (field.isAnnotationPresent(PlatformConfig.class)) {
                    string = Config.getPlatformKey(string);
                }
                this.readProperty(string, entry.getValue());
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            MLogger.exception(illegalAccessException);
        }
    }

    public boolean read(String string, boolean bl) {
        String string2 = this.readValue("Boolean", string, Boolean.toString(bl));
        return Boolean.parseBoolean(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PropertyAccess<?>> void readProperty(String string, T object) {
        if (object instanceof SecureProperty) {
            object = ((SecureProperty)SecureProperty.class.cast(object)).getProperty();
        }
        if (object instanceof BooleanProperty) {
            BooleanProperty booleanProperty = (BooleanProperty)object;
            booleanProperty.set(this.read(string, (Boolean)booleanProperty.getDefaultValue()));
        } else if (object instanceof ColorProperty) {
            ColorProperty colorProperty = (ColorProperty)object;
            colorProperty.set(this.readColor(string, (Color)colorProperty.getDefaultValue()));
        } else if (object instanceof DateProperty) {
            DateProperty dateProperty = (DateProperty)object;
            dateProperty.set(this.readDate(string, (Date)dateProperty.getDefaultValue()));
        } else if (object instanceof DoubleProperty) {
            DoubleProperty doubleProperty = (DoubleProperty)object;
            doubleProperty.set(this.readDouble(string, (Double)doubleProperty.getDefaultValue()));
        } else if (object instanceof EnumProperty) {
            EnumProperty enumProperty = (EnumProperty)object;
            enumProperty.set(this.readValue("Enum", string, ((Enum)enumProperty.getDefaultValue()).name()));
        } else if (object instanceof FloatProperty) {
            FloatProperty floatProperty = (FloatProperty)object;
            floatProperty.set(Float.valueOf(this.readFloat(string, ((Float)floatProperty.getDefaultValue()).floatValue())));
        } else if (object instanceof FontProperty) {
            FontProperty fontProperty = (FontProperty)object;
            fontProperty.set(this.readFont(string, (Font)fontProperty.getDefaultValue()));
        } else if (object instanceof IntegerProperty) {
            IntegerProperty integerProperty = (IntegerProperty)object;
            integerProperty.set(this.readInt(string, (Integer)integerProperty.getDefaultValue()));
        } else if (object instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)object;
            stringProperty.set(this.read(string, (String)stringProperty.getDefaultValue()));
        } else {
            Config config = this;
            synchronized (config) {
                log.errorFormat("Cannot read unsupported %s property: %s (%s)", object.getClass().getName(), string, this.path);
            }
        }
    }

    public String read(String string, String string2) {
        return this.readValue("String", string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color readColor(String string, Color color) {
        try {
            String string2 = this.readValue("Color", string, null);
            if (TK.isEmpty(string2)) {
                return color;
            }
            return ColorProperty.parseColor(string2);
        }
        catch (ParseException parseException) {
            Config config = this;
            synchronized (config) {
                log.errorFormat("Invalid color value (%s, %s)", string, this.path);
            }
            return color;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return color;
        }
    }

    public MDate readDate(String string, Date date) {
        return this.readDate(string, date == null ? 0L : date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MDate readDate(String string, long l) {
        try {
            String string2 = this.readValue("Date", string, null);
            if (string2 == null) {
                return new MDate(l);
            }
            return new MDate(Long.parseLong(string2));
        }
        catch (NumberFormatException numberFormatException) {
            Config config = this;
            synchronized (config) {
                log.errorFormat("Invalid date value (%s, %s)", string, this.path);
            }
            return new MDate(l);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return new MDate(l);
        }
    }

    public Dimension readDimension(String string, Dimension dimension) {
        return this.readDimension(string, dimension.width, dimension.height);
    }

    public Dimension readDimension(String string, int n, int n2) {
        return new Dimension(this.readInt(string + ".width", n), this.readInt(string + ".height", n2));
    }

    public double readDouble(String string, double d) {
        try {
            return Double.parseDouble(this.readValue("Double", string, ""));
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return d;
        }
    }

    public <T extends Enum<T>> T readEnum(String string, T t) {
        String string2 = this.readValue("Enum", string, null);
        return EnumProperty.parse(string2, t);
    }

    public float readFloat(String string, float f) {
        try {
            return Float.parseFloat(this.readValue("Float", string, ""));
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return f;
        }
    }

    public Font readFont(String string, Font font) {
        String string2 = this.readValue("Font", string, null);
        if (string2 == null) {
            return font;
        }
        return Font.decode(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt(String string, int n) {
        try {
            String string2 = this.readValue("Integer", string, null);
            if (string2 == null) {
                return n;
            }
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Config config = this;
            synchronized (config) {
                log.errorFormat("Invalid integer value (%s, %s)", string, this.path);
            }
            return n;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return n;
        }
    }

    public int readInt(String string, int n, int n2) {
        return this.readInt(string, n, n2, Integer.MAX_VALUE);
    }

    public int readInt(String string, int n, int n2, int n3) {
        return TK.range(this.readInt(string, n), n, n2, n3);
    }

    public int readInt(String string, int n, IntRange intRange) {
        IntInfo intInfo = intRange.getIntInfo();
        return TK.range(this.readInt(string, n), n, intInfo.getMinimum(), intInfo.getMaximum());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong(String string, long l) {
        try {
            return Long.parseLong(this.readValue("Integer", string, ""));
        }
        catch (NumberFormatException numberFormatException) {
            Config config = this;
            synchronized (config) {
                log.errorFormat("Invalid integer (Long) value (%s, %s)", string, this.path);
            }
            return l;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return l;
        }
    }

    public Point readPoint(String string, int n, int n2) {
        return new Point(this.readInt(string + ".x", n), this.readInt(string + ".y", n2));
    }

    public Point readPoint(String string, Point point) {
        return this.readPoint(string, point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readValue(String string, String string2) {
        if (string == null) {
            return string2;
        }
        Config config = this;
        synchronized (config) {
            if (this.properties == null) {
                return string2;
            }
            String string3 = this.properties.getProperty(string + Config.getLanguageKey(), null);
            if (string3 != null) {
                return string3;
            }
            string3 = this.properties.getProperty(string, string2);
            String string4 = string3 == null ? string2 : string3;
            return string4;
        }
    }

    public String readValue(String string, String string2, String string3) {
        return this.readValue(string + "." + string2, string3);
    }

    public synchronized void registerClass(Class<?> clazz) {
        this.checkPermission(clazz.getName(), "write");
        if (this.registeredClasses == null) {
            this.registeredClasses = new ArrayList();
        }
        this.registeredClasses.add(clazz);
    }

    public static synchronized void registerDefaultClass(Class<?> clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(null, clazz.getName(), "write"));
        }
        if (defaultClasses == null) {
            defaultClasses = new ArrayList();
        }
        defaultClasses.add(clazz);
    }

    public synchronized void removeAll() {
        this.checkPermission(null, "write");
        if (!this.readOnly) {
            this.modified = true;
            if (this.properties != null) {
                this.properties.clear();
            }
        }
    }

    public void removeBoolean(String string) {
        this.removeValue("Boolean." + string);
    }

    public void removeDate(String string) {
        this.removeValue("Date." + string);
    }

    public void removeInt(String string) {
        this.removeValue("Integer." + string);
    }

    public void removeString(String string) {
        this.removeValue("String." + string);
    }

    public synchronized void removeValue(String string) {
        this.checkPermission(string, "write");
        if (this.readOnly) {
            return;
        }
        if (this.properties != null && this.properties.containsKey(string)) {
            this.properties.remove(string);
            this.modified = true;
        }
    }

    public synchronized void removeAllValues(RegExp regExp) {
        this.checkPermission(regExp.toString(), "write");
        if (this.readOnly || this.properties == null) {
            return;
        }
        Iterator<Object> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!regExp.matches(object.toString())) continue;
            iterator.remove();
            this.modified = true;
        }
    }

    public synchronized boolean sync() {
        if (this.readOnly || this.properties == null) {
            return false;
        }
        if (this.registeredClasses != null) {
            for (Class<?> clazz : this.registeredClasses) {
                this.write(clazz);
            }
        }
        if (!this.modified) {
            return true;
        }
        if (this.path == null) {
            return false;
        }
        this.properties.setComment(defaultComment);
        try {
            this.properties.storeUTF8(this.path);
            this.modified = false;
            return true;
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return false;
        }
    }

    public void write(Class<?> clazz) {
        this.write(clazz, null);
    }

    public synchronized void write(Class<?> clazz, Object object) {
        try {
            Map<Field, PropertyAccess<?>> map = object == null ? Property.listStatic(clazz) : Property.list(object);
            for (Map.Entry<Field, PropertyAccess<?>> entry : map.entrySet()) {
                Field field = entry.getKey();
                if (!field.isAnnotationPresent(ConfigEntry.class)) continue;
                String string = field.getAnnotation(ConfigEntry.class).value();
                if (field.isAnnotationPresent(PlatformConfig.class)) {
                    string = Config.getPlatformKey(string);
                }
                this.write(string, entry.getValue());
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            MLogger.exception(illegalAccessException);
        }
    }

    public void write(String string, boolean bl) {
        this.writeValue("Boolean", string, Boolean.toString(bl));
    }

    public void write(String string, Color color) {
        this.writeValue("Color", string, color == null ? "" : TK.toByteHex(color.getRed()) + TK.toByteHex(color.getGreen()) + TK.toByteHex(color.getBlue()));
    }

    public void write(String string, Date date) {
        this.writeDate(string, date == null ? 0L : date.getTime());
    }

    public void write(String string, Dimension dimension) {
        this.write(string + ".width", dimension.width);
        this.write(string + ".height", dimension.height);
    }

    public void write(String string, double d) {
        this.writeValue("Double", string, Double.toString(d));
    }

    public void write(String string, Enum<?> enum_) {
        this.writeValue("Enum", string, enum_.name());
    }

    public void write(String string, float f) {
        this.writeValue("Float", string, Float.toString(f));
    }

    public void write(String string, Font font) {
        this.writeValue("Font", string, FontProperty.toString(font));
    }

    public void write(String string, int n) {
        this.writeValue("Integer", string, Integer.toString(n));
    }

    public void write(String string, long l) {
        this.writeValue("Integer", string, Long.toString(l));
    }

    public void write(String string, Point point) {
        this.write(string + ".x", point.x);
        this.write(string + ".y", point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, PropertyAccess<?> propertyAccess) {
        if (propertyAccess instanceof SecureProperty) {
            propertyAccess = ((SecureProperty)SecureProperty.class.cast(propertyAccess)).getProperty();
        }
        if (propertyAccess instanceof BooleanProperty) {
            this.write(string, (Boolean)((BooleanProperty)BooleanProperty.class.cast(propertyAccess)).get());
        } else if (propertyAccess instanceof ColorProperty) {
            this.write(string, (Color)((ColorProperty)ColorProperty.class.cast(propertyAccess)).get());
        } else if (propertyAccess instanceof DateProperty) {
            this.write(string, (Date)((DateProperty)DateProperty.class.cast(propertyAccess)).get());
        } else if (propertyAccess instanceof DoubleProperty) {
            this.write(string, (Double)((DoubleProperty)DoubleProperty.class.cast(propertyAccess)).get());
        } else if (propertyAccess instanceof EnumProperty) {
            EnumProperty enumProperty = (EnumProperty)propertyAccess;
            this.write(string, (Enum)enumProperty.get());
        } else if (propertyAccess instanceof FloatProperty) {
            this.write(string, ((Float)((FloatProperty)FloatProperty.class.cast(propertyAccess)).get()).floatValue());
        } else if (propertyAccess instanceof FontProperty) {
            this.write(string, ((FontProperty)FontProperty.class.cast(propertyAccess)).get());
        } else if (propertyAccess instanceof IntegerProperty) {
            this.write(string, (Integer)((IntegerProperty)IntegerProperty.class.cast(propertyAccess)).get());
        } else if (propertyAccess instanceof StringProperty) {
            this.write(string, ((Object)propertyAccess).toString());
        } else {
            Config config = this;
            synchronized (config) {
                log.errorFormat("Cannot write unsupported %s property: %s=%s (%s)", propertyAccess.getClass().getName(), string, propertyAccess, this.path);
            }
        }
    }

    public void write(String string, String string2) {
        this.writeValue("String", string, string2);
    }

    public void writeDate(String string, long l) {
        this.writeValue("Date", string, Long.toString(l));
    }

    public void writeValue(String string, String string2) {
        this.writeValue(null, string, string2);
    }

    public synchronized void writeValue(String string, String string2, String string3) {
        if (this.readOnly || this.properties == null) {
            return;
        }
        if (string2 == null) {
            log.errorFormat("key == null (%s)", this.path);
            return;
        }
        String string4 = string == null ? string2 : string + "." + string2;
        try {
            String string5 = this.properties.getProperty(string4, null);
            if (TK.isChange(string5, string3)) {
                this.checkPermission(string4, "write");
                if (string3 == null) {
                    this.properties.remove(string4);
                } else {
                    this.properties.setProperty(string4, string3);
                }
                this.modified = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            MLogger.exception(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config freeze() {
        this.checkPermission(null, "freeze");
        Config config = this;
        synchronized (config) {
            this.readOnly = true;
        }
        return this;
    }

    @Override
    public boolean isImmutable() {
        return this.readOnly;
    }

    protected void checkPermission(String string, String string2) {
        SecurityManager securityManager;
        if (this.flags.isSet(16L) && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new Permission(this, string, string2));
        }
    }

    private static MProperties getGlobalDefaults() {
        String string = OS.isUnix() ? "/etc/makagiga/makagiga.properties" : FS.getBaseDir() + "\\makagiga.properties";
        if (!FS.exists(string)) {
            return null;
        }
        MProperties mProperties = new MProperties();
        try {
            MLogger.info("core", "Using \"%s\" as default settings", string);
            mProperties.loadUTF8(string);
            return mProperties;
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return null;
        }
    }

    private static synchronized String getLanguageKey() {
        if (langKey == null) {
            langKey = "[" + OS.getLocale().getLanguage() + "]";
        }
        return langKey;
    }

    static {
        log = MLogger.get("config");
    }

    public static final class Permission
    extends MPermission {
        public static final String FREEZE_ACTION = "freeze";
        public static final String GET_DEFAULT_ACTION = "get-default";
        public static final String READ_ACTION = "read";
        @Deprecated
        public static final String READ_WRITE_ACTION = "read,write";
        @Deprecated
        public static final String REGISTER_ACTION = "register";
        @Deprecated
        public static final String REGISTER_DEFAULT_ACTION = "register-default";
        @Deprecated
        public static final String REMOVE_ACTION = "remove";
        @Deprecated
        public static final String SET_DEFAULT_COMMENT_ACTION = "set-default-comment";
        @Deprecated
        public static final String SYNC_ACTION = "sync";
        public static final String WRITE_ACTION = "write";

        @Deprecated
        public Permission(Config config, String string, String string2) {
            super(string == null ? "NULL" : string, PermissionInfo.ThreatLevel.MEDIUM, "Global Configuration File");
            this.setActions(string2);
        }

        @Override
        public String getActions() {
            return super.getActions();
        }
    }

    public static interface IntRange {
        public IntInfo getIntInfo();
    }

    public static final class IntInfo {
        private final int max;
        private final int min;

        public IntInfo(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        public int getMaximum() {
            return this.max;
        }

        public int getMinimum() {
            return this.min;
        }
    }

    public static interface GlobalEntry {
        public String getGlobalEntry(String var1);
    }
}

