/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Font;
import java.text.ParseException;
import org.makagiga.commons.Property;
import org.makagiga.commons.UI;

public class FontProperty
extends Property<Font> {
    public FontProperty() {
    }

    public FontProperty(Font font) {
        super(font);
    }

    public FontProperty(String string, int n, int n2) {
        this(new Font(string, n, n2));
    }

    @Override
    public synchronized Font get() {
        Font font = (Font)super.get();
        if (font == null) {
            font = UI.createDefaultFont();
            this.set(font);
            this.setDefaultValue(font);
        }
        return font;
    }

    @Override
    public Class<Font> getType() {
        return Font.class;
    }

    @Override
    public void parse(String string) throws ParseException {
        this.set(Font.decode(string));
    }

    @Override
    public String toString() {
        return FontProperty.toString(this.get());
    }

    public static String toString(Font font) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(font.getName()).append('-');
        switch (font.getStyle()) {
            case 0: {
                stringBuilder.append("PLAIN");
                break;
            }
            case 2: {
                stringBuilder.append("ITALIC");
                break;
            }
            case 1: {
                stringBuilder.append("BOLD");
                break;
            }
            case 3: {
                stringBuilder.append("BOLDITALIC");
                break;
            }
            default: {
                stringBuilder.append("PLAIN");
            }
        }
        stringBuilder.append('-').append(font.getSize());
        return stringBuilder.toString();
    }
}

