/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MFrame;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MTable;
import org.makagiga.commons.UI;

public final class MCellTip {
    private boolean visible;
    private static MCellTip _instance;
    private PopupContent _content;
    private static final String MOUSE_LISTENER = "org.makagiga.commons.MCellTip.mouseListener";

    public static synchronized MCellTip getInstance() {
        if (_instance == null) {
            _instance = new MCellTip();
        }
        return _instance;
    }

    public void install(JComponent jComponent) {
        if (!(jComponent instanceof JList || jComponent instanceof JTable || jComponent instanceof JTree)) {
            throw new IllegalArgumentException("Component of \"" + jComponent.getClass().getName() + "\" type is not supported");
        }
        StaticHandler staticHandler = new StaticHandler();
        jComponent.addMouseListener(staticHandler);
        jComponent.addMouseMotionListener(staticHandler);
        jComponent.putClientProperty(MOUSE_LISTENER, staticHandler);
    }

    public void uninstall(JComponent jComponent) {
        MMouseAdapter mMouseAdapter = UI.getClientProperty(jComponent, MOUSE_LISTENER, null);
        if (mMouseAdapter != null) {
            jComponent.removeMouseListener(mMouseAdapter);
            jComponent.removeMouseMotionListener(mMouseAdapter);
            jComponent.putClientProperty(MOUSE_LISTENER, null);
        }
    }

    public static boolean isSupported() {
        if (UI.isGTK()) {
            return false;
        }
        return !UI.isRetro() && !UI.isSubstance();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.setVisible(null, bl);
    }

    @Deprecated
    public void setVisible(JComponent jComponent, boolean bl) {
        if (bl == this.visible) {
            return;
        }
        this.visible = bl;
        if (bl) {
            this.getContent().setVisible(true);
        } else if (this._content != null) {
            this.getContent().setup(null, null);
            this.getContent().setVisible(false);
        }
    }

    private MCellTip() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent.getID() == 507) {
                    MCellTip.this.setVisible(false);
                }
            }
        }, 131072L);
    }

    private PopupContent getContent() {
        if (this._content == null) {
            this._content = new PopupContent();
        }
        return this._content;
    }

    private static boolean isAllVisible(JComponent jComponent, Rectangle rectangle) {
        Rectangle rectangle2;
        JViewport jViewport = MScrollPane.getViewport(jComponent);
        if (jViewport == null) {
            rectangle2 = jComponent.getBounds();
        } else {
            rectangle2 = jViewport.getBounds();
            Point point = jViewport.getViewPosition();
            rectangle2.translate(point.x, point.y);
        }
        int n = UI.isNimbus() && (Boolean)UI.hackNimbus.get() != false ? 3 : 1;
        Rectangle rectangle3 = new Rectangle(rectangle);
        if (jComponent instanceof JTable) {
            JTable jTable = (JTable)jComponent;
            JTableHeader jTableHeader = jTable.getTableHeader();
            rectangle3.translate(n, jTableHeader == null ? n : jTableHeader.getHeight() + n);
        } else {
            rectangle3.translate(n, n);
        }
        return rectangle2.contains(rectangle3);
    }

    private void processList(JList jList, MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = jList.locationToIndex(point);
        if (n == -1) {
            this.setVisible(false);
            return;
        }
        Rectangle rectangle = jList.getCellBounds(n, n);
        if (rectangle == null || !rectangle.contains(point)) {
            this.setVisible(false);
            return;
        }
        if (MCellTip.isAllVisible(jList, rectangle)) {
            this.setVisible(false);
            return;
        }
        Object e = jList.getModel().getElementAt(n);
        if (this._content == null || e == null || !e.equals(this.getContent().currentValue)) {
            PopupContent popupContent = this.getContent();
            popupContent.currentRow = n;
            popupContent.currentValue = e;
            popupContent.setup(jList, rectangle);
            this.setVisible(true);
        }
    }

    private void processMouseMove(MouseEvent mouseEvent) {
        if (!MCellTip.isSupported()) {
            return;
        }
        if (MMenu.getCurrentPopup() != null) {
            this.setVisible(false);
            return;
        }
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        if (jComponent instanceof JList) {
            this.processList((JList)jComponent, mouseEvent);
        } else if (jComponent instanceof JTable) {
            this.processTable((JTable)jComponent, mouseEvent);
        } else if (jComponent instanceof JTree) {
            this.processTree((JTree)jComponent, mouseEvent);
        }
    }

    private void processTable(JTable jTable, MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = jTable.columnAtPoint(point);
        int n2 = jTable.rowAtPoint(point);
        if (n == -1 || n2 == -1) {
            this.setVisible(false);
            return;
        }
        int n3 = jTable.getEditingColumn();
        int n4 = jTable.getEditingRow();
        if (n3 == n && n4 == n2) {
            this.setVisible(false);
            return;
        }
        Rectangle rectangle = jTable.getCellRect(n2, n, true);
        int n5 = jTable.convertColumnIndexToModel(n);
        int n6 = jTable.convertRowIndexToModel(n2);
        if (this._content == null || n5 != this.getContent().currentColumn || n6 != this.getContent().currentRow) {
            PopupContent popupContent = this.getContent();
            popupContent.currentColumn = n5;
            popupContent.currentRow = n6;
            popupContent.setup(jTable, rectangle);
            this.setVisible(true);
        }
    }

    private void processTree(JTree jTree, MouseEvent mouseEvent) {
        if (jTree.isEditing()) {
            this.setVisible(false);
            return;
        }
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            this.setVisible(false);
            return;
        }
        Rectangle rectangle = jTree.getPathBounds(treePath);
        if (rectangle == null) {
            this.setVisible(false);
            return;
        }
        if (MCellTip.isAllVisible(jTree, rectangle)) {
            this.setVisible(false);
            return;
        }
        if (this._content == null || !treePath.equals(this.getContent().currentTreePath)) {
            PopupContent popupContent = this.getContent();
            popupContent.currentRow = jTree.getRowForPath(treePath);
            popupContent.currentTreePath = treePath;
            popupContent.setup(jTree, rectangle);
            this.setVisible(true);
        }
    }

    private static final class StaticHandler
    extends MMouseAdapter {
        private StaticHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (_instance != null) {
                _instance.setVisible(false);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (_instance != null) {
                _instance.setVisible(false);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (_instance != null) {
                _instance.processMouseMove(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (_instance != null) {
                _instance.setVisible(false);
            }
        }
    }

    private static final class PopupContent
    extends MComponent {
        private int currentColumn = -1;
        private int currentRow = -1;
        private Object currentValue;
        private Rectangle cellBounds = new Rectangle();
        private TreePath currentTreePath;
        private final WeakReference<CellRendererPane> cellPaneRef;
        private WeakReference<JComponent> componentRef;
        private transient WeakReference<Window> oldParentWindowRef;

        @Override
        public void paintComponent(Graphics graphics) {
            if (!MCellTip.isSupported()) {
                return;
            }
            JComponent jComponent = (JComponent)this.componentRef.get();
            if (jComponent == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = new RenderingHints(null);
            UI.setTextAntialiasing(graphics2D, renderingHints);
            Component component = null;
            if (jComponent instanceof JList) {
                JList jList = (JList)jComponent;
                boolean bl = jList.isSelectedIndex(this.currentRow);
                component = jList.getCellRenderer().getListCellRendererComponent(jList, this.currentValue, this.currentRow, bl, false);
                component.setSize(component.getPreferredSize());
                this.paint(graphics2D, component, true);
            } else if (jComponent instanceof JTable) {
                Insets insets;
                Object object;
                int n;
                JTable jTable = (JTable)jComponent;
                int n2 = jTable.convertColumnIndexToView(this.currentColumn);
                try {
                    n = jTable.convertRowIndexToView(this.currentRow);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    MLogger.exception(indexOutOfBoundsException);
                    return;
                }
                if (n == -1) {
                    return;
                }
                boolean bl = jTable.isCellSelected(n, n2);
                component = jTable.getCellRenderer(n, n2).getTableCellRendererComponent(jTable, jTable.getModel().getValueAt(this.currentRow, this.currentColumn), bl, false, n, n2);
                component.setMinimumSize(null);
                component.setPreferredSize(null);
                component.setSize(1, 1);
                component.validate();
                Rectangle rectangle = jTable.getCellRect(n, n2, true);
                boolean bl2 = MCellTip.isAllVisible(jTable, rectangle);
                if (bl2 && jTable instanceof MTable && !((MTable)MTable.class.cast(jTable)).isCellTipEnabled(n, n2)) {
                    return;
                }
                this.cellBounds.width = Math.max(rectangle.width, component.getPreferredSize().width);
                this.cellBounds.height = rectangle.height;
                Dimension dimension = this.cellBounds.getSize();
                if (component instanceof JComponent && (object = ((JComponent)JComponent.class.cast(component)).getBorder()) != null && (insets = object.getBorderInsets(component)) != null) {
                    this.cellBounds.width += insets.left + insets.right;
                }
                if (jTable.getShowHorizontalLines()) {
                    --this.cellBounds.height;
                }
                if (jTable.getShowVerticalLines()) {
                    --this.cellBounds.width;
                    if (!UI.isNimbus() && !jTable.getShowHorizontalLines()) {
                        --this.cellBounds.height;
                        --this.cellBounds.width;
                    }
                }
                if (dimension.width == rectangle.width && dimension.height == rectangle.height && bl2) {
                    return;
                }
                object = this.cellBounds.getSize();
                component.setMinimumSize((Dimension)object);
                component.setPreferredSize((Dimension)object);
                this.paint(graphics2D, component, false);
            } else if (jComponent instanceof JTree) {
                JTree jTree = (JTree)jComponent;
                boolean bl = jTree.isRowSelected(this.currentRow);
                TreeNode treeNode = (TreeNode)this.currentTreePath.getLastPathComponent();
                component = jTree.getCellRenderer().getTreeCellRendererComponent(jTree, treeNode, bl, jTree.isExpanded(this.currentTreePath), treeNode.isLeaf(), this.currentRow, false);
                this.paint(graphics2D, component, true);
            }
            graphics2D.addRenderingHints(renderingHints);
        }

        private PopupContent() {
            super(new BorderLayout());
            this.setOpaque(false);
            CellRendererPane cellRendererPane = new CellRendererPane();
            this.cellPaneRef = new WeakReference<CellRendererPane>(cellRendererPane);
            this.add((Component)cellRendererPane, "Center");
        }

        private void paint(Graphics graphics, Component component, boolean bl) {
            JComponent jComponent = (JComponent)this.componentRef.get();
            if (jComponent == null) {
                return;
            }
            Color color = jComponent.getBackground();
            if (color == null) {
                color = Color.WHITE;
            }
            graphics.setColor(color);
            graphics.fillRect(this.cellBounds.x + 1, this.cellBounds.y + 1, this.cellBounds.width - 2, this.cellBounds.height - 2);
            CellRendererPane cellRendererPane = (CellRendererPane)this.cellPaneRef.get();
            if (cellRendererPane == null) {
                return;
            }
            cellRendererPane.paintComponent(graphics, component, null, this.cellBounds.x, this.cellBounds.y, this.cellBounds.width, this.cellBounds.height, bl);
        }

        private void setup(JComponent jComponent, Rectangle rectangle) {
            this.componentRef = new WeakReference<JComponent>(jComponent);
            if (jComponent == null) {
                this.currentColumn = -1;
                this.currentRow = -1;
                this.currentTreePath = null;
                this.currentValue = null;
            } else {
                this.setCursor(jComponent.getCursor());
                this.setupGlassPane();
                Point point = rectangle.getLocation();
                SwingUtilities.convertPointToScreen(point, jComponent);
                SwingUtilities.convertPointFromScreen(point, this);
                this.cellBounds.setLocation(Math.max(point.x, 0), point.y);
                this.cellBounds.setSize(rectangle.width, rectangle.height);
                this.setBackground(jComponent.getBackground());
                this.setForeground(jComponent.getForeground());
                this.repaint();
            }
        }

        private void setupGlassPane() {
            Object object;
            JComponent jComponent = (JComponent)this.componentRef.get();
            if (jComponent == null) {
                return;
            }
            Window window = UI.windowFor(jComponent);
            if (this.oldParentWindowRef != null && (object = (Window)this.oldParentWindowRef.get()) != null && object != window) {
                MFrame.clearGlassPane((RootPaneContainer)object);
                this.oldParentWindowRef.clear();
                this.oldParentWindowRef = null;
            }
            if (window instanceof RootPaneContainer) {
                this.oldParentWindowRef = new WeakReference<Window>(window);
                object = (RootPaneContainer)((Object)window);
                if (object.getGlassPane() != this && !object.getGlassPane().isVisible()) {
                    object.setGlassPane(this);
                }
            }
        }
    }
}

