/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Window;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MTable;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.mv.BooleanRenderer;

public class MCheckBoxTable<T>
extends MTable<CheckBoxModel<T>> {
    public MCheckBoxTable(String string, String string2, boolean bl, Collection<T> collection) {
        super(new CheckBoxModel(string, string2, bl, collection));
        this.getSelectionModel().setSelectionMode(0);
        this.setGridVisible(false);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.sizeWidthToFit();
        tableColumn.setMaxWidth(tableColumn.getWidth() + 30);
        tableColumnModel.getColumn(0).setCellRenderer(new BooleanRenderer());
        tableColumnModel.getColumn(1).setCellRenderer(new MRenderer<T>(){

            @Override
            protected void onRender(T t) {
                this.setText(String.valueOf(t));
            }
        });
    }

    public MDialog createDialog(Window window, String string, String string2, MActionInfo mActionInfo) {
        MDialog mDialog = new MDialog(window, string, 135);
        mDialog.setDefaultFocus(this);
        mDialog.changeButton((AbstractButton)mDialog.getOKButton(), mActionInfo);
        mDialog.addNorth(MLabel.createFor(this, string2));
        mDialog.addCenter(this);
        MPanel mPanel = MPanel.createGridPanel(2, 1, 0, 5);
        mPanel.add(new MButton(MActionInfo.SELECT_ALL.getText()){

            @Override
            protected void onClick() {
                MCheckBoxTable.this.setAllSelected(true);
            }
        });
        mPanel.add(new MButton(MActionInfo.UNSELECT_ALL.getText()){

            @Override
            protected void onClick() {
                MCheckBoxTable.this.setAllSelected(false);
            }
        });
        mDialog.getButtonsPanel().add(mPanel);
        mDialog.packFixed(UI.WindowSize.LARGE);
        return mDialog;
    }

    public boolean isCheckBoxSelected(int n) {
        return ((CheckBoxModel)this.getModel()).isSelected(this.convertRowIndexToModel(n));
    }

    public void setCheckBoxSelected(int n, boolean bl) {
        ((CheckBoxModel)this.getModel()).setSelected(this.convertRowIndexToModel(n), bl);
    }

    public void setAllSelected(boolean bl) {
        for (CheckBoxItem checkBoxItem : (CheckBoxModel)this.getModel()) {
            checkBoxItem.setSelected(bl);
        }
        ((CheckBoxModel)this.getModel()).fireTableDataChanged();
    }

    public static final class CheckBoxModel<T>
    extends AbstractListTableModel<CheckBoxItem<T>> {
        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.isSelected(n);
                }
                case 1: {
                    return ((CheckBoxItem)this.getRowAt(n)).getValue();
                }
            }
            throw new WTFError("Bad column: " + n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    this.setSelected(n, (Boolean)object);
                    this.fireTableRowsUpdated(n, n);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new WTFError("Bad column: " + n2);
                }
            }
        }

        public boolean isSelected(int n) {
            return ((CheckBoxItem)this.getRowAt(n)).isSelected();
        }

        public void setSelected(int n, boolean bl) {
            ((CheckBoxItem)this.getRowAt(n)).setSelected(bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CheckBoxModel(String string, String string2, boolean bl, Collection<T> collection) {
            super(new AbstractListTableModel.ColumnInfo(string, Boolean.class, true), new AbstractListTableModel.ColumnInfo(string2, Object.class, false));
            try {
                this.setEventsEnabled(false);
                for (T t : collection) {
                    this.addRow(new CheckBoxItem(t, bl));
                }
            }
            finally {
                this.setEventsEnabled(true);
            }
        }
    }

    public static final class CheckBoxItem<T> {
        private boolean selected;
        private final T value;

        public T getValue() {
            return this.value;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        private CheckBoxItem(T t, boolean bl) {
            this.value = t;
            this.selected = bl;
        }
    }
}

