/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.Config;
import org.makagiga.commons.MColorButton;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSmallColorButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.ValueEvent;
import org.makagiga.commons.ValueListener;
import org.makagiga.commons.color.ColorPalette;

public class MColorPicker
extends MPanel {
    public static final String COLOR_PROPERTY = "color";
    private final ColorComponent colorComponent;
    private final MColorButton customColorButton;
    private final MPanel colorButtonPanel;
    MComboBox<ColorPalette> colorPaletteComboBox;

    public MColorPicker() {
        this(ColorPalette.getDefaultPalette());
    }

    public MColorPicker(ColorPalette colorPalette) {
        this(colorPalette, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public MColorPicker(ColorPalette colorPalette, int n) {
        boolean bl = !("<" + UI._("Default") + ">").equals(colorPalette.toString());
        this.colorComponent = new ColorComponent(this);
        this.setColorPalette(colorPalette);
        this.addCenter(new MScrollPane(this.colorComponent, 2));
        this.customColorButton = new MColorButton();
        this.customColorButton.addValueListener(new ValueListener<Color>(){

            @Override
            public void valueChanged(ValueEvent<Color> valueEvent) {
                MColorPicker.this.firePropertyChange(MColorPicker.COLOR_PROPERTY, valueEvent.getOldValue(), valueEvent.getNewValue());
                MColorPicker.this.fireStateChanged();
            }
        });
        this.colorButtonPanel = MPanel.createHLabelPanel(this.customColorButton, UI._("More:"));
        if (!bl) {
            this.addSouth(this.colorButtonPanel);
        }
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MColorPicker.this.onChange();
            }
        });
        if (!bl) {
            this.colorPaletteComboBox = new MComboBox<ColorPalette>(){

                @Override
                protected void onSelect() {
                    MColorPicker.this.setColorPalette((ColorPalette)this.getSelectedItem());
                }
            };
            this.colorPaletteComboBox.setRenderer(new MRenderer());
            this.colorPaletteComboBox.setRequestFocusEnabled(false);
            this.colorPaletteComboBox.setToolTipText(UI._("Color Palette"));
            try {
                this.colorPaletteComboBox.setEventsEnabled(false);
                this.colorPaletteComboBox.addItem((ColorPalette)colorPalette);
                this.colorPaletteComboBox.addAllItems((Collection<ColorPalette>)ColorPalette.getAll());
            }
            finally {
                this.colorPaletteComboBox.setEventsEnabled(true);
            }
            this.addNorth(this.colorPaletteComboBox);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public Color getColor() {
        return this.customColorButton.getColor();
    }

    public void setColor(Color color) {
        Color color2 = this.getColor();
        this.customColorButton.setColor(color);
        if (TK.isChange(color2, color)) {
            this.firePropertyChange(COLOR_PROPERTY, color2, color);
        }
    }

    public ColorPalette getSelectedColorPalette() {
        return this.colorPaletteComboBox != null ? this.colorPaletteComboBox.getSelectedItem() : null;
    }

    public void setSelectedColorPalette(ColorPalette colorPalette) {
        if (this.colorPaletteComboBox != null) {
            this.colorPaletteComboBox.setSelectedItem(colorPalette);
        }
    }

    public boolean isColorButtonVisible() {
        return this.colorButtonPanel.isVisible();
    }

    public void setColorButtonVisible(boolean bl) {
        this.colorButtonPanel.setVisible(bl);
    }

    public void readConfig(Config config, String string) {
        TK.checkNullOrEmpty(string);
        if (this.colorPaletteComboBox == null) {
            return;
        }
        String string2 = config.read(string + ".colorPaletteName", null);
        if (string2 != null) {
            for (ColorPalette colorPalette : this.colorPaletteComboBox) {
                if (!colorPalette.toString().equals(string2)) continue;
                this.colorPaletteComboBox.setSelectedItem(colorPalette);
                break;
            }
        }
    }

    public void writeConfig(Config config, String string) {
        TK.checkNullOrEmpty(string);
        if (this.colorPaletteComboBox == null) {
            return;
        }
        String string2 = this.colorPaletteComboBox.getSelectedItem().toString();
        config.write(string + ".colorPaletteName", string2);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.colorComponent.setEnabled(bl);
        this.customColorButton.setEnabled(bl);
    }

    protected void fireStateChanged() {
        TK.fireStateChanged(this, this.getChangeListeners());
    }

    @Deprecated
    protected void onChange() {
    }

    private void setColorPalette(ColorPalette colorPalette) {
        this.colorComponent.buttonSize = colorPalette.getCount() > 50 ? 10 : MIcon.getSmallSize();
        this.colorComponent.setColorPalette(colorPalette);
        Dimension dimension = this.colorComponent.getPreferredSize();
        this.colorComponent.setSize(dimension);
        MScrollPane.scrollToTop(this.colorComponent, true);
        this.revalidate();
        this.repaint();
    }

    private static final class ColorComponent
    extends MComponent {
        private ColorPalette colorPalette;
        private int buttonSize;
        private List<Color> colorList;
        private final WeakReference<MColorPicker> colorPickerRef;

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.buttonSize, this.buttonSize);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.colorPalette == null) {
                return this.getMinimumSize();
            }
            return new Dimension(this.colorPalette.getColumns() * this.buttonSize, this.colorPalette.getRows() * this.buttonSize);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Color color;
            if (this.colorPalette != null && (color = this.getColor(mouseEvent.getX(), mouseEvent.getY())) != null) {
                return MSmallColorButton.getToolTipText(color, this.colorPalette);
            }
            return null;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.colorPalette == null) {
                return;
            }
            int n = this.colorPalette.getColumns();
            int n2 = this.colorPalette.getRows();
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                int n5 = 0;
                for (int j = 0; j < n; ++j) {
                    if (n3 < this.colorPalette.getCount()) {
                        Color color = this.colorList.get(n3);
                        if (!this.isEnabled()) {
                            color = color.darker();
                        }
                        graphics.setColor(color);
                        graphics.fillRect(n5, n4, this.buttonSize, this.buttonSize);
                    }
                    ++n3;
                    n5 += this.buttonSize;
                }
                n4 += this.buttonSize;
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed() && mouseEvent.getID() == 500 && MMouseAdapter.isLeft(mouseEvent)) {
                mouseEvent.consume();
                if (!this.isEnabled()) {
                    TK.beep();
                    return;
                }
                Color color = this.getColor(mouseEvent.getX(), mouseEvent.getY());
                if (color != null) {
                    MColorPicker mColorPicker = (MColorPicker)this.colorPickerRef.get();
                    mColorPicker.setColor(color);
                    mColorPicker.fireStateChanged();
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
            if (mouseEvent.getID() == 503) {
                Color color = this.getColor(mouseEvent.getX(), mouseEvent.getY());
                this.setCursor(color != null ? 12 : 0);
            }
        }

        private ColorComponent(MColorPicker mColorPicker) {
            this.colorPickerRef = TK.newWeakRef(mColorPicker);
            this.setToolTipText("");
        }

        private Color getColor(int n, int n2) {
            Dimension dimension = this.getPreferredSize();
            if (n > dimension.width - 1 || n2 > dimension.height - 1) {
                return null;
            }
            int n3 = n / this.buttonSize + n2 / this.buttonSize * this.colorPalette.getColumns();
            return n3 < this.colorList.size() ? this.colorList.get(n3) : null;
        }

        private void setColorPalette(ColorPalette colorPalette) {
            this.colorList = colorPalette.toColorList();
            this.colorPalette = colorPalette;
        }
    }
}

