/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.makagiga.commons.Immutable;
import org.makagiga.commons.MCalendar;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class MDate
extends Date
implements Immutable<MDate> {
    private boolean immutable;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    @Deprecated
    public static final String RFC822_FORMAT = "EEE, d MMM yyyy HH:mm:ss Z";

    public MDate() {
    }

    public MDate(Calendar calendar) {
        super(calendar.getTimeInMillis());
    }

    public MDate(Date date) {
        super(date.getTime());
    }

    public MDate(long l) {
        super(l);
    }

    public static void clearTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public CompareResult compareDateTime(MDate mDate, boolean bl) {
        if (!this.isValid()) {
            return CompareResult.UNKNOWN;
        }
        Calendar calendar = mDate.getCalendar();
        Calendar calendar2 = this.getCalendar();
        if (calendar2.before(calendar)) {
            return CompareResult.BEFORE;
        }
        int n = calendar2.get(5);
        int n2 = calendar2.get(2);
        int n3 = calendar2.get(1);
        if (bl && n == calendar.get(5) && n2 == calendar.get(2) && n3 == calendar.get(1)) {
            return CompareResult.TODAY;
        }
        calendar.add(5, 1);
        if (n == calendar.get(5) && n2 == calendar.get(2) && n3 == calendar.get(1)) {
            return CompareResult.TOMORROW;
        }
        return CompareResult.AFTER;
    }

    public static long currentTime() {
        return new MDate().getTime();
    }

    public String fancyFormat(int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isValid()) {
            MCalendar mCalendar = this.toCalendar();
            if (mCalendar.isSameDate(MCalendar.today())) {
                stringBuilder.append(UI._("Today"));
            } else if (mCalendar.isSameDate(MCalendar.tomorrow())) {
                stringBuilder.append(UI._("Tomorrow"));
            } else if (mCalendar.isSameDate(MCalendar.yesterday())) {
                stringBuilder.append(UI._("Yesterday"));
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(this.formatDate(n));
        }
        if (bl) {
            stringBuilder.append(' ').append(this.formatTime(3));
        }
        return stringBuilder.toString();
    }

    public String format(String string) {
        return new SimpleDateFormat(string).format(this);
    }

    public String format(String string, Locale locale) {
        return new SimpleDateFormat(string, locale).format(this);
    }

    public String formatDate(int n) {
        DateFormat dateFormat = DateFormat.getDateInstance(n);
        return dateFormat.format(this);
    }

    public String formatDateTime(int n, int n2) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n2);
        return dateFormat.format(this);
    }

    public String formatRFC3339() {
        return this.format("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    }

    public String formatRFC822() {
        return this.format(RFC822_FORMAT, Locale.US);
    }

    public String formatTime(int n) {
        DateFormat dateFormat = DateFormat.getTimeInstance(n);
        return dateFormat.format(this);
    }

    public Calendar getCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this);
        return gregorianCalendar;
    }

    public long getDayCount(long l) {
        return MDate.toDays(this.getTime() - l);
    }

    public static MDate invalid() {
        return new MDate(0L);
    }

    public boolean isToday() {
        if (!this.isValid()) {
            return false;
        }
        return this.toCalendar().isSameDate(MCalendar.today());
    }

    public boolean isValid() {
        return this.getTime() != 0L;
    }

    public static MDate now() {
        return new MDate();
    }

    public static MDate parse(String string, String string2, MDate mDate) {
        return MDate.parse(string, string2, Locale.US, mDate);
    }

    public static MDate parse(String string, String string2, Locale locale, MDate mDate) {
        if (TK.isEmpty(string)) {
            return mDate;
        }
        try {
            return new MDate(new SimpleDateFormat(string2, locale).parse(string));
        }
        catch (ParseException parseException) {
            return mDate;
        }
    }

    public static MDate parseRFC3339(String string) {
        int n;
        String string2 = string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DEFAULT_DATE_FORMAT).append("'T'").append(DEFAULT_TIME_FORMAT);
        int n2 = string2.indexOf(46);
        if (n2 != -1) {
            stringBuilder.append(".SS");
        }
        if ((n = string2.indexOf(43)) != -1) {
            String string3 = string2.substring(n + 1).replace(":", "");
            string2 = string2.substring(0, n + 1) + string3;
            stringBuilder.append('Z');
        }
        return MDate.parseRFC(string2, stringBuilder.toString());
    }

    public static MDate parseRFC822(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("EEE, d MMM yyyy ");
        stringBuilder.append(DEFAULT_TIME_FORMAT);
        int n = string.lastIndexOf(32);
        if (n != -1) {
            int n2 = string.lastIndexOf(43);
            if (n2 == -1 || n2 < n) {
                n2 = string.lastIndexOf(45);
            }
            if (n2 != -1 && n2 > n) {
                stringBuilder.append(" z");
            }
        }
        return MDate.parseRFC(string, stringBuilder.toString());
    }

    @Override
    public void setTime(long l) {
        if (this.immutable) {
            throw new IllegalStateException("This date is immutable (read only)");
        }
        super.setTime(l);
    }

    public void setTime(Date date) {
        this.setTime(date.getTime());
    }

    public MCalendar toCalendar() {
        return MCalendar.of(this);
    }

    public static long toDays(long l) {
        return l / 1000L / 3600L / 24L;
    }

    @Override
    public MDate freeze() {
        this.immutable = true;
        return this;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    private static MDate parseRFC(String string, String string2) {
        try {
            return MDate.parse(string, string2, Locale.US, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MLogger.warning("core", "Invalid date: %s", string);
            return null;
        }
    }

    public static enum CompareResult {
        BEFORE,
        TODAY,
        AFTER,
        UNKNOWN,
        TOMORROW;

    }
}

