/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import org.makagiga.commons.WTFError;

public final class MFormat {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;

    public static String toAutoSize(long l) {
        if (l > 0x40000000L) {
            return MFormat.toGB(l);
        }
        if (l > 0x100000L) {
            return MFormat.toMB(l);
        }
        return MFormat.toKB(l);
    }

    public static String toGB(long l) {
        return String.format("%1.2f GiB", Float.valueOf((float)l / 1.0737418E9f));
    }

    public static String toKB(long l) {
        return String.format("%1.2f KiB", Float.valueOf((float)l / 1024.0f));
    }

    public static String toMB(long l) {
        return String.format("%1.2f MiB", Float.valueOf((float)l / 1048576.0f));
    }

    public static String toSize(long l, ByteFormat byteFormat) {
        switch (byteFormat) {
            case AUTO: {
                return MFormat.toAutoSize(l);
            }
            case B: {
                return Long.toString(l) + " B";
            }
            case KB: {
                return MFormat.toKB(l);
            }
            case MB: {
                return MFormat.toMB(l);
            }
            case GB: {
                return MFormat.toGB(l);
            }
        }
        throw new WTFError(byteFormat);
    }

    public static String toPercent(float f) {
        return String.format("%1.1f%%", Float.valueOf(f));
    }

    private MFormat() {
    }

    public static enum ByteFormat {
        AUTO,
        B,
        KB,
        MB,
        GB;

    }
}

