/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.event.EventListenerList;
import org.makagiga.commons.Config;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MBorderLayout;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MMenuBar;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MouseGestures;
import org.makagiga.commons.OS;
import org.makagiga.commons.UI;

public class MFrame
extends JFrame
implements MBorderLayout {
    private boolean oldAlwaysOnTop;
    private boolean fullScreen;
    private EventListenerList ell;
    private static final int MIN_WIDTH = 320;
    private static final int MIN_HEIGHT = 200;
    private MouseGestures mouseGestures;
    private Rectangle oldFrameBounds;

    public MFrame() {
        this((String)null);
    }

    public MFrame(String string) {
        super(string);
    }

    public void addFullScreenListener(FullScreenListener fullScreenListener) {
        if (fullScreenListener != null) {
            if (this.ell == null) {
                this.ell = new EventListenerList();
            }
            this.ell.add(FullScreenListener.class, fullScreenListener);
        }
    }

    public FullScreenListener[] getFullScreenListeners() {
        return this.ell == null ? new FullScreenListener[]{} : (FullScreenListener[])this.ell.getListeners(FullScreenListener.class);
    }

    public void removeFullScreenListener(FullScreenListener fullScreenListener) {
        if (this.ell != null) {
            this.ell.remove(FullScreenListener.class, fullScreenListener);
        }
    }

    public void clearGlassPane() {
        MFrame.clearGlassPane(this);
    }

    public static void clearGlassPane(RootPaneContainer rootPaneContainer) {
        rootPaneContainer.getGlassPane().setVisible(false);
        rootPaneContainer.setGlassPane(new MComponent());
    }

    public MMenuBar getMMenuBar() {
        return (MMenuBar)this.getJMenuBar();
    }

    public MouseGestures getMouseGestures() {
        return this.mouseGestures;
    }

    public void setMouseGestures(MouseGestures mouseGestures) {
        this.mouseGestures = mouseGestures;
        this.mouseGestures.setParent(this);
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(boolean bl) {
        if (bl == this.fullScreen) {
            return;
        }
        FullScreenEvent fullScreenEvent = new FullScreenEvent(this, this.fullScreen);
        FullScreenListener[] fullScreenListenerArray = this.getFullScreenListeners();
        for (FullScreenListener fullScreenListener : fullScreenListenerArray) {
            if (fullScreenListener.isFullScreenSupported(fullScreenEvent)) continue;
            MStatusBar.warning(UI._("Full screen view is not supported"));
            return;
        }
        Component component = FocusManager.getCurrentManager().getFocusOwner();
        this.fullScreen = bl;
        this.dispose();
        this.setResizable(!this.fullScreen);
        if (!UI.isSeaGlass()) {
            this.setUndecorated(this.fullScreen);
        }
        if (this.fullScreen) {
            if (UI.isSeaGlass()) {
                this.getRootPane().setWindowDecorationStyle(0);
            }
            this.oldFrameBounds = this.getBounds();
            this.oldAlwaysOnTop = this.isAlwaysOnTop();
            if (OS.isLinux()) {
                this.setAlwaysOnTop(true);
            }
            this.setLocation(0, 0);
            this.setSize(UI.WindowSize.SCREEN);
            this.validate();
        } else {
            if (UI.isSeaGlass()) {
                this.getRootPane().setWindowDecorationStyle(1);
            }
            if (OS.isLinux()) {
                this.setAlwaysOnTop(this.oldAlwaysOnTop);
            }
            if (this.oldFrameBounds != null) {
                this.setBounds(this.oldFrameBounds);
                this.oldFrameBounds = null;
            }
        }
        for (FullScreenListener fullScreenListener : fullScreenListenerArray) {
            fullScreenListener.fullScreenChange(fullScreenEvent);
        }
        this.setVisible(true);
        if (component != null && component.isDisplayable() && component.isFocusable() && component.isVisible()) {
            component.requestFocusInWindow();
        }
        this.repaint();
    }

    public void readConfig(Config config, String string) {
        string = string == null ? "" : string + ".";
        Dimension dimension = UI.WindowSize.LARGE.getDimension();
        int n = Math.max(320, config.readInt(string + "Window.width", dimension.width));
        int n2 = Math.max(200, config.readInt(string + "Window.height", dimension.height));
        this.setSize(n, n2);
        if (OS.isWindows() && ((Boolean)UI.hackWindowSize.get()).booleanValue() && n > UI.getScreenSize().width) {
            this.setExtendedState(6);
        }
        if (MApplication.isFirstRun()) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(config.readPoint(string + "Window", 0, 0));
        }
    }

    public void setSize(UI.WindowSize windowSize) {
        this.setSize(windowSize.getDimension());
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && MApplication.forceRTL && !this.isVisible()) {
            this.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        super.setVisible(bl);
    }

    public void toggleFullScreen() {
        this.setFullScreen(!this.fullScreen);
    }

    public void writeConfig(Config config, String string) {
        string = string == null ? "" : string + ".";
        config.write(string + "Window", this.getSize());
        config.write(string + "Window.x", Math.max(this.getX(), 0));
        config.write(string + "Window.y", Math.max(this.getY(), 0));
    }

    @Override
    public void addCenter(JComponent jComponent) {
        UI.addCenter(this, jComponent);
    }

    @Override
    public void addEast(JComponent jComponent) {
        this.add((Component)jComponent, "After");
    }

    @Override
    public void addNorth(JComponent jComponent) {
        this.add((Component)jComponent, "First");
    }

    @Override
    public void addSouth(JComponent jComponent) {
        this.add((Component)jComponent, "Last");
    }

    @Override
    public void addWest(JComponent jComponent) {
        this.add((Component)jComponent, "Before");
    }

    public static interface FullScreenListener
    extends EventListener {
        public boolean isFullScreenSupported(FullScreenEvent var1);

        public void fullScreenChange(FullScreenEvent var1);
    }

    public static final class FullScreenEvent
    extends EventObject {
        private final boolean fullScreen;

        public FullScreenEvent(Object object, boolean bl) {
            super(object);
            this.fullScreen = bl;
        }

        public boolean isFullScreen() {
            return this.fullScreen;
        }
    }
}

