/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.Painter;

public class MGraphics
extends MComponent {
    private final List<Item> items = new ArrayList<Item>();

    public static <S extends Shape> ShapeItem<S> createShapeItem(S s) {
        return new ShapeItem<S>(s);
    }

    public static <S extends Shape> ShapeItem<S> createTextItem(S s, String string) {
        return MGraphics.createTextItem(s, string, null, null);
    }

    public static <S extends Shape> ShapeItem<S> createTextItem(S s, String string, Color color) {
        return MGraphics.createTextItem(s, string, color, null);
    }

    public static <S extends Shape> ShapeItem<S> createTextItem(S s, String string, Color color, Font font) {
        ShapeItem<S> shapeItem = new ShapeItem<S>(s);
        shapeItem.setText(string);
        shapeItem.setTextColor(color);
        shapeItem.setTextFont(font);
        return shapeItem;
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public void removeItem(Item item) {
        this.items.remove(item);
    }

    public void fillBackground(Graphics2D graphics2D, Color color) {
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.onPaint(graphics2D);
        for (Item item : this.items) {
            if (!item.isVisible()) continue;
            item.draw(this, graphics2D);
        }
    }

    protected void onPaint(Graphics2D graphics2D) {
    }

    public static class ShapeItem<S extends Shape>
    extends Item {
        private boolean filled;
        private Color shapeColor;
        private Color textColor;
        private Font textFont;
        private Painter painter;
        private S shape;
        private String text;

        public ShapeItem(S s) {
            this.shape = s;
        }

        @Override
        public void draw(MGraphics mGraphics, Graphics2D graphics2D) {
            this.drawBackground(mGraphics, graphics2D);
            this.drawText(mGraphics, graphics2D);
        }

        public Painter getPainter() {
            return this.painter;
        }

        public void setPainter(Painter painter) {
            this.painter = painter;
        }

        public S getShape() {
            return this.shape;
        }

        public void setShape(S s) {
            this.shape = s;
        }

        public Color getShapeColor() {
            return this.shapeColor;
        }

        public void setShapeColor(Color color) {
            this.shapeColor = color;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public Color getTextColor() {
            return this.textColor;
        }

        public void setTextColor(Color color) {
            this.textColor = color;
        }

        public Font getTextFont() {
            return this.textFont;
        }

        public void setTextFont(Font font) {
            this.textFont = font;
        }

        public boolean isFilled() {
            return this.filled;
        }

        public void setFilled(boolean bl) {
            this.filled = bl;
        }

        protected void drawBackground(MGraphics mGraphics, Graphics2D graphics2D) {
            if (this.shape != null) {
                if (this.painter != null) {
                    Rectangle rectangle = this.shape.getBounds();
                    this.painter.paint(mGraphics, graphics2D, this.location.x, this.location.y, rectangle.width, rectangle.height);
                } else if (this.shapeColor != null) {
                    graphics2D.translate(this.location.x, this.location.y);
                    graphics2D.setColor(this.shapeColor);
                    if (this.filled) {
                        graphics2D.fill((Shape)this.shape);
                    } else {
                        graphics2D.draw((Shape)this.shape);
                    }
                    graphics2D.translate(-this.location.x, -this.location.y);
                }
            } else if (this.painter != null) {
                this.painter.paint(mGraphics, graphics2D, this.location.x, this.location.y, mGraphics.getWidth(), mGraphics.getHeight());
            }
        }

        protected void drawText(MGraphics mGraphics, Graphics2D graphics2D) {
            if (this.text != null) {
                Cloneable cloneable;
                int n;
                int n2;
                if (this.textFont != null) {
                    graphics2D.setFont(this.textFont);
                }
                if (this.textColor != null) {
                    graphics2D.setColor(this.textColor);
                }
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n3 = fontMetrics.stringWidth(this.text);
                int n4 = fontMetrics.getHeight();
                if (this.shape == null) {
                    n2 = mGraphics.getWidth();
                    n = mGraphics.getHeight();
                } else if (this.shape instanceof Rectangle) {
                    cloneable = (Rectangle)this.shape;
                    n2 = cloneable.width;
                    n = cloneable.height;
                } else {
                    cloneable = this.shape.getBounds();
                    n2 = cloneable.width;
                    n = cloneable.height;
                }
                cloneable = new RenderingHints(null);
                UI.setTextAntialiasing(graphics2D, (RenderingHints)cloneable);
                graphics2D.drawString(this.text, this.location.x + n2 / 2 - n3 / 2, this.location.y + n / 2 - n4 / 2 + fontMetrics.getAscent());
                graphics2D.addRenderingHints((Map<?, ?>)((Object)cloneable));
            }
        }
    }

    public static abstract class Item
    implements Serializable {
        private boolean visible = true;
        protected final Point location = new Point();

        public abstract void draw(MGraphics var1, Graphics2D var2);

        public int getX() {
            return this.location.x;
        }

        public int getY() {
            return this.location.y;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public void setLocation(int n, int n2) {
            this.location.setLocation(n, n2);
        }
    }

    public static class ImageItem
    extends ShapeItem<Rectangle> {
        private Image image;

        public ImageItem(Image image) {
            super(null);
            this.setImage(image);
        }

        @Override
        public void draw(MGraphics mGraphics, Graphics2D graphics2D) {
            this.drawBackground(mGraphics, graphics2D);
            if (this.image != null) {
                graphics2D.drawImage(this.image, this.location.x, this.location.y, null);
            }
            this.drawText(mGraphics, graphics2D);
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
            this.setShape(this.image == null ? null : new Rectangle(0, 0, this.image.getWidth(null), this.image.getHeight(null)));
        }
    }

    public static class IconItem
    extends ShapeItem<Rectangle>
    implements MIcon.Name {
        private Icon icon;

        public IconItem(Icon icon) {
            super(null);
            this.setIcon(icon);
        }

        public IconItem(String string) {
            this(MIcon.stock(string));
        }

        @Override
        public void draw(MGraphics mGraphics, Graphics2D graphics2D) {
            this.drawBackground(mGraphics, graphics2D);
            if (this.icon != null) {
                this.icon.paintIcon(mGraphics, graphics2D, this.location.x, this.location.y);
            }
            this.drawText(mGraphics, graphics2D);
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
            this.setShape(this.icon == null ? null : new Rectangle(0, 0, this.icon.getIconWidth(), this.icon.getIconHeight()));
        }

        @Override
        public String getIconName() {
            return MIcon.getName(this.getIcon());
        }

        @Override
        public void setIconName(String string) {
            this.setIcon(MIcon.stock(string));
        }
    }
}

