/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.it.I;
import org.makagiga.commons.style.StyleSupport;

public class MLabel
extends JLabel
implements MIcon.Name,
StyleSupport {
    private boolean strikeThrough;
    private boolean textAntialiasing;
    private MouseListener localBuddyMouseListener;
    private static StaticHandler staticHandler = new StaticHandler();

    public MLabel() {
        this(null, (Icon)null);
    }

    public MLabel(Icon icon) {
        this(null, icon);
    }

    public MLabel(Image image) {
        this(null, image == null ? null : new MIcon(image));
    }

    @ConstructorProperties(value={"text"})
    public MLabel(String string) {
        this(string, (Icon)null);
    }

    public MLabel(String string, Icon icon) {
        this.setIcon(icon);
        this.setText(string);
    }

    @ConstructorProperties(value={"text", "iconName"})
    public MLabel(String string, String string2) {
        this(string, MIcon.stock(string2));
    }

    public static MLabel createFor(Component component, String string) {
        return MLabel.createFor(component, string, 10);
    }

    public static MLabel createFor(Component component, String string, int n) {
        MLabel mLabel = new MLabel(string);
        mLabel.setHorizontalAlignment(n);
        mLabel.setLabelFor(component);
        return mLabel;
    }

    @Deprecated
    public static MLabel createSmall() {
        return MLabel.createSmall(null, null);
    }

    public static MLabel createSmall(String string, Icon icon) {
        MLabel mLabel = new MLabel(string, icon);
        UI.changeFontSize(mLabel, -1);
        return mLabel;
    }

    public static JLabel getLabel(JComponent jComponent) {
        return UI.getClientProperty(jComponent, "labeledBy", null);
    }

    @Deprecated
    public static MLabel html(String string) {
        MLabel mLabel = new MLabel();
        mLabel.setHTML(string);
        return mLabel;
    }

    public boolean isStrikeThrough() {
        return this.strikeThrough;
    }

    public void setStrikeThrough(boolean bl) {
        if (bl != this.strikeThrough) {
            this.strikeThrough = bl;
            this.repaint();
        }
    }

    public boolean isTextAntialiasing() {
        return this.textAntialiasing;
    }

    public void setTextAntialiasing(boolean bl) {
        if (bl != this.textAntialiasing) {
            this.textAntialiasing = bl;
            this.repaint();
        }
    }

    public void makeLargeMessage() {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(0);
        this.setVerticalAlignment(0);
        this.setVerticalTextPosition(3);
        this.setIconTextGap(10);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        String string;
        if (this.textAntialiasing) {
            UI.setTextAntialiasing((Graphics2D)graphics, null);
        }
        super.paintComponent(graphics);
        if (this.strikeThrough && !TK.isEmpty(string = this.getText())) {
            int n = this.getWidth();
            graphics.setColor(MColor.deriveAlpha(MColor.RED, 127));
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            int n2 = fontMetrics.stringWidth(string);
            int n3 = this.getHorizontalAlignment() == 0 ? n / 2 - n2 / 2 + 5 : 5;
            Icon icon = this.getIcon();
            if (icon != null) {
                n3 += icon.getIconWidth() + this.getIconTextGap();
            }
            int n4 = Math.min(n - 5, n2 + n3 - 5);
            int n5 = this.getHeight() / 2;
            graphics.drawLine(n3, n5, n4, n5);
        }
    }

    public void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    public void setHTML(String string) {
        if (string == null) {
            this.setText(null);
        } else {
            this.setText(UI.makeHTML(string));
        }
    }

    @Deprecated
    public void setHTML(String string, Object ... objectArray) {
        this.setText(UI.makeHTML(String.format(string, objectArray)));
    }

    public void setImage(Image image) {
        this.setIcon(image == null ? null : new MIcon(image));
    }

    @Override
    public void setLabelFor(Component component) {
        super.setLabelFor(component);
        if (component == null) {
            if (this.localBuddyMouseListener != null) {
                this.removeMouseListener(this.localBuddyMouseListener);
                this.localBuddyMouseListener = null;
            }
        } else if (this.localBuddyMouseListener == null) {
            this.localBuddyMouseListener = staticHandler;
            this.addMouseListener(this.localBuddyMouseListener);
        }
    }

    public void setMultilineText(String string) {
        if (string != null && string.contains("\n")) {
            HTMLBuilder hTMLBuilder = new HTMLBuilder();
            hTMLBuilder.beginHTML();
            hTMLBuilder.beginDoc();
            for (I<String> i : I.of(string.split("\n"))) {
                hTMLBuilder.emit(HTMLBuilder.escape(i.toString()));
                if (i.isLast()) continue;
                hTMLBuilder.emit("<br>");
            }
            hTMLBuilder.endDoc();
            this.setText(hTMLBuilder.toString());
        } else {
            this.setText(string);
        }
    }

    public void setNumber(Number number) {
        this.setText(number.toString());
    }

    @Deprecated
    public void setText(String string, Object ... objectArray) {
        this.setText(String.format(string, objectArray));
    }

    @Override
    public void updateUI() {
        if (UI.isSubstance()) {
            this.putClientProperty("substancelaf.useThemedDefaultIcons", false);
        }
        super.updateUI();
    }

    @Override
    public String getIconName() {
        return MIcon.getName(this.getIcon());
    }

    @Override
    public void setIconName(String string) {
        this.setIcon(MIcon.stock(string));
    }

    @Override
    public void setStyle(String string) {
        UI.setStyle(string, this);
    }

    private static final class StaticHandler
    extends MMouseAdapter
    implements Serializable {
        private StaticHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (StaticHandler.isLeft(mouseEvent)) {
                MLabel mLabel = (MLabel)mouseEvent.getSource();
                Component component = mLabel.getLabelFor();
                if (!mLabel.isEnabled()) {
                    return;
                }
                if (component != null) {
                    UI.requestFocus(component);
                    mouseEvent.consume();
                }
            }
        }
    }
}

