/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Window;
import java.net.PasswordAuthentication;
import javax.swing.AbstractButton;
import org.makagiga.commons.Config;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MPasswordField;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.Net;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.form.Default;
import org.makagiga.form.Factory;
import org.makagiga.form.Field;
import org.makagiga.form.Form;
import org.makagiga.form.FormPanel;
import org.makagiga.form.Info;

public class MLoginPanel
extends FormPanel<PasswordForm> {
    @Deprecated
    protected Factory.Content content = this.getContent();
    @Deprecated
    protected PasswordForm form = (PasswordForm)this.getForm();

    public MLoginPanel(String string, String string2) {
        super(new PasswordForm(string, string2));
        if (TK.isEmpty(((PasswordForm)this.getForm()).prompt)) {
            this.setVisible("prompt", false);
        }
        if (TK.isEmpty(((PasswordForm)this.getForm()).url)) {
            this.setVisible("url", false);
        }
        this.setLabel("password", UI._("Password:"));
        this.setLabel("url", UI._("Address:"));
        this.setLabel("user", UI._("User Name:"));
        MTextField mTextField = (MTextField)this.getWrappedComponent("url");
        mTextField.setCaretPosition(0);
        if (Net.isSecureHttp(((PasswordForm)this.getForm()).url)) {
            mTextField.setStyle("background-color: #F5F6BE; color: black");
        } else {
            mTextField.setStyle("background-color: white; color: black");
        }
    }

    @Override
    public final Object dispose(Object ... objectArray) {
        this.content = null;
        return super.dispose(objectArray);
    }

    public static PasswordAuthentication getPasswordAuthentication(Window window, String string) {
        return MLoginPanel.getPasswordAuthentication(window, string, null);
    }

    public static PasswordAuthentication getPasswordAuthentication(Window window, String string, String string2) {
        MLoginPanel mLoginPanel = new MLoginPanel(string, string2);
        MPasswordField mPasswordField = (MPasswordField)mLoginPanel.getWrappedComponent("password");
        MDialog mDialog = mLoginPanel.createDialog(window, UI._("Enter Password and User Name") + " - " + MApplication.getFullName(), "ui/password");
        mDialog.changeButton((AbstractButton)mDialog.getOKButton(), MActionInfo.LOGIN);
        if (mDialog.exec()) {
            PasswordForm passwordForm = (PasswordForm)mLoginPanel.getForm();
            Config config = Config.getDefault();
            config.write("User.name", passwordForm.user);
            config.sync();
            if (passwordForm.password == null) {
                passwordForm.password = TK.EMPTY_CHAR_ARRAY;
            }
            PasswordAuthentication passwordAuthentication = new PasswordAuthentication(passwordForm.user, passwordForm.password);
            mPasswordField.clear();
            return passwordAuthentication;
        }
        mPasswordField.clear();
        return null;
    }

    @Form(pack=480)
    protected static final class PasswordForm {
        @Info(type=0)
        protected String prompt;
        @Field(readOnly=true)
        protected String url;
        @Default
        @Field(autoCompletion="user", required=true)
        protected String user;
        @Field
        protected char[] password;

        protected PasswordForm(String string, String string2) {
            this.prompt = string;
            this.url = string2;
            this.user = Config.getDefault().read("User.name", null);
            if (this.user == null) {
                this.user = OS.getUserName();
            }
        }
    }
}

