/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.ContainerIterator;
import org.makagiga.commons.FS;
import org.makagiga.commons.LogFile;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MEditorPane;
import org.makagiga.commons.MFormat;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MPasswordPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.MTextLabel;
import org.makagiga.commons.MTip;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.OS;
import org.makagiga.commons.PassiveException;
import org.makagiga.commons.Property;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.Watermark;
import org.makagiga.commons.preview.PreviewPanel;
import org.makagiga.commons.validator.NotEmptyValidator;

public class MMessage<V extends JComponent>
extends MDialog {
    private WeakReference<V> viewRef;

    public MMessage(Window window, String string, String string2, Icon icon, V v, int n) {
        super(window, string2, icon, n);
        this.init(string, v);
    }

    public MMessage(Window window, String string, String string2, String string3, V v, int n) {
        super(window, string2, string3, n);
        this.init(string, v);
    }

    public static boolean confirm(Window window, String string) {
        return MMessage.customConfirm(window, MIcon.stock("ui/question"), null, null, string);
    }

    public static boolean confirmDelete(Window window, String string) {
        return MMessage.confirmDelete(window, string, null);
    }

    public static boolean confirmDelete(Window window, String string, Object object) {
        return MMessage.customConfirm(window, MIcon.stock("ui/delete"), MActionInfo.DELETE, null, UI.makeHTML(string + MMessage.makeInfo(object)));
    }

    public static boolean confirmFileOverwrite(Window window, String string, File file, File file2) {
        TK.checkNull(file, "oldFile");
        String string2 = string != null ? UI._("Existing File ({0})", string) : UI._("Existing File");
        FileInfoPanel fileInfoPanel = new FileInfoPanel(file, string2);
        FileInfoPanel fileInfoPanel2 = file2 != null ? new FileInfoPanel(file2, UI._("New File")) : null;
        MDialog mDialog = new MDialog(window, UI._("Confirm"), MIcon.stock("ui/question"), 7);
        mDialog.changeButton((AbstractButton)mDialog.getOKButton(), UI._("Overwrite"));
        mDialog.addNorth(new MLabel(UI._("File already exists. Overwrite?")));
        MPanel mPanel = MPanel.createVBoxPanel();
        mPanel.addGap();
        mPanel.add(fileInfoPanel);
        mPanel.addGap();
        if (fileInfoPanel2 != null) {
            mPanel.add(fileInfoPanel2);
        }
        mDialog.addCenter(mPanel);
        fileInfoPanel.infoPanel.alignLabels();
        fileInfoPanel.startPreview();
        if (fileInfoPanel2 != null) {
            fileInfoPanel2.infoPanel.alignLabels();
            fileInfoPanel2.startPreview();
        }
        mDialog.pack();
        boolean bl = mDialog.exec();
        fileInfoPanel.stopPreview();
        if (fileInfoPanel2 != null) {
            fileInfoPanel2.stopPreview();
        }
        return bl;
    }

    public static boolean confirmFileOverwrite(Window window, String string) {
        return MMessage.customConfirm(window, null, MActionInfo.OVERWRITE, null, UI.makeHTML(UI._("File already exists. Overwrite?") + MMessage.makeInfo(string)));
    }

    public static MMessage<MTextFieldPanel> createInputMessage(Window window, String string, String string2, String string3, String string4, String string5) {
        MTextFieldPanel mTextFieldPanel = new MTextFieldPanel(string);
        mTextFieldPanel.getMenuButton().setVisible(false);
        if (string5 != null) {
            mTextFieldPanel.setAutoCompletion(string5);
        }
        MMessage<MTextFieldPanel> mMessage = new MMessage<MTextFieldPanel>(window, string2, string3, string4, mTextFieldPanel, 7){

            @Override
            protected boolean onAccept() {
                ((MTextFieldPanel)this.getView()).saveAutoCompletion();
                return true;
            }
        };
        mMessage.packFixed(UI.WindowSize.MEDIUM);
        mMessage.getValidatorSupport().add(new NotEmptyValidator(mTextFieldPanel.getTextField()));
        return mMessage;
    }

    public static MList<Object> createListView(Icon icon, Object[] objectArray) {
        Image image;
        final Property<Watermark> property = Property.create();
        Image image2 = image = icon instanceof ImageIcon ? ((ImageIcon)ImageIcon.class.cast(icon)).getImage() : null;
        if (image != null) {
            property.set(new Watermark(image, 64, 5));
        }
        MList<Object> mList = new MList<Object>(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (!property.isNull()) {
                    ((Watermark)property.get()).paint(this, graphics);
                }
            }
        };
        mList.setCellRenderer(MRenderer.getDefaultListCellRenderer());
        mList.setEnabled(false);
        mList.setSingleSelectionMode();
        mList.setToolTipText(UI._("Selected items"));
        for (Object object : objectArray) {
            if (object == null) continue;
            if (object instanceof Icon) {
                mList.addItem(object);
                continue;
            }
            String string = object.toString();
            if (TK.isEmpty(string)) {
                mList.addItem(" ");
                continue;
            }
            mList.addItem(TK.centerSqueeze(string, 128));
        }
        mList.clearSelection();
        return mList;
    }

    public static boolean customConfirm(Window window, Icon icon, MActionInfo mActionInfo, MActionInfo mActionInfo2, String string) {
        return MMessage.customConfirm(window, icon, mActionInfo, mActionInfo2, string, null);
    }

    public static boolean customConfirm(Window window, Icon icon, MActionInfo mActionInfo, MActionInfo mActionInfo2, String string, Object[] objectArray) {
        return MMessage.customConfirm(window, icon, mActionInfo == null ? null : mActionInfo.getIcon(), mActionInfo == null ? null : mActionInfo.getText(), mActionInfo2 == null ? null : mActionInfo2.getIcon(), mActionInfo2 == null ? null : mActionInfo2.getText(), string, objectArray);
    }

    public static char[] enterPassword(Window window, String string) {
        return MMessage.enterPassword(window, string, 0);
    }

    public static char[] enterPassword(Window window, String string, int n) {
        MPasswordPanel mPasswordPanel = new MPasswordPanel(0x10 | n, string);
        MMessage<MPasswordPanel> mMessage = new MMessage<MPasswordPanel>(window, null, UI._("Enter Password") + " - " + MApplication.getFullName(), "ui/password", mPasswordPanel, 7);
        if ((n & 8) == 0) {
            mMessage.getValidatorSupport().add(new NotEmptyValidator(mPasswordPanel.getNewPasswordField()));
        }
        mMessage.setResizable(false);
        char[] cArray = null;
        if (mMessage.exec()) {
            cArray = mPasswordPanel.getPasswordInfo().getNewPassword();
        }
        mPasswordPanel.dispose(new Object[0]);
        return cArray;
    }

    public static void error(Window window, String string) {
        MPanel mPanel = MMessage.createView(string);
        MMessage<MPanel> mMessage = new MMessage<MPanel>(window, null, UI._("Error"), MMessage.getRandomErrorIconName(), mPanel, 36);
        mMessage.setResizable(false);
        mMessage.exec();
    }

    public static void error(Window window, Throwable throwable) {
        MMessage.error(window, throwable, null);
    }

    public static void error(Window window, final Throwable throwable, Object object) {
        String string;
        if (throwable != null) {
            MLogger.exception(throwable);
        }
        if (throwable instanceof PassiveException) {
            MStatusBar.error(MMessage.getThrowablePassiveMessage(throwable, object));
            return;
        }
        String string2 = string = throwable == null ? UI._("Unknown Error") : TK.buildErrorMessage(throwable);
        if (object != null) {
            string = string + "\n\n" + object;
        }
        MPanel mPanel = MMessage.createView(string);
        MMessage<MPanel> mMessage = new MMessage<MPanel>(window, null, UI._("Error"), MMessage.getRandomErrorIconName(), mPanel, 44){

            @Override
            protected void onUserClick() {
                3.errorDetails(this, throwable);
            }
        };
        if (throwable == null) {
            mMessage.getUserButton().setVisible(false);
        } else {
            mMessage.changeButton((AbstractButton)mMessage.getUserButton(), UI._("Details"));
        }
        mMessage.setResizable(false);
        mMessage.exec(mMessage.getOKButton());
    }

    public static void errorDetails(Window window, Throwable throwable) {
        Object[] objectArray;
        if (throwable == null) {
            return;
        }
        final MEditorPane mEditorPane = new MEditorPane();
        MDialog mDialog = new MDialog(window, UI._("Error Details"), "ui/error", 60){

            @Override
            protected void onUserClick() {
                MText.copyAll(mEditorPane);
            }
        };
        mDialog.changeButton((AbstractButton)mDialog.getUserButton(), MActionInfo.COPY);
        MURLButton mURLButton = mDialog.getURLButton();
        if (MApplication.getBugs() == null) {
            mURLButton.setVisible(false);
        } else {
            mURLButton.setText(UI._("Report Bug..."));
            mURLButton.setURL(MApplication.getBugs());
        }
        LogFile logFile = null;
        String string = null;
        if (MLogger.isDeveloper() && !FS.isRestricted()) {
            logFile = MApplication.getLogFile();
            logFile.flush();
            try {
                string = FS.read(logFile.getFile(), "UTF8");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!TK.isEmpty(objectArray = throwable.getStackTrace())) {
            mEditorPane.setEditable(false);
            mEditorPane.setText((FS.isRestricted() ? "" : OS.getSummary(true)) + MMessage.formatThrowable(throwable) + MMessage.formatThrowable(throwable.getCause()) + (string == null ? "" : "\n\n" + logFile.getFile() + ":\n\n" + string));
            mEditorPane.setCaretPosition(0);
            mDialog.addCenter(mEditorPane);
        }
        mDialog.setSize(UI.WindowSize.MEDIUM);
        mDialog.exec(mDialog.getOKButton());
    }

    public static String getSimpleConfirmMessage() {
        return UI._("Are you sure?");
    }

    public V getView() {
        return (V)((JComponent)this.viewRef.get());
    }

    public static void info(Window window, String string) {
        MMessage.infoWithIcon(window, "ui/info", string);
    }

    public static void infoWithIcon(Window window, String string, String string2) {
        MPanel mPanel = MMessage.createView(string2);
        MMessage<MPanel> mMessage = new MMessage<MPanel>(window, null, UI._("Information"), string, mPanel, 36);
        mMessage.setResizable(false);
        mMessage.exec();
    }

    public static String input(Window window, String string, String string2, String string3, String string4, String string5) {
        MMessage<MTextFieldPanel> mMessage = MMessage.createInputMessage(window, string, string2, string3, string4, string5);
        if (mMessage.exec(mMessage.getView())) {
            return mMessage.getView().getText();
        }
        return null;
    }

    public static String input(Window window, String string, String string2, String string3) {
        return MMessage.input(window, string, string2, string3, null, "input");
    }

    public static MPasswordPanel.Info newPassword(Window window, String string, int n) {
        MPasswordPanel mPasswordPanel = new MPasswordPanel(n, string);
        MMessage<MPasswordPanel> mMessage = new MMessage<MPasswordPanel>(window, null, UI._("New Password"), "ui/password", mPasswordPanel, 7);
        if ((n & 0x20) != 0) {
            mMessage.changeButton((AbstractButton)mMessage.getOKButton(), UI._("Encrypt"), "ui/password");
        }
        mPasswordPanel.installValidators(mMessage.getValidatorSupport());
        mMessage.installValidatorMessage();
        mMessage.packFixed(UI.WindowSize.MEDIUM);
        boolean bl = mMessage.exec();
        mPasswordPanel.uninstallValidators(mMessage.getValidatorSupport());
        MPasswordPanel.Info info = bl ? mPasswordPanel.getPasswordInfo() : null;
        mPasswordPanel.dispose(new Object[0]);
        return info;
    }

    public static boolean simpleConfirm(Window window) {
        return MMessage.simpleConfirm(window, MActionInfo.OK, null);
    }

    public static boolean simpleConfirm(Window window, MActionInfo mActionInfo) {
        return MMessage.simpleConfirm(window, mActionInfo, null);
    }

    public static boolean simpleConfirm(Window window, MActionInfo mActionInfo, Object[] objectArray) {
        return MMessage.customConfirm(window, mActionInfo.getIcon(), mActionInfo, null, MMessage.getSimpleConfirmMessage(), objectArray);
    }

    public static String text(Window window, String string, String string2) {
        return MMessage.text(window, string, string2, true);
    }

    public static String text(Window window, String string, String string2, boolean bl) {
        int n = 64;
        MDialog mDialog = new MDialog(window, string2, n |= bl ? 7 : 36);
        MEditorPane mEditorPane = MEditorPane.newPlainText(string, bl);
        mDialog.getMainPanel().setMargin(0);
        mDialog.addCenter(mEditorPane);
        MText.updateActions(mEditorPane);
        MToolBar mToolBar = new MToolBar();
        mToolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        MText.updateToolBar(mEditorPane, mToolBar);
        mToolBar.readConfig("message-text-editor");
        mDialog.setToolBar(mToolBar);
        mDialog.setSize(UI.WindowSize.MEDIUM);
        return mDialog.exec(mEditorPane) ? mEditorPane.getText() : null;
    }

    public static void warning(Window window, String string) {
        MMessage<MPanel> mMessage = new MMessage<MPanel>(window, null, UI._("Warning"), "ui/warning", MMessage.createView(string), 36);
        mMessage.setResizable(false);
        mMessage.exec();
    }

    private static MPanel createView(String string) {
        int n;
        int n2 = n = string == null ? -1 : string.indexOf(10);
        if (n != -1 && string.startsWith("<html>")) {
            string = string.replace("\n", "<br>");
        }
        final JOptionPane jOptionPane = new JOptionPane(string, -1, -1);
        final MAction mAction = new MAction(MActionInfo.COPY){

            @Override
            public void onAction() {
                Object object = jOptionPane.getMessage();
                if (object != null) {
                    try {
                        MClipboard.setString(object.toString());
                    }
                    catch (ClipboardException clipboardException) {
                        MMessage.error(null, clipboardException);
                    }
                }
            }
        };
        mAction.connect((JComponent)jOptionPane, 2);
        jOptionPane.addMouseListener(new MMouseAdapter(){

            @Override
            public void popupTrigger(MouseEvent mouseEvent) {
                MMenu mMenu = new MMenu();
                mMenu.add(mAction);
                mMenu.showPopup(mouseEvent);
            }
        });
        for (JButton jComponent2 : ContainerIterator.findAll(jOptionPane, JButton.class)) {
            MComponent.removeFromParent(jComponent2, false);
        }
        MPanel mPanel = MPanel.createBorderPanel(5);
        mPanel.addCenter(jOptionPane);
        MTip mTip = new MTip(MMessage.class.getName(), "message");
        mTip.showNextTip(MTip.Visible.SELDOM);
        mPanel.addSouth(mTip);
        return mPanel;
    }

    private static boolean customConfirm(Window window, Icon icon, Icon icon2, String string, Icon icon3, String string2, String string3, Object[] objectArray) {
        boolean bl = false;
        boolean bl2 = false;
        MPanel mPanel = MPanel.createBorderPanel(5);
        mPanel.addNorth(MMessage.createView(string3));
        if (!TK.isEmpty(objectArray) && objectArray.length < 1000) {
            mPanel.addCenter(MMessage.createListView(icon, objectArray));
            bl = true;
            bl2 = true;
        }
        MMessage<MPanel> mMessage = new MMessage<MPanel>(window, null, UI._("Confirm"), bl ? null : icon, mPanel, 7);
        MButton mButton = mMessage.getCancelButton();
        if (((Boolean)UI.buttonIcons.get()).booleanValue() && icon3 != null) {
            mButton.setIcon(icon3);
        }
        if (string2 != null) {
            mButton.setText(string2);
        }
        mButton = mMessage.getOKButton();
        if (((Boolean)UI.buttonIcons.get()).booleanValue() && icon2 != null) {
            mButton.setIcon(icon2);
        }
        if (string != null) {
            mButton.setText(string);
        }
        if (icon3 != null || string2 != null || icon2 != null || string != null) {
            mMessage.pack();
        }
        mMessage.setResizable(bl2);
        return mMessage.exec();
    }

    private static String formatThrowable(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        Object[] objectArray = throwable.getStackTrace();
        if (TK.isEmpty(objectArray)) {
            return "\n\n" + throwable;
        }
        return "\n\n" + throwable + "\n\n" + TK.toString(objectArray, "\n");
    }

    private static String getThrowablePassiveMessage(Throwable throwable, Object object) {
        if (throwable == null) {
            return UI._("Unknown Error");
        }
        String string = throwable.getLocalizedMessage();
        if (string == null) {
            Throwable throwable2 = throwable.getCause();
            String string2 = string = throwable2 == null ? UI._("Unknown Error") : throwable2.getLocalizedMessage();
        }
        if (object != null) {
            string = string + " - " + object;
        }
        return string.replace('\n', ' ');
    }

    private void init(String string, V v) {
        this.viewRef = new WeakReference<V>(v);
        MPanel mPanel = MPanel.createVBoxPanel();
        MLabel mLabel = null;
        if (string != null) {
            mLabel = new MLabel(string);
            mPanel.add(mLabel);
            mPanel.addGap();
        }
        if (v != null) {
            mPanel.add((JComponent)v);
            if (mLabel != null) {
                mLabel.setLabelFor((Component)MPanel.getWrappedView(v));
            }
        }
        this.addCenter(mPanel);
        this.pack();
    }

    private static String makeInfo(Object object) {
        return object == null ? "" : "<br><br><b>" + TK.escapeXML(object.toString()) + "</b>";
    }

    static String getRandomErrorIconName() {
        String[] stringArray = new String[]{"ui/error", "labels/emotion/angry", "labels/emotion/cry", "labels/emotion/sad"};
        return stringArray[new Random().nextInt(stringArray.length)];
    }

    private static final class FileInfoPanel
    extends MPanel {
        private final File file;
        private final MPanel infoPanel;
        private final PreviewPanel preview;

        private FileInfoPanel(File file, String string) {
            super(10, 0);
            this.file = file;
            this.preview = new PreviewPanel(150);
            this.preview.setMaximumHeight(150);
            this.setTitle(string);
            this.infoPanel = MPanel.createVBoxPanel();
            this.addInfo(UI._("Name:"), file.getPath());
            this.addInfo(UI._("Modified:"), new MDate(file.lastModified()).fancyFormat(1, true));
            this.addInfo(UI._("Size:"), MFormat.toAutoSize(file.length()) + " (" + file.length() + ")");
            this.infoPanel.addStretch();
            this.addEast(this.preview);
            this.addCenter(this.infoPanel);
        }

        private void addInfo(String string, String string2) {
            MTextLabel mTextLabel = new MTextLabel(string2);
            MPanel.Wrapper wrapper = (MPanel.Wrapper)MPanel.createHLabelPanel(mTextLabel, string);
            wrapper.getLabel().setStyle("font-weight: bold");
            this.infoPanel.add(wrapper);
        }

        private void startPreview() {
            this.preview.update(this.file);
        }

        private void stopPreview() {
            this.preview.cancel(true);
        }
    }
}

