/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTable;
import org.makagiga.commons.MTree;
import org.makagiga.commons.MTreeItem;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.style.StyleSupport;

public class MRenderer<T>
implements ListCellRenderer,
StyleSupport,
TableCellRenderer,
TreeCellRenderer {
    private transient boolean expanded;
    private transient boolean focused;
    private boolean htmlEnabled = true;
    private transient boolean leaf;
    private transient boolean selected;
    private boolean useAlternateRowColor = true;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private Border _paddingBorder;
    private transient int column;
    private int padding = -1;
    private transient int row;
    private JComponent view;
    private transient JList list;
    private transient JTable table;
    private transient JTree tree;
    private transient TreePath mouseHover;
    static MRenderer<?> _instance;

    public MRenderer() {
        this.initView();
    }

    public MRenderer(int n) {
        this.padding = n;
        this.initView();
    }

    public MRenderer(int n, JComponent jComponent) {
        this.padding = n;
        this.view = jComponent;
    }

    public MRenderer(JComponent jComponent) {
        this.view = jComponent;
    }

    public Font getFont() {
        if (this.view != null) {
            return this.view.getFont();
        }
        throw new UnsupportedOperationException();
    }

    public void setFont(Font font) {
        if (this.view == null) {
            throw new UnsupportedOperationException();
        }
        this.view.setFont(font);
    }

    public MLabel getLabel() {
        return (MLabel)this.view;
    }

    public static Color getRowColor(int n, Color color) {
        if (n % 2 != 0) {
            return UI.getDarker(color, Color.WHITE);
        }
        return color;
    }

    public static ListCellRenderer getDefaultListCellRenderer() {
        if (UI.isSubstance()) {
            Object object = UIManager.get("List.cellRenderer");
            return object instanceof ListCellRenderer ? (ListCellRenderer)object : MRenderer.getSharedInstance();
        }
        return MRenderer.getSharedInstance();
    }

    public static synchronized MRenderer<?> getSharedInstance() {
        if (_instance == null) {
            _instance = new MRenderer<Object>(){
                private Icon folderIcon = MIcon.small("ui/folder");
                private Icon leafIcon = MIcon.small("ui/file");

                @Override
                protected void onRender(Object object) {
                    MLabel mLabel = this.getLabel();
                    if (object instanceof Icon) {
                        mLabel.setIcon((Icon)object);
                        mLabel.setText("");
                    } else {
                        if (this.getTree() != null) {
                            mLabel.setIcon(this.isLeaf() ? this.leafIcon : this.folderIcon);
                        } else {
                            mLabel.setIcon(null);
                        }
                        mLabel.setText(object == null ? "" : object.toString());
                    }
                }
            };
        }
        return _instance;
    }

    public String getToolTipText() {
        if (this.view != null) {
            return this.view.getToolTipText();
        }
        throw new UnsupportedOperationException();
    }

    public void setToolTipText(String string) {
        if (this.view == null) {
            throw new UnsupportedOperationException();
        }
        this.view.setToolTipText(string);
    }

    public boolean getUseAlternateRowColor() {
        return this.useAlternateRowColor;
    }

    public void setUseAlternateRowColor(boolean bl) {
        this.useAlternateRowColor = bl;
    }

    public JComponent getView() {
        return this.view;
    }

    public void setIcon(Icon icon) {
        if (!(this.view instanceof JLabel)) {
            throw new UnsupportedOperationException();
        }
        ((JLabel)JLabel.class.cast(this.view)).setIcon(icon);
    }

    public boolean isHTMLEnabled() {
        return this.htmlEnabled;
    }

    public void setHTMLEnabled(boolean bl) {
        this.htmlEnabled = bl;
        if (this.view != null) {
            UI.setHTMLEnabled(this.view, bl);
        }
    }

    public void setMouseHover(MTree<?, ?> mTree, TreePath treePath) {
        if (treePath == null) {
            if (this.mouseHover != null) {
                mTree.repaint(this.mouseHover);
                this.mouseHover = null;
            }
        } else if (treePath != this.mouseHover) {
            if (this.mouseHover != null) {
                mTree.repaint(this.mouseHover);
            }
            this.mouseHover = treePath;
            mTree.repaint(this.mouseHover);
        }
    }

    public void setText(String string) {
        if (!(this.view instanceof JLabel)) {
            throw new UnsupportedOperationException();
        }
        ((JLabel)JLabel.class.cast(this.view)).setText(string);
    }

    public static void setupTable(JTable jTable, JComponent jComponent, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            Color color = jTable.getSelectionBackground();
            Color color2 = jTable.getSelectionForeground();
            jComponent.setBackground(color);
            if (jComponent instanceof JLabel) {
                jComponent.setForeground(color2);
            }
        } else {
            Color color;
            boolean bl3 = jTable.isPaintingForPrint();
            if (bl3) {
                color = Color.WHITE;
            } else if (UI.getLookAndFeelType().hasAlternateTableRowColor()) {
                color = jTable.getBackground();
                jComponent.setOpaque(false);
            } else {
                color = MRenderer.getRowColor(n, jTable.getBackground());
                if (UI.isNimbus()) {
                    color = UI.getColor(color, 0.98f, MColor.WHITE);
                }
            }
            if (!bl3 && MTable.isSortByColumn(jTable, n2)) {
                color = UI.getColor(color, 0.96f, MColor.WHITE);
            }
            jComponent.setBackground(color);
            if (jComponent instanceof JLabel) {
                jComponent.setForeground(jTable.getForeground());
            }
        }
        if (bl2) {
            jComponent.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            jComponent.setBorder(EMPTY_BORDER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        try {
            this.list = jList;
            this.row = n;
            this.selected = bl;
            this.focused = bl2;
            this.setup(jList, object);
        }
        finally {
            this.list = null;
        }
        return this.view;
    }

    @Override
    public void setStyle(String string) {
        if (this.view == null) {
            throw new UnsupportedOperationException();
        }
        UI.setStyle(string, this.view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        try {
            this.table = jTable;
            this.selected = bl;
            this.focused = bl2;
            this.row = n;
            this.column = n2;
            this.setup(jTable, object);
        }
        finally {
            this.table = null;
        }
        return this.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        try {
            this.tree = jTree;
            this.selected = bl;
            this.expanded = bl2;
            this.leaf = bl3;
            this.row = n;
            this.focused = bl4;
            this.setup(jTree, object);
            this.getView().invalidate();
        }
        finally {
            this.tree = null;
        }
        return this.view;
    }

    protected JComponent createView() {
        return new OptimizedLabel();
    }

    protected int getColumn() {
        return this.column;
    }

    protected JList getList() {
        return this.list;
    }

    protected int getIndex() {
        return this.row;
    }

    protected int getModelRow() {
        return this.table.convertRowIndexToModel(this.row);
    }

    protected int getRow() {
        return this.row;
    }

    protected Color getRowColor(T t) {
        return null;
    }

    protected JTable getTable() {
        return this.table;
    }

    protected JTree getTree() {
        return this.tree;
    }

    protected void initView() {
        this.view = this.createView();
        this.view.setIgnoreRepaint(true);
    }

    protected boolean isExpanded() {
        return this.expanded;
    }

    protected boolean isFocused() {
        return this.focused;
    }

    protected boolean isLeaf() {
        return this.leaf;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected void onRender(T t) {
        if (t instanceof Renderable) {
            ((Renderable)Renderable.class.cast(t)).setupRenderer(this);
        }
    }

    protected void setup(JComponent jComponent, T t) {
        this.view.setComponentOrientation(jComponent.getComponentOrientation());
        this.view.setEnabled(jComponent.isEnabled());
        this.view.setFont(jComponent.getFont());
        this.view.setOpaque(true);
        if (this.table != null) {
            MRenderer.setupTable(this.table, this.view, this.selected, this.focused, this.row, this.column);
            if (t != null) {
                this.onRender(t);
            } else {
                this.handleNullValue();
            }
            return;
        }
        if (this.list != null) {
            if (this.selected) {
                this.view.setBackground(this.list.getSelectionBackground());
                this.view.setForeground(this.list.getSelectionForeground());
            } else {
                Color color;
                if (this.list.isPaintingForPrint()) {
                    color = Color.WHITE;
                } else {
                    if (UI.getLookAndFeelType().hasAlternateListRowColor()) {
                        color = this.list.getBackground();
                        this.view.setOpaque(false);
                    } else {
                        color = this.useAlternateRowColor ? MRenderer.getRowColor(this.row, this.list.getBackground()) : this.list.getBackground();
                    }
                    if (UI.isNimbus()) {
                        color = new Color(color.getRGB());
                    }
                }
                this.view.setBackground(color);
                this.view.setForeground(this.list.getForeground());
            }
        } else if (this.tree != null) {
            Color color;
            Color color2;
            Color color3;
            Color color4 = color3 = t == null ? null : this.getRowColor(t);
            if (this.tree instanceof MTree && ((MTree)MTree.class.cast(this.tree)).isDropZone(this.getRow())) {
                if (color3 == null) {
                    color3 = UI.getColor("Tree.selectionBackground");
                }
                if (Color.WHITE.equals(color3 = UI.getBrighter(color3, 50, Color.WHITE))) {
                    color3 = MColor.getDarker(color3);
                }
                color2 = color3;
                color = UI.getXorColor(color3);
            } else if (this.isSelected()) {
                color2 = UI.getColor("Tree.selectionBackground");
                color = UI.getColor("Tree.selectionForeground");
            } else {
                color2 = color3;
                if (t instanceof MTreeItem && ((MTreeItem)MTreeItem.class.cast(t)).getTreePath().equals(this.mouseHover)) {
                    Color color5 = this.tree.getBackground();
                    if (color5 == null) {
                        color5 = Color.WHITE;
                    }
                    color = MColor.getLinkForeground(color5);
                } else {
                    color = UI.getXorColor(color2 == null ? this.tree.getBackground() : color2);
                }
                this.view.setOpaque(false);
            }
            this.view.setBackground(color2);
            this.view.setForeground(color);
        }
        this.setupBorder();
        if (t != null) {
            this.onRender(t);
        } else {
            this.handleNullValue();
        }
    }

    protected void setupBorder() {
        if (this.list != null || this.tree != null) {
            Border border = null;
            if (this.focused) {
                if (this.selected) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = UIManager.getBorder("List.cellNoFocusBorder");
                if (border == null) {
                    border = EMPTY_BORDER;
                }
            }
            this.view.setBorder(BorderFactory.createCompoundBorder(border != null ? new FixedBorder(border) : null, this.getPaddingBorder()));
        }
    }

    private Border getPaddingBorder() {
        if (this._paddingBorder == null) {
            this._paddingBorder = this.padding == -1 ? null : UI.createEmptyBorder(this.padding);
        }
        return this._paddingBorder;
    }

    private void handleNullValue() {
        if (this.view instanceof JLabel) {
            JLabel jLabel = (JLabel)this.view;
            jLabel.setIcon(null);
            jLabel.setText("");
        }
    }

    private static final class FixedBorder
    implements Border {
        private final Border impl;

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = this.impl.getBorderInsets(component);
            return insets == null ? UI.createInsets(0) : insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return this.impl.isBorderOpaque();
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.impl.paintBorder(component, graphics, n, n2, n3, n4);
        }

        private FixedBorder(Border border) {
            this.impl = border;
        }
    }

    public static interface Renderable {
        public void setupRenderer(MRenderer<?> var1);
    }

    public static class OptimizedPanel
    extends MPanel
    implements Optimized {
        public OptimizedPanel() {
        }

        public OptimizedPanel(boolean bl) {
            super(bl);
        }

        public OptimizedPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        @Override
        public void invalidate() {
            if (this.getLayout() instanceof GroupLayout) {
                super.invalidate();
            }
        }

        @Override
        public void repaint() {
        }

        @Override
        public void repaint(Rectangle rectangle) {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void validate() {
            if (this.getLayout() instanceof GroupLayout) {
                super.validate();
            }
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }

        @Override
        public void firePropertyChange(String string, byte by, byte by2) {
        }

        @Override
        public void firePropertyChange(String string, char c, char c2) {
        }

        @Override
        public void firePropertyChange(String string, double d, double d2) {
        }

        @Override
        public void firePropertyChange(String string, float f, float f2) {
        }

        @Override
        public void firePropertyChange(String string, int n, int n2) {
        }

        @Override
        public void firePropertyChange(String string, long l, long l2) {
        }

        @Override
        public void firePropertyChange(String string, short s, short s2) {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        @Override
        protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        }
    }

    public static class OptimizedLabel
    extends MLabel
    implements Optimized {
        @Override
        public void invalidate() {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void repaint(Rectangle rectangle) {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }

        @Override
        public void firePropertyChange(String string, byte by, byte by2) {
        }

        @Override
        public void firePropertyChange(String string, char c, char c2) {
        }

        @Override
        public void firePropertyChange(String string, double d, double d2) {
        }

        @Override
        public void firePropertyChange(String string, float f, float f2) {
        }

        @Override
        public void firePropertyChange(String string, int n, int n2) {
        }

        @Override
        public void firePropertyChange(String string, long l, long l2) {
        }

        @Override
        public void firePropertyChange(String string, short s, short s2) {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
            if ("text".equals(string) || ("font".equals(string) || "foreground".equals(string)) && TK.isChange(object, object2) && this.getClientProperty("html") != null) {
                super.firePropertyChange(string, object, object2);
            }
        }

        @Override
        protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        }
    }

    public static interface Optimized {
        public void invalidate();

        public void repaint();

        public void repaint(Rectangle var1);

        public void repaint(long var1, int var3, int var4, int var5, int var6);

        public void revalidate();

        public void validate();

        public void firePropertyChange(String var1, boolean var2, boolean var3);

        public void firePropertyChange(String var1, byte var2, byte var3);

        public void firePropertyChange(String var1, char var2, char var3);

        public void firePropertyChange(String var1, double var2, double var4);

        public void firePropertyChange(String var1, float var2, float var3);

        public void firePropertyChange(String var1, int var2, int var3);

        public void firePropertyChange(String var1, long var2, long var4);

        public void firePropertyChange(String var1, short var2, short var3);
    }
}

