/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.UI;

public class MScrollPane
extends JScrollPane
implements UI.ComponentExtensions {
    public static final int DRAG_SCROLLER = 1;
    public static final int NO_BORDER = 2;
    private int maximumHeight = -1;
    private static MouseWheelListener sharedWheelListener;

    public MScrollPane() {
        this(null, 0);
    }

    public MScrollPane(int n) {
        this(null, n);
    }

    public MScrollPane(JComponent jComponent) {
        this(jComponent, 0);
    }

    public MScrollPane(JComponent jComponent, int n) {
        super(jComponent);
        JScrollBar jScrollBar;
        Flags flags = new Flags(n);
        if (flags.isSet(1L)) {
            MScrollPane.installDragScroller(jComponent);
        }
        if (flags.isSet(2L)) {
            this.setBorder(null);
        }
        if (sharedWheelListener == null) {
            sharedWheelListener = new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    JScrollBar jScrollBar;
                    Object object = mouseWheelEvent.getSource();
                    if (object instanceof JScrollBar && (jScrollBar = (JScrollBar)object).isEnabled() && jScrollBar.getOrientation() == 0) {
                        MAction.fire(mouseWheelEvent, "negativeUnitIncrement", "positiveUnitIncrement", jScrollBar);
                    }
                }
            };
        }
        if ((jScrollBar = this.getHorizontalScrollBar()) != null) {
            jScrollBar.addMouseWheelListener(sharedWheelListener);
        }
    }

    public static void autoScroll(JComponent jComponent, int n, int n2) {
        jComponent.scrollRectToVisible(new Rectangle(n, n2, 1, 1));
    }

    public int getMaximumHeight() {
        return this.maximumHeight;
    }

    public void setMaximumHeight(int n) {
        if (n != this.maximumHeight) {
            this.maximumHeight = n;
            this.revalidate();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.maximumHeight == -1) {
            return dimension;
        }
        return new Dimension(dimension.width, this.maximumHeight);
    }

    public static JScrollPane getScrollPane(Component component) {
        JViewport jViewport = MScrollPane.getViewport(component);
        if (jViewport == null) {
            return null;
        }
        Container container = jViewport.getParent();
        return container instanceof JScrollPane ? (JScrollPane)container : null;
    }

    public static MScrollPane getScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = MScrollPane.getScrollPane((Component)jComponent);
        return jScrollPane instanceof MScrollPane ? (MScrollPane)jScrollPane : null;
    }

    public static JViewport getViewport(Component component) {
        Container container = component.getParent();
        return container instanceof JViewport ? (JViewport)container : null;
    }

    public static JViewport getViewport(JComponent jComponent) {
        return MScrollPane.getViewport((Component)jComponent);
    }

    public static DragScroller installDragScroller(JComponent jComponent) {
        return new DragScroller(jComponent);
    }

    public static void mouseWheelScroll(JComponent jComponent, MouseWheelEvent mouseWheelEvent) {
        if (jComponent == null) {
            return;
        }
        if (mouseWheelEvent == null) {
            return;
        }
        Rectangle rectangle = jComponent.getVisibleRect();
        if (rectangle == null) {
            return;
        }
        int n = mouseWheelEvent.getWheelRotation() * 30;
        if (mouseWheelEvent.isControlDown()) {
            n *= 2;
        }
        if (mouseWheelEvent.isAltDown()) {
            rectangle.translate(n, 0);
        } else {
            rectangle.translate(0, n);
        }
        jComponent.scrollRectToVisible(rectangle);
    }

    public static void scrollToBottom(JComponent jComponent, boolean bl) {
        MScrollPane.doScroll(jComponent, false, bl);
    }

    public static void scrollToNextItem(JComponent jComponent, Rectangle rectangle) {
        if (rectangle != null) {
            int n;
            jComponent.scrollRectToVisible(rectangle);
            JViewport jViewport = MScrollPane.getViewport(jComponent);
            int n2 = n = jViewport == null ? 0 : jViewport.getViewPosition().y;
            if (n > 0) {
                rectangle.translate(0, rectangle.height);
                jComponent.scrollRectToVisible(rectangle);
            }
        }
    }

    public static void scrollToTop(JComponent jComponent, boolean bl) {
        MScrollPane.doScroll(jComponent, true, bl);
    }

    public void setScrollBarVisible(boolean bl) {
        this.setHorizontalScrollBarPolicy(bl ? 30 : 31);
        this.setVerticalScrollBarPolicy(bl ? 20 : 21);
    }

    public void setScrollSpeed(int n) {
        this.getHorizontalScrollBar().setUnitIncrement(n);
        this.getVerticalScrollBar().setUnitIncrement(n);
    }

    private static void doScroll(JComponent jComponent, boolean bl, boolean bl2) {
        JViewport jViewport;
        JViewport jViewport2 = jViewport = jComponent instanceof JScrollPane ? ((JScrollPane)JScrollPane.class.cast(jComponent)).getViewport() : MScrollPane.getViewport(jComponent);
        if (jViewport != null) {
            Point point = jViewport.getViewPosition();
            if (bl2) {
                point.x = 0;
            }
            point.y = bl ? 0 : jViewport.getViewSize().height;
            jViewport.setViewPosition(point);
        }
    }

    public static final class DragScroller {
        private Point startDrag = new Point();

        public DragScroller(JComponent jComponent) {
            MMouseAdapter mMouseAdapter = new MMouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    int n = ((DragScroller)DragScroller.this).startDrag.x - mouseEvent.getX();
                    int n2 = ((DragScroller)DragScroller.this).startDrag.y - mouseEvent.getY();
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    JViewport jViewport = MScrollPane.getViewport(jComponent);
                    Point point = jViewport.getViewPosition();
                    point.translate(n, n2);
                    jViewport.setViewPosition(point);
                    mouseEvent.consume();
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    DragScroller.this.startDrag = mouseEvent.getPoint();
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    UI.setStyle("cursor: pointer", jComponent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    DragScroller.this.startDrag.setLocation(0, 0);
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    UI.setStyle("cursor: default", jComponent);
                }
            };
            jComponent.addMouseListener(mMouseAdapter);
            jComponent.addMouseMotionListener(mMouseAdapter);
        }
    }
}

