/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Hashtable;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.TriBoolean;
import org.makagiga.commons.UI;

public class MSlider
extends JSlider
implements MouseWheelListener,
UI.ComponentExtensions,
UI.EventsControl,
UI.MouseWheelEventsControl {
    private boolean eventsEnabled;
    private boolean mouseWheelEventsEnabled = true;

    public MSlider() {
        this.addChangeListener(new StaticHandler());
        this.addMouseWheelListener(this);
    }

    @Override
    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    @Override
    public void setEventsEnabled(boolean bl) {
        this.eventsEnabled = bl;
    }

    @Override
    public boolean getMouseWheelEventsEnabled() {
        return this.mouseWheelEventsEnabled;
    }

    @Override
    public void setMouseWheelEventsEnabled(boolean bl) {
        this.mouseWheelEventsEnabled = bl;
    }

    public void setLabels(Labels labels) {
        this.setLabelTable(labels);
        this.setPaintLabels(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int n, boolean bl) {
        TriBoolean triBoolean = bl ? TriBoolean.from(this.eventsEnabled) : TriBoolean.UNDEFINED;
        try {
            if (bl) {
                this.setEventsEnabled(false);
            }
            this.setValue(n);
        }
        finally {
            if (triBoolean.isDefined()) {
                this.setEventsEnabled(triBoolean.isTrue());
            }
        }
    }

    public void showSimpleLabels() {
        Labels labels = new Labels();
        labels.add(this.getMinimum(), "-");
        labels.add(this.getMaximum(), "+");
        this.setLabels(labels);
    }

    public void showTicks(int n, boolean bl, boolean bl2) {
        int n2 = this.getMaximum();
        Labels labels = new Labels();
        for (int i = this.getMinimum(); i <= n2; i += n) {
            if (bl2) {
                labels.add(i);
                continue;
            }
            labels.add(i, null);
        }
        this.setLabels(labels);
        this.setMajorTickSpacing(n);
        this.setPaintTicks(true);
        this.setSnapToTicks(bl);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.mouseWheelEventsEnabled && this.isEnabled()) {
            MAction.fire(mouseWheelEvent, "positiveUnitIncrement", "negativeUnitIncrement", this);
        }
    }

    protected void onChange() {
    }

    private static final class StaticHandler
    implements ChangeListener {
        private StaticHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MSlider mSlider = (MSlider)changeEvent.getSource();
            if (mSlider.eventsEnabled) {
                mSlider.onChange();
            }
        }
    }

    public static class Labels
    extends Hashtable<Integer, MLabel> {
        public MLabel add(int n, String string) {
            MLabel mLabel = new MLabel(string);
            this.put(n, mLabel);
            return mLabel;
        }

        public MLabel add(int n) {
            return this.add(n, Integer.toString(n));
        }
    }
}

