/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.MColorIcon;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.ValueListener;
import org.makagiga.commons.color.ColorPalette;

public class MSmallColorButton
extends MSmallButton {
    private Color color;
    private MColorIcon icon;

    public MSmallColorButton() {
        this(Color.BLACK, new Dimension(32, 16), MColorIcon.Type.RECTANGLE);
    }

    public MSmallColorButton(Color color, Dimension dimension, MColorIcon.Type type) {
        this.icon = new MColorIcon(color, -1);
        this.icon.setType(type);
        this.setIcon(this.icon);
        this.setColor(color);
        this.setFocusPainted(false);
        UI.setFixedSize(this, dimension.width, dimension.height);
    }

    public void addValueListener(ValueListener<Color> valueListener) {
        this.listenerList.add(ValueListener.class, valueListener);
    }

    public ValueListener<Color>[] getValueListeners() {
        return (ValueListener[])this.listenerList.getListeners(ValueListener.class);
    }

    public void removeValueListener(ValueListener<Color> valueListener) {
        this.listenerList.remove(ValueListener.class, valueListener);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (TK.isChange(this.color, color)) {
            this.color = color;
            this.icon.setColor(this.color);
            this.repaint();
            this.setToolTipText(ColorProperty.toString(color));
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return MSmallColorButton.getToolTipText(this.color, null);
    }

    protected void fireValueChanged(Color color, Color color2) {
        TK.fireValueChanged(this, this.getValueListeners(), color, color2);
    }

    static String getToolTipText(Color color, ColorPalette colorPalette) {
        String string;
        String string2 = UI._("Click to select a color");
        if (color == null) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = TK.toUpperCase(ColorProperty.toString(color));
        stringBuilder.append(TK.escapeXML(string2)).append("<br>").append("<code>").append(string3).append("</code><br>").append(String.format("RGB: %d %d %d", color.getRed(), color.getGreen(), color.getBlue()));
        if (colorPalette != null) {
            string = colorPalette.getDisplayName(color);
            if ("Untitled".equals(string)) {
                string = ColorPalette.getNamedColors().getDisplayName(color);
            }
        } else {
            string = ColorPalette.getNamedColors().getDisplayName(color);
        }
        if (!string3.equals(string)) {
            stringBuilder.append("<br>").append("<br>").append(TK.escapeXML(string));
        }
        return UI.makeHTML(stringBuilder.toString());
    }
}

