/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JPanel;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.MainView;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.fx.Blend;

public class MStatusBar
extends MPanel {
    public static final int AUTOHIDE_MESSAGE = 1;
    public static final int ERROR_MESSAGE = 2;
    public static final int INFO_MESSAGE = 4;
    public static final int WARNING_MESSAGE = 8;
    public static final String CLOSED_PROPERTY = "MStatusBar.closed";
    private boolean closed;
    private final CoolHeader text;
    private int blinkCount;
    private MIcon icon;
    private final MPanel buttonPanel;
    private final MTimer blinkTimer;
    private final MTimer textTimer;

    public MStatusBar() {
        super(0);
        MWhatsThis.set(this, UI._("Status Bar - Info and minor error messages"));
        this.buttonPanel = MPanel.createHBoxPanel();
        this.add(this.buttonPanel);
        this.text = new CoolHeader();
        this.text.setStyle("font-family: Dialog; font-size: larger; margin: 2");
        this.add(this.text);
        int n = UI.statusBarTimeout.normalize(1, Integer.MAX_VALUE);
        this.textTimer = new MTimer(MTimer.Format.SECONDS, n){

            @Override
            protected boolean onTimeout() {
                MStatusBar.ready();
                if (MStatusBar.this.closed) {
                    MStatusBar.this.setVisible(false);
                }
                return false;
            }
        };
        this.blinkTimer = new MTimer(MTimer.Format.SECONDS, 1){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean onTimeout() {
                if (MStatusBar.this.blinkCount % 2 == 0) {
                    MStatusBar.this.text.setIcon(MIcon.small("ui/info"));
                } else {
                    MStatusBar mStatusBar = MStatusBar.this;
                    synchronized (mStatusBar) {
                        MStatusBar.this.text.setIcon(MStatusBar.this.icon);
                    }
                }
                MStatusBar.this.blinkCount++;
                return MStatusBar.this.blinkCount < 4;
            }
        };
    }

    public void addButton(MSmallButton mSmallButton) {
        this.buttonPanel.add(mSmallButton);
        this.buttonPanel.validate();
    }

    public void removeButton(MSmallButton mSmallButton) {
        this.buttonPanel.remove(mSmallButton);
        this.buttonPanel.validate();
    }

    public static void error(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            MStatusBar.error(UI._("Out of memory: {0}", throwable.getMessage()));
        } else {
            MStatusBar.error(throwable.toString());
        }
        if (MLogger.isDeveloper()) {
            MLogger.exception(throwable);
        }
    }

    public static synchronized void error(String string) {
        MainView.getStatusBar().setText(string, 3);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMStatusBar();
        }
        return this.accessibleContext;
    }

    public MPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public static synchronized void info(String string) {
        MainView.getStatusBar().setText(string, 5);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        this.setVisible(!bl);
        if (bl != this.closed) {
            this.closed = bl;
            this.firePropertyChange(CLOSED_PROPERTY, !bl, bl);
        }
    }

    public static synchronized void message(String string) {
        MainView.getStatusBar().setText(string, 4);
    }

    public static synchronized void ready() {
        MainView.getStatusBar().setText(null, 0);
    }

    public synchronized void setText(String string, int n) {
        boolean bl;
        Flags flags = new Flags(n);
        if (flags.isSet(2L)) {
            this.icon = MIcon.small("ui/error");
            bl = true;
            this.startTextAnimation(MHighlighter.ERROR_COLOR);
        } else if (flags.isSet(4L)) {
            this.icon = MIcon.small("ui/info");
            bl = false;
            this.startTextAnimation(MHighlighter.OK_COLOR);
        } else if (flags.isSet(8L)) {
            this.icon = MIcon.small("ui/warning");
            bl = true;
            this.startTextAnimation(MHighlighter.WARNING_COLOR);
        } else {
            Blend.stopAnimation(this.text);
            this.icon = null;
            bl = false;
            this.text.setColor(null, null);
        }
        this.text.setIcon(this.icon);
        if (bl) {
            this.blinkCount = 0;
            this.blinkTimer.restart();
        } else {
            this.blinkTimer.stop();
        }
        if (TK.isEmpty(string)) {
            this.text.setBackgroundPainted(false);
            this.text.setText(" ");
            this.text.setToolTipText(null);
        } else {
            this.text.setBackgroundPainted(true);
            this.text.setText(string);
            this.text.setToolTipText(string);
        }
        this.setVisible(!this.closed || this.icon != null);
        if (flags.isSet(1L)) {
            this.textTimer.restart();
        } else {
            this.textTimer.stop();
        }
    }

    public static synchronized void warning(String string) {
        MainView.getStatusBar().setText(string, 9);
    }

    private void startTextAnimation(Color color) {
        this.text.setForeground(Color.BLACK);
        Blend.animateBackground(this.text, null, color);
    }

    protected class AccessibleMStatusBar
    extends JPanel.AccessibleJPanel {
        protected AccessibleMStatusBar() {
            super(MStatusBar.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.STATUS_BAR;
        }
    }
}

