/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.OS;
import org.makagiga.commons.UI;

public final class MSystemTray {
    private static boolean visible;
    private static Dimension lastWindowSize;
    private static PropertyChangeListener pcl;
    private static String lastToolTip;
    private static TrayIcon icon;

    public static synchronized TrayIcon getIcon() {
        return icon;
    }

    public static synchronized boolean isHideMainWindowInTray() {
        return MSystemTray.isVisible() && (Boolean)UI.systemTray.get() != false && (Boolean)UI.hideMainWindowInTray.get() != false;
    }

    public static synchronized boolean isVisible() {
        return visible && icon != null;
    }

    public static synchronized void setToolTip(String string) {
        lastToolTip = string;
        if (icon != null) {
            if (!((Boolean)UI.hackShowTrayToolTip.get()).booleanValue()) {
                return;
            }
            String string2 = string;
            String string3 = MApplication.getFullName();
            if (string3 != null) {
                string2 = string2 != null ? string2 + " - " + string3 : string3;
            }
            icon.setToolTip(string2);
        }
    }

    public static synchronized void setVisible(boolean bl) {
        block12: {
            if (pcl == null) {
                pcl = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getSource() == UI.systemTray && "value".equals(propertyChangeEvent.getPropertyName())) {
                            MSystemTray.setVisible((Boolean)UI.systemTray.get());
                        }
                    }
                };
                UI.systemTray.addPropertyChangeListener(pcl);
            }
            if (visible == bl) {
                return;
            }
            visible = bl;
            if (!SystemTray.isSupported()) {
                return;
            }
            SystemTray systemTray = SystemTray.getSystemTray();
            if (bl) {
                Serializable serializable;
                Image image = MApplication.getLogo();
                if (image == null) {
                    image = MIcon.stock("ui/misc").getImage();
                }
                if (OS.isLinux()) {
                    serializable = systemTray.getTrayIconSize();
                    image = UI.scaleImage(image, ((Dimension)serializable).width, ((Dimension)serializable).height, UI.Quality.HIGH);
                }
                icon = new TrayIcon(image);
                if (!OS.isLinux()) {
                    icon.setImageAutoSize(true);
                }
                MSystemTray.setToolTip(lastToolTip);
                icon.addMouseListener(new MMouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        MMainWindow mMainWindow = MApplication.getMainWindow();
                        if (mMainWindow != null && Boolean.TRUE.equals(mMainWindow.onDynamicInit(icon, mouseEvent))) {
                            return;
                        }
                        if (mMainWindow != null && 2.isLeft(mouseEvent)) {
                            if (mMainWindow.isVisible()) {
                                lastWindowSize = mMainWindow.getSize();
                                mMainWindow.setVisible(false);
                                mMainWindow.fireWindowIconified();
                            } else {
                                mMainWindow.restore();
                                if (lastWindowSize != null) {
                                    mMainWindow.setSize(lastWindowSize);
                                    lastWindowSize = null;
                                }
                            }
                        }
                    }

                    @Override
                    public void popupTrigger(MouseEvent mouseEvent) {
                        MMainWindow mMainWindow = MApplication.getMainWindow();
                        if (mMainWindow != null && mMainWindow.isLocked()) {
                            return;
                        }
                        MMenu mMenu = new MMenu();
                        Icon icon = MApplication.getIcon();
                        if (icon instanceof MIcon) {
                            icon = ((MIcon)MIcon.class.cast(icon)).scaleSmall();
                        }
                        mMenu.addTitle(MApplication.getFullName(), icon);
                        int n = mMenu.getItemCount();
                        if (mMainWindow != null) {
                            mMainWindow.onDynamicInit(icon, mMenu);
                        }
                        if (mMenu.getItemCount() > n) {
                            mMenu.addSeparator();
                        }
                        mMenu.add(MApplication.getQuitAction());
                        mMenu.addSeparator();
                        mMenu.add(new MAction(MActionInfo.CANCEL));
                        JPopupMenu jPopupMenu = mMenu.getPopupMenu();
                        jPopupMenu.setLocation(mouseEvent.getPoint());
                        jPopupMenu.setInvoker(jPopupMenu);
                        jPopupMenu.setVisible(true);
                    }
                });
                try {
                    systemTray.add(icon);
                    serializable = MApplication.getMainWindow();
                    if (serializable != null) {
                        ((MMainWindow)serializable).onDynamicInit(SystemTray.getSystemTray());
                    }
                    break block12;
                }
                catch (AWTException aWTException) {
                    MLogger.exception(aWTException);
                    MLogger.warning("core", "System tray is not supported on this platform");
                    visible = false;
                    if (icon != null) {
                        systemTray.remove(icon);
                        icon = null;
                    }
                    break block12;
                }
            }
            if (icon != null) {
                systemTray.remove(icon);
                icon = null;
            }
        }
    }

    private MSystemTray() {
    }
}

