/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Rectangle;
import java.net.URL;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MText;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.sb.SecureOpen;
import org.makagiga.commons.style.StyleSupport;

public class MTextPane
extends JTextPane
implements MText.CommonExtensions,
MText.Modifiable,
SecureOpen,
StyleSupport {
    private boolean modified;
    private boolean secureOpen;
    private Hyperlink currentHyperlink;
    public static final String TEXT_HTML_UTF_8 = "text/html; charset=UTF-8";

    public MTextPane() {
        this.setDragEnabled((Boolean)Kiosk.actionDragDrop.get());
        MText.install(this);
        StaticHandler staticHandler = new StaticHandler();
        this.addHyperlinkListener(staticHandler);
        MText.setUserMenu(this, staticHandler);
    }

    public synchronized void clearStreamDescription() {
        this.getDocument().putProperty("stream", null);
    }

    public synchronized Hyperlink getCurrentHyperlink() {
        return this.currentHyperlink;
    }

    public synchronized boolean getHonorDisplayProperties() {
        return UI.getClientProperty(this, "JEditorPane.honorDisplayProperties", false);
    }

    public synchronized void setHonorDisplayProperties(boolean bl) {
        this.putClientProperty("JEditorPane.honorDisplayProperties", bl);
    }

    public synchronized String getText(Element element) {
        if (element == null) {
            return null;
        }
        try {
            return this.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public synchronized String getPlainText() {
        return MText.getPlainText(this);
    }

    public synchronized String getTitle() {
        Object object = this.getDocument().getProperty("title");
        return object == null ? null : object.toString();
    }

    @Override
    public boolean isSecureOpen() {
        return this.secureOpen;
    }

    @Override
    public void setSecureOpen(boolean bl) {
        this.secureOpen = bl;
    }

    @Override
    public void scrollToReference(String string) {
        HTMLDocument hTMLDocument;
        Element element;
        super.scrollToReference(string);
        if (string == null) {
            return;
        }
        Document document = this.getDocument();
        if (document instanceof HTMLDocument && (element = (hTMLDocument = (HTMLDocument)document).getElement(string)) != null) {
            try {
                Rectangle rectangle = this.modelToView(element.getStartOffset());
                if (rectangle != null) {
                    rectangle.height = this.getVisibleRect().height;
                    this.scrollRectToVisible(rectangle);
                }
            }
            catch (BadLocationException badLocationException) {
                MLogger.exception(badLocationException);
            }
        }
    }

    public synchronized void scrollToTop() {
        this.setCaretPosition(0);
    }

    @Override
    public synchronized void setText(String string) {
        this.currentHyperlink = null;
        this.setToolTipText(null);
        super.setText(string);
    }

    @Override
    public synchronized void clear() {
        this.setText(null);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.getDocument().getLength() == 0;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean bl, Object object) {
        this.modified = bl;
        if (this.modified) {
            this.onChange(object instanceof DocumentEvent ? (DocumentEvent)object : null);
        }
    }

    @Override
    public void setStyle(String string) {
        UI.setStyle(string, this);
    }

    protected void onChange(DocumentEvent documentEvent) {
    }

    protected synchronized boolean onHyperlinkClick(HyperlinkEvent hyperlinkEvent) {
        return false;
    }

    private static final class StaticHandler
    implements HyperlinkListener,
    MText.UserMenu<MTextPane> {
        private StaticHandler() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            MTextPane mTextPane = (MTextPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                URL uRL;
                mTextPane.setToolTipText(null);
                String string = hyperlinkEvent.getDescription();
                if (TK.startsWith(string, '#')) {
                    mTextPane.scrollToReference(string.substring(1));
                }
                if (!mTextPane.onHyperlinkClick(hyperlinkEvent) && (uRL = hyperlinkEvent.getURL()) != null) {
                    MMainWindow.openURI(uRL, (SecureOpen)mTextPane);
                }
                mTextPane.currentHyperlink = null;
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                String string = hyperlinkEvent.getDescription();
                URL uRL = hyperlinkEvent.getURL();
                String string2 = mTextPane.getText(hyperlinkEvent.getSourceElement());
                if (string2 == null) {
                    string2 = string;
                }
                mTextPane.currentHyperlink = new Hyperlink(uRL, string2);
                if (uRL == null) {
                    mTextPane.setToolTipText(TK.isEmpty(string) ? UI._("No Description") : string);
                } else {
                    mTextPane.setToolTipText(TK.centerSqueeze(uRL.toString(), 128));
                }
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                mTextPane.currentHyperlink = null;
                mTextPane.setToolTipText(null);
            }
        }

        @Override
        public void onUserMenu(MTextPane mTextPane, MMenu mMenu) {
            if (mTextPane.currentHyperlink != null && mTextPane.currentHyperlink.url != null) {
                MURLButton.updateLinkMenu(mMenu, mTextPane.currentHyperlink.url.toString(), mTextPane.currentHyperlink.description);
            }
        }
    }

    public static final class Hyperlink {
        private final String description;
        private final URL url;

        public Hyperlink(URL uRL, String string) {
            this.description = string;
            this.url = uRL;
        }

        public String getDescription() {
            return this.description;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

