/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLineBorder;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.mods.Mods;
import org.makagiga.commons.script.ScriptYourself;

public class MToolBar
extends JToolBar {
    public static final int SHOW_TEXT = 1;
    public static final int NO_TEXT = 2;
    public static final String MOD_ADD_NOTIFY = "addNotify@org.makagiga.commons.MToolBar";
    public static final String MOD_REMOVE_NOTIFY = "removeNotify@org.makagiga.commons.MToolBar";
    private boolean lineBorderSet;
    private LayoutManager defaultLayout;
    private MIcon.Size iconSize;
    private MLineBorder.Position lineBorderPosition;
    private String id;
    private TextPosition textPosition = TextPosition.USER;

    public MToolBar() {
        this(0, MIcon.Size.DEFAULT);
    }

    public MToolBar(int n) {
        this(n, MIcon.Size.DEFAULT);
    }

    public MToolBar(int n, MIcon.Size size) {
        super(n);
        this.iconSize = size;
        if (UI.isMetal()) {
            this.setBorder(null);
            this.setBorderPainted(false);
        }
        this.setFloatable(false);
        this.setRollover(true);
    }

    public MToolBar(MIcon.Size size) {
        this(0, size);
    }

    @Override
    public JButton add(Action action) {
        return this.add(action, 0);
    }

    public JButton add(Action action, int n) {
        MButton mButton = new MButton(action);
        this.addButton(mButton, n);
        return mButton;
    }

    public void addButton(AbstractButton abstractButton) {
        this.addButton(abstractButton, 0);
    }

    public void addButton(AbstractButton abstractButton, int n) {
        this.addButtonAt(-1, abstractButton, n);
    }

    public void addButtonAt(int n, AbstractButton abstractButton, int n2) {
        abstractButton.setRequestFocusEnabled(false);
        if (UI.isSubstance()) {
            abstractButton.putClientProperty("substancelaf.buttonnominsize", true);
        } else if (UI.isMetal()) {
            MButton.installSpecialEffects(abstractButton);
        }
        this.setupButtonText(abstractButton, new Flags(n2));
        this.add((Component)abstractButton, n);
    }

    public Component addContentGap() {
        return this.addGap(10);
    }

    public Component addGap() {
        return this.addGap(5);
    }

    public Component addGap(int n) {
        Component component = this.getOrientation() == 1 ? Box.createRigidArea(new Dimension(0, n)) : Box.createRigidArea(new Dimension(n, 0));
        this.add(component);
        return component;
    }

    public void addLineSeparator() {
        super.addSeparator();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Mods.exec(this, MOD_ADD_NOTIFY, new Object[0]);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Mods.exec(this, MOD_REMOVE_NOTIFY, new Object[0]);
    }

    @Override
    public void addSeparator() {
        this.addGap();
    }

    public Component addStretch() {
        Component component = this.getOrientation() == 1 ? Box.createVerticalGlue() : Box.createHorizontalGlue();
        this.add(component);
        return component;
    }

    public MIcon.Size getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(MIcon.Size size) {
        this.iconSize = size;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = TK.validateID(string);
    }

    public TextPosition getTextPosition() {
        return this.textPosition;
    }

    public void setTextPosition(TextPosition textPosition) {
        this.textPosition = textPosition;
    }

    @Deprecated
    public void readConfig(String string) {
        ScriptYourself.install(this, string);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.lineBorderPosition = null;
        this.lineBorderSet = false;
    }

    @Override
    public void setBorderPainted(boolean bl) {
        super.setBorderPainted(bl);
        this.lineBorderPosition = null;
        this.lineBorderSet = false;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    @Override
    public void setOpaque(boolean bl) {
        if (UI.isSubstance()) {
            super.setOpaque(true);
        } else {
            super.setOpaque(bl);
        }
    }

    @Deprecated
    public void showLineBorder() {
        this.setBorder(BorderFactory.createLineBorder(UI.getDarker(this.getBackground(), Color.WHITE), 1));
        this.setBorderPainted(true);
        this.lineBorderPosition = null;
        this.lineBorderSet = true;
    }

    public void showLineBorder(MLineBorder.Position position) {
        MLineBorder mLineBorder = new MLineBorder(position);
        mLineBorder.getStyle(position).setColor(UI.getDarker(this.getBackground(), Color.WHITE));
        this.setBorder(mLineBorder);
        this.setBorderPainted(true);
        this.lineBorderPosition = position;
        this.lineBorderSet = true;
    }

    @Override
    public void updateUI() {
        if (this.defaultLayout == null) {
            this.defaultLayout = this.getLayout();
        }
        super.updateUI();
        if (this.defaultLayout != null && UI.isSynth()) {
            this.setLayout(this.defaultLayout);
        }
        if (this.lineBorderSet) {
            if (this.lineBorderPosition != null) {
                this.showLineBorder(this.lineBorderPosition);
            } else {
                this.showLineBorder();
            }
        }
    }

    private void setupButtonText(AbstractButton abstractButton, Flags flags) {
        boolean bl;
        Icon icon;
        TextPosition textPosition;
        String string;
        Action action = abstractButton.getAction();
        int n = MIcon.getUISize();
        String string2 = string = action == null ? abstractButton.getText() : MAction.getValue(action, "Name", null);
        if (this.textPosition == TextPosition.USER) {
            textPosition = (TextPosition)((Object)UI.toolBarTextPosition.get());
            if (textPosition == TextPosition.UNDER_ICONS && (this.iconSize == MIcon.Size.SMALL || n == MIcon.getSmallSize())) {
                textPosition = TextPosition.ALONGSIDE_ICONS;
            }
        } else {
            textPosition = this.textPosition;
        }
        if (abstractButton instanceof MButton && !(abstractButton instanceof MSmallButton) && this.getOrientation() == 0 && textPosition == TextPosition.UNDER_ICONS) {
            ((MButton)MButton.class.cast(abstractButton)).setMinimumWidth(n + 20);
        }
        if (action != null && this.iconSize != MIcon.Size.DEFAULT && (icon = MAction.getIcon(action, this.iconSize)) != null && icon != abstractButton.getIcon()) {
            abstractButton.setIcon(icon);
        }
        boolean bl2 = bl = abstractButton.getIcon() != null;
        if (bl) {
            Font font = this.getFont();
            int n2 = font == null ? UI.getDefaultFontSize() : font.getSize();
            UI.changeFontSize(abstractButton, -1, --n2, Integer.MAX_VALUE);
        }
        if (textPosition == TextPosition.UNDER_ICONS) {
            abstractButton.setHorizontalAlignment(0);
            abstractButton.setHorizontalTextPosition(0);
            abstractButton.setVerticalTextPosition(3);
            if (flags.isSet(2L) && bl) {
                abstractButton.setText(null);
                if (abstractButton.getToolTipText() == null) {
                    abstractButton.setToolTipText(string);
                }
            } else {
                abstractButton.setText(string);
            }
        } else if (flags.isSet(1L) && flags.isClear(2L) || !bl) {
            abstractButton.setHorizontalTextPosition(4);
            abstractButton.setVerticalTextPosition(0);
            abstractButton.setText(string);
        } else {
            if (bl) {
                abstractButton.setHideActionText(true);
            }
            abstractButton.setHorizontalTextPosition(0);
            abstractButton.setVerticalTextPosition(3);
            abstractButton.setText(null);
            if (abstractButton.getToolTipText() == null) {
                abstractButton.setToolTipText(string);
            }
        }
        if (abstractButton.getToolTipText() == null) {
            abstractButton.setToolTipText(string == null ? "" : string);
        }
    }

    public static enum TextPosition {
        ALONGSIDE_ICONS,
        UNDER_ICONS,
        USER;


        public String toString() {
            switch (this) {
                case ALONGSIDE_ICONS: {
                    return UI._("Alongside Icons");
                }
                case UNDER_ICONS: {
                    return UI._("Under Icons");
                }
                case USER: {
                    return UI._("Default");
                }
            }
            throw new WTFError(this);
        }
    }
}

