/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.ContainerIterator;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuBar;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.fx.Blend;
import org.makagiga.commons.sb.SecureOpen;

public class MURLButton
extends MButton
implements SecureOpen {
    private boolean dragEnabled = (Boolean)Kiosk.actionDragDrop.get();
    private boolean secureOpen;
    private boolean showLinkActions = true;
    private Color linkColor;
    private Color linkHoverColor;
    private static List<LinkAction> linkActions;
    private static Set<String> visitedLinks;
    private String title;
    private String url;

    public MURLButton() {
        this.setContentAreaFilled(false);
        this.setCursor(12);
        this.setHorizontalAlignment(10);
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
        this.setStyle("margin: 2; padding: 0");
        new StaticDragHandler(this);
        this.addMouseListener(new StaticMouseHandler());
        if (Beans.isDesignTime()) {
            this.setText(this.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLinkAction(LinkAction linkAction) {
        Class<MURLButton> clazz = MURLButton.class;
        synchronized (MURLButton.class) {
            if (linkActions == null) {
                linkActions = new ArrayList<LinkAction>();
            }
            linkActions.add(linkAction);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateLinkColor(false);
    }

    public static synchronized void deletePrivateData() {
        visitedLinks.clear();
        for (Frame frame : Frame.getFrames()) {
            for (MURLButton mURLButton : ContainerIterator.findAll(frame, MURLButton.class)) {
                mURLButton.updateLinkColor(true);
            }
        }
    }

    public Color getLinkColor() {
        if (this.isVisited()) {
            return MColor.getVisitedLinkForeground(this.getParentBackground());
        }
        if (this.linkColor != null) {
            return this.linkColor;
        }
        return MColor.getLinkForeground(this.getParentBackground());
    }

    public void setLinkColor(Color color) {
        if (TK.isChange(color, this.linkColor)) {
            this.linkColor = color;
            this.updateLinkColor(true);
        }
    }

    public Color getHoverLinkColor() {
        if (this.isVisited()) {
            return MColor.getVisitedLinkForeground(this.getParentBackground());
        }
        if (this.linkHoverColor != null) {
            return this.linkHoverColor;
        }
        return MColor.getHoverLinkForeground(this.getParentBackground());
    }

    public void setHoverLinkColor(Color color) {
        this.linkHoverColor = color;
    }

    public void doOpen() {
        if (this.url != null) {
            this.setVisited(true);
            try {
                MMainWindow.openURI(this.url, (SecureOpen)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MMessage.error(UI.windowFor(this), illegalArgumentException);
            }
        }
    }

    public static String getLinkToolTipText(String string) {
        if (string == null) {
            return null;
        }
        Color color = UI.getColor("ToolTip.background");
        Color color2 = MColor.getLinkForeground(color);
        String string2 = String.format("<a href=\"%s\" style=\"color: " + ColorProperty.toString(color2) + "; text-decoration: none\">%s</a>", string, TK.centerSqueeze(string, 128));
        return UI.makeHTML(UI._("Open {0}", string2));
    }

    public boolean getShowLinkActions() {
        return this.showLinkActions;
    }

    public void setShowLinkActions(boolean bl) {
        this.showLinkActions = bl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        if (TK.isChange(this.url, string)) {
            this.url = string;
            this.setToolTipText(MURLButton.getLinkToolTipText(this.url));
            this.updateLinkColor(true);
        }
    }

    public void setURLAndText(String string) {
        this.setText(TK.centerSqueeze(string, 128));
        this.setURL(string);
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    @Override
    public boolean isSecureOpen() {
        return this.secureOpen;
    }

    @Override
    public void setSecureOpen(boolean bl) {
        this.secureOpen = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisited() {
        if (this.url == null) {
            return false;
        }
        Class<MURLButton> clazz = MURLButton.class;
        synchronized (MURLButton.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return visitedLinks.contains(this.url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setVisited(boolean bl) {
        if (bl == this.isVisited()) return;
        if (this.url != null) {
            Class<MURLButton> clazz = MURLButton.class;
            // MONITORENTER : org.makagiga.commons.MURLButton.class
            if (bl) {
                visitedLinks.add(this.url);
            } else {
                visitedLinks.remove(this.url);
            }
            // MONITOREXIT : clazz
        }
        this.updateLinkColor(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLinkAction(LinkAction linkAction) {
        Class<MURLButton> clazz = MURLButton.class;
        synchronized (MURLButton.class) {
            if (linkActions != null) {
                linkActions.remove(linkAction);
                if (linkActions.isEmpty()) {
                    linkActions = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void showLinkMenu() {
        MMenu mMenu = new MMenu();
        MURLButton.updateLinkMenu(mMenu, this.url, this.showLinkActions, this.title == null ? this.getText() : this.title);
        if (!mMenu.isEmpty()) {
            mMenu.showPopup(this);
        }
    }

    public static void updateLinkMenu(MMenu mMenu, String string, String string2) {
        MURLButton.updateLinkMenu(mMenu, string, true, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateLinkMenu(MMenu mMenu, final String string, boolean bl, String string2) {
        if (string == null) {
            return;
        }
        mMenu.addTitle(TK.centerSqueeze(string));
        MAction mAction = new MAction(UI._("Copy Link Address"), "ui/copy"){

            @Override
            public void onAction() {
                try {
                    MClipboard.setString(string);
                }
                catch (ClipboardException clipboardException) {
                    MMessage.error(null, clipboardException);
                }
            }
        };
        mAction.setHTMLHelp(UI._("Copies link address to the clipboard."));
        mMenu.add(mAction);
        if (!((Boolean)Kiosk.linkExtraMenu.get()).booleanValue() || !bl) return;
        Class<MURLButton> clazz = MURLButton.class;
        synchronized (MURLButton.class) {
            if (linkActions == null) return;
            for (LinkAction linkAction : linkActions) {
                LinkAction linkAction2 = new LinkAction(linkAction, string, string2);
                linkAction2.setEnabled(linkAction.isSupported(string));
                mMenu.add(linkAction2);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void updateUI() {
        this.setUI(UI.getSimpleButtonUI());
        this.updateLinkColor(false);
    }

    @Override
    protected void onClick() {
        this.doOpen();
    }

    private Color getParentBackground() {
        Container container = this.getParent();
        if (UI.isSubstance() && container != null && (UI.getAncestorOfClass(MToolBar.class, this) != null || UI.getAncestorOfClass(MMenuBar.class, this) != null) && Boolean.getBoolean("org.makagiga.plugins.substance.Plugin.isDarkToolBarBackground")) {
            return Color.BLACK;
        }
        return container == null ? this.getBackground() : container.getBackground();
    }

    private void setFontUnderline(boolean bl) {
        Map<TextAttribute, Integer> map = TK.newHashMap(1);
        map.put(TextAttribute.UNDERLINE, bl ? TextAttribute.UNDERLINE_ON : -1);
        this.setFont(this.getFont().deriveFont(map));
    }

    private void updateLinkColor(boolean bl) {
        if (bl) {
            Blend.stopAnimation(this);
        }
        this.setForeground(this.getLinkColor());
    }

    static {
        visitedLinks = new HashSet<String>();
    }

    private static final class StaticMouseHandler
    extends MMouseAdapter {
        private StaticMouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MURLButton mURLButton = (MURLButton)mouseEvent.getSource();
            if (mURLButton.isEnabled()) {
                mURLButton.setFontUnderline(true);
                Blend.animateForeground(mURLButton, mURLButton.getLinkColor(), mURLButton.getHoverLinkColor());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MURLButton mURLButton = (MURLButton)mouseEvent.getSource();
            if (mURLButton.isEnabled()) {
                mURLButton.setFontUnderline(false);
                Blend.animateForeground(mURLButton, mURLButton.getHoverLinkColor(), mURLButton.getLinkColor());
            }
        }

        @Override
        public void popupTrigger(MouseEvent mouseEvent) {
            MURLButton mURLButton = (MURLButton)mouseEvent.getSource();
            mURLButton.showLinkMenu();
        }
    }

    private static final class StaticDragHandler
    extends MMouseAdapter.Drag {
        @Override
        protected boolean canDrag(MouseEvent mouseEvent) {
            MURLButton mURLButton = (MURLButton)mouseEvent.getSource();
            return mURLButton.dragEnabled;
        }

        @Override
        protected Transferable createTransferable(MouseEvent mouseEvent) {
            MURLButton mURLButton = (MURLButton)mouseEvent.getSource();
            return mURLButton.url == null ? null : new StringSelection(mURLButton.url);
        }

        private StaticDragHandler(MURLButton mURLButton) {
            super(mURLButton, 1);
        }
    }

    public static class LinkAction
    extends MAction {
        private LinkAction action;
        private String link;
        private String title;

        public LinkAction(String string) {
            super(string);
        }

        public LinkAction(String string, Icon icon) {
            super(string, icon);
        }

        public LinkAction(String string, String string2) {
            super(string, string2);
        }

        public boolean isSupported(String string) {
            return true;
        }

        @Override
        public final void onAction() {
            this.action.onAction(this.link, this.title);
        }

        public void onAction(String string, String string2) {
        }

        private LinkAction(LinkAction linkAction, String string, String string2) {
            super(linkAction.getName());
            this.setLargeIcon(linkAction.getLargeIcon());
            this.setSmallIcon(linkAction.getSmallIcon());
            this.action = linkAction;
            this.link = string;
            this.title = string2;
        }
    }
}

