/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MStatusBar;

public final class MainView {
    private static MMainWindow mainWindow;
    private static MStatusBar statusBar;

    public static void bind(Action ... actionArray) {
        JRootPane jRootPane = MainView.getRootPaneContainer().getRootPane();
        for (Action action : actionArray) {
            MAction.connect((JComponent)jRootPane, 2, action);
        }
    }

    public static List<Action> getBindList() {
        JRootPane jRootPane = MainView.getRootPaneContainer().getRootPane();
        ActionMap actionMap = jRootPane.getActionMap();
        Object[] objectArray = actionMap.keys();
        if (objectArray == null) {
            return Collections.emptyList();
        }
        MArrayList<Action> mArrayList = new MArrayList<Action>(objectArray.length);
        for (Object object : objectArray) {
            Action action = actionMap.get(object);
            if (action == null) continue;
            mArrayList.add(action);
        }
        return mArrayList;
    }

    public static RootPaneContainer getRootPaneContainer() {
        return mainWindow;
    }

    public static MStatusBar getStatusBar() {
        return statusBar;
    }

    public static Window getWindow() {
        return mainWindow;
    }

    private MainView() {
    }

    static void init(MMainWindow mMainWindow, MStatusBar mStatusBar) {
        mainWindow = mMainWindow;
        statusBar = mStatusBar;
    }
}

