/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.makagiga.commons.FS;
import org.makagiga.commons.MLogger;

public class SimpleXMLReader
implements Closeable {
    private Throwable error;
    protected Attributes attr = new Attributes();
    protected boolean cancelled;
    protected int event;
    protected XMLStreamReader reader;

    public void cancel() {
        this.cancelled = true;
    }

    public Attributes getAttributes() {
        return this.attr;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean getBooleanAttribute(String string, boolean bl) {
        String string2 = this.getStringAttribute(string);
        return string2 == null ? bl : Boolean.parseBoolean(string2);
    }

    public int getIntegerAttribute(String string, int n) {
        String string2 = (String)this.attr.get(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.setError(numberFormatException);
            return n;
        }
    }

    public long getLongAttribute(String string, long l) {
        String string2 = (String)this.attr.get(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.setError(numberFormatException);
            return l;
        }
    }

    public String getStringAttribute(String string) {
        return (String)this.attr.get(string);
    }

    public String getValue() {
        return this.getValue(null);
    }

    public String getValue(String string) {
        String string2;
        if (this.event == 1) {
            try {
                string2 = this.reader.getElementText();
            }
            catch (XMLStreamException xMLStreamException) {
                this.setError(xMLStreamException);
                return string;
            }
        } else {
            string2 = this.reader.getText();
        }
        return string2 == null ? string : string2;
    }

    public boolean hasAttributes() {
        return !this.attr.isEmpty();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        MLogger.debug("xml", "Reading \"%s\"...", file);
        FS.BufferedFileInput bufferedFileInput = null;
        try {
            bufferedFileInput = new FS.BufferedFileInput(file);
            this.read(bufferedFileInput);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileInput);
            throw throwable;
        }
        FS.close(bufferedFileInput);
    }

    public void read(InputStream inputStream) throws IOException {
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
            this.reader = xMLInputFactory.createXMLStreamReader(inputStream);
            while (!this.cancelled && this.reader.hasNext()) {
                this.event = this.reader.next();
                if (this.onEvent()) continue;
                switch (this.event) {
                    case 4: {
                        this.onText();
                        break;
                    }
                    case 2: {
                        this.onEnd(this.reader.getLocalName());
                        this.attr.clear();
                        break;
                    }
                    case 1: {
                        this.attr.clear();
                        int n = this.reader.getAttributeCount();
                        if (n > 0) {
                            for (int i = 0; i < n; ++i) {
                                this.attr.put(this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
                            }
                        }
                        this.onStart(this.reader.getLocalName());
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException(xMLStreamException);
        }
        finally {
            FS.close(this);
        }
    }

    public void read(String string) throws IOException {
        this.read(new File(string));
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new IOException(xMLStreamException);
            }
        }
    }

    protected void setError(Throwable throwable) {
        this.error = throwable;
    }

    protected void onEnd(String string) {
    }

    protected boolean onEvent() {
        return false;
    }

    protected void onStart(String string) {
    }

    protected void onText() {
    }

    public static final class Attributes
    extends HashMap<String, String> {
    }
}

