/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import edu.umd.cs.findbugs.annotation.SuppressWarnings;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.plaf.synth.SynthLookAndFeel;
import makagiga.commons.DropShadowBorder;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.ConfigEntry;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.FontProperty;
import org.makagiga.commons.Gettext;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.Item;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MNotification;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MainView;
import org.makagiga.commons.OS;
import org.makagiga.commons.PlatformConfig;
import org.makagiga.commons.Property;
import org.makagiga.commons.SimpleButtonUI;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.style.Style;

public final class UI
implements SwingConstants {
    @ConfigEntry(value="UI.animations")
    public static final BooleanProperty animations = new BooleanProperty(true);
    @ConfigEntry(value="UI.buttonIcons")
    @PlatformConfig
    public static final BooleanProperty buttonIcons = new BooleanProperty(true);
    @Deprecated
    public static final BooleanProperty decorated = new BooleanProperty();
    @Deprecated
    public static final BooleanProperty forceTextAA = new BooleanProperty(true);
    @ConfigEntry(value="Hack.nimbus")
    public static final BooleanProperty hackNimbus = new BooleanProperty(true);
    @ConfigEntry(value="Hack.showTrayToolTip")
    @PlatformConfig
    public static final BooleanProperty hackShowTrayToolTip = new BooleanProperty();
    @ConfigEntry(value="Hack.substance")
    @Deprecated
    public static final BooleanProperty hackSubstance = new BooleanProperty(true);
    @ConfigEntry(value="Hack.windowSize")
    public static final BooleanProperty hackWindowSize = new BooleanProperty(true);
    @ConfigEntry(value="UI.customFont")
    @PlatformConfig
    public static final FontProperty customFont = new FontProperty();
    @ConfigEntry(value="UI.hideMainWindowInTray")
    public static final BooleanProperty hideMainWindowInTray = new BooleanProperty();
    @Deprecated
    public static final BooleanProperty hollywood = new BooleanProperty();
    @ConfigEntry(value="UI.iconSize")
    public static final IntegerProperty iconSize = new IntegerProperty(24);
    @ConfigEntry(value="UI.mouseGestures")
    public static final BooleanProperty mouseGestures = new BooleanProperty(true);
    @ConfigEntry(value="UI.notificationType")
    @PlatformConfig
    public static final EnumProperty<MNotification.Type> notificationType = EnumProperty.create(MNotification.Type.POPUP, MNotification.Type.class);
    @Deprecated
    public static final BooleanProperty singleClickOpen = new BooleanProperty(true);
    @Deprecated
    public static final BooleanProperty specialEffects = new BooleanProperty(true);
    @Deprecated
    public static final BooleanProperty reverseOKCancel = new BooleanProperty();
    @ConfigEntry(value="UI.okCancelLayout")
    @PlatformConfig
    public static final EnumProperty<OKCancelLayout> okCancelLayout = EnumProperty.create(OKCancelLayout.AUTO, OKCancelLayout.class);
    @ConfigEntry(value="UI.systemTray")
    public static final BooleanProperty systemTray = new BooleanProperty(false);
    @ConfigEntry(value="UI.toolBarTextPosition")
    public static final EnumProperty<MToolBar.TextPosition> toolBarTextPosition = EnumProperty.create(MToolBar.TextPosition.UNDER_ICONS, MToolBar.TextPosition.class);
    @Deprecated
    public static final BooleanProperty toolTips = new BooleanProperty(false);
    @ConfigEntry(value="UI.useCustomFont")
    @PlatformConfig
    public static final BooleanProperty useCustomFont = new BooleanProperty();
    @ConfigEntry(value="UI.web")
    public static final BooleanProperty web = new BooleanProperty();
    @Deprecated
    public static final BooleanProperty notificationAlwaysOnTop = new BooleanProperty(true);
    @ConfigEntry(value="UI.notificationSnapRight")
    @PlatformConfig
    public static final EnumProperty<HorizontalPosition> horizontalNotificationPosition = EnumProperty.create(HorizontalPosition.RIGHT, HorizontalPosition.class);
    @ConfigEntry(value="UI.notificationSnapBottom")
    @PlatformConfig
    public static final EnumProperty<VerticalPosition> verticalNotificationPosition = EnumProperty.create(VerticalPosition.BOTTOM, VerticalPosition.class);
    @ConfigEntry(value="UI.notificationX")
    @PlatformConfig
    public static final IntegerProperty notificationX = new IntegerProperty(-1);
    @ConfigEntry(value="UI.notificationY")
    @PlatformConfig
    public static final IntegerProperty notificationY = new IntegerProperty(-1);
    @ConfigEntry(value="UI.notificationTransparent")
    @PlatformConfig
    public static final BooleanProperty notificationTransparent = new BooleanProperty(true);
    @ConfigEntry(value="UI.statusBarTimeout")
    public static final IntegerProperty statusBarTimeout = new IntegerProperty(10);
    @ConfigEntry(value="UI.customColor")
    public static final ColorProperty customColor = new ColorProperty();
    @ConfigEntry(value="UI.useCustomColor")
    public static final BooleanProperty useCustomColor = new BooleanProperty();
    public static final Color INVISIBLE = new Color(255, 255, 255, 0);
    public static final Color TOOL_TIP_BACKGROUND_COLOR = new Color(0xFFFFDC);
    public static final Color TOOL_TIP_FOREGROUND_COLOR = Color.BLACK;
    public static final Color TRANSPARENT_BLACK = new Color(0, 0, 0, 127);
    public static final Color TRANSPARENT_GRAY = new Color(127, 127, 127, 127);
    public static final Color TRANSPARENT_WHITE = new Color(255, 255, 255, 127);
    public static final String DYNAMIC_TOOL_TIP_TEXT = "";
    private static final int SIZE_VARIANT_SUPPORTED = 1;
    private static final int HAS_ALTERNATE_LIST_ROW_COLOR = 2;
    private static final int HAS_ALTERNATE_TREE_ROW_COLOR = 4;
    private static final int HAS_ALTERNATE_TABLE_ROW_COLOR = 8;
    public static final int ESCAPE = 1;
    public static final int PAINT_TEXT_TRIM_LINES = 1;
    public static final String HTML_BEGIN = "<html><body>";
    public static final String HTML_END = "</body></html>";
    public static final String LEFT_POINTER = "\u25c4";
    public static final String RIGHT_POINTER = "\u25ba";
    public static final String TM = "\u2122";
    private static boolean synth;
    private static boolean textAAInitialized;
    private static Cursor invisibleCursor;
    private static Font _defaultFont;
    private static LookAndFeelType lookAndFeelType;
    private static Map<Object, Object> textAA;
    static final int BUTTON_SPACING = 15;
    private static Color oldControl;
    private static Color oldNimbusFocus;
    private static Color oldNimbusSelectionBackground;

    public static String _(String string) {
        return Gettext.translate(string);
    }

    public static String _(String string, Object ... objectArray) {
        return Gettext._(string, objectArray);
    }

    public static void addCenter(Container container, JComponent jComponent) {
        if (UI.needScrollPane(jComponent)) {
            container.add((Component)new MScrollPane(jComponent), "Center");
        } else {
            container.add((Component)jComponent, "Center");
        }
    }

    public static Font changeFontSize(Component component, int n) {
        return UI.changeFontSize(component, n, 4, 40);
    }

    public static Font changeFontSize(Component component, int n, int n2, int n3) {
        Font font = component.getFont();
        if (font == null) {
            return null;
        }
        if (n == 0) {
            return font;
        }
        int n4 = font.getSize() + n;
        if (n2 != -1) {
            n4 = Math.max(n4, n2);
        }
        if (n3 != -1) {
            n4 = Math.min(n4, n3);
        }
        Font font2 = font.deriveFont((float)n4);
        component.setFont(font2);
        return font2;
    }

    public static synchronized Font createDefaultFont() {
        if (_defaultFont == null) {
            _defaultFont = new Font("Dialog", 0, UI.getDefaultFontSize());
        }
        return _defaultFont;
    }

    public static Border createDropShadowBorder() {
        return new DropShadowBorder();
    }

    public static Border createEmptyBorder(int n) {
        return BorderFactory.createEmptyBorder(n, n, n, n);
    }

    public static List<Object> createGradient(Color color, Color color2) {
        return UI.createGradient(1.0f, 0.0f, color, color2);
    }

    public static List<Object> createGradient(float f, float f2, Color color, Color color2) {
        return new MArrayList<Object>(Float.valueOf(f), Float.valueOf(f2), new ColorUIResource(color), new ColorUIResource(color2), new ColorUIResource(color));
    }

    public static Insets createInsets(int n) {
        return new Insets(n, n, n, n);
    }

    public static Font createMonospacedFont(int n) {
        String string = OS.isWindows() ? "Consolas" : "DejaVu Sans Mono";
        Font font = new Font(string, 0, n);
        if (font.getFamily().equals("Dialog")) {
            return new Font("Monospaced", 0, n);
        }
        return font;
    }

    @Deprecated
    public static void focus(Component component) {
        if (component instanceof Focusable) {
            ((Focusable)Focusable.class.cast(component)).focus();
        } else {
            component.requestFocusInWindow();
        }
    }

    public static <T extends Container> T getAncestorOfClass(Class<T> clazz, Component component) {
        return (T)SwingUtilities.getAncestorOfClass(clazz, component);
    }

    public static double getAutoScale(Image image, Dimension dimension) {
        return UI.getAutoScale(new Dimension(image.getWidth(null), image.getHeight(null)), dimension);
    }

    public static double getAutoScale(Dimension dimension, Dimension dimension2) {
        double d = dimension.width > dimension2.width ? (double)dimension2.width / (double)dimension.width : 1.0;
        int n = (int)((double)dimension.height * d);
        if (n > dimension2.height) {
            d *= (double)dimension2.height / (double)n;
        }
        return d;
    }

    public static Color getBackground(Component component) {
        Color color = component.getBackground();
        return color == null ? Color.WHITE : color;
    }

    public static Color getForeground(Component component) {
        Color color = component.getForeground();
        return color == null ? Color.BLACK : color;
    }

    public static Color getBrighter(Color color, Color color2) {
        return UI.getBrighter(color, 25, color2);
    }

    public static Color getBrighter(Color color, int n, Color color2) {
        return color == null ? color2 : MColor.getBrighter(color, n);
    }

    public static <T> T getClientProperty(JComponent jComponent, String string, T t) {
        Object object = jComponent.getClientProperty(string);
        return (T)(object == null ? t : object);
    }

    public static Color getColor(String string) {
        return UIManager.getColor(string);
    }

    public static Color getColor(Color color, float f, Color color2) {
        return color == null ? color2 : MColor.deriveColor(color, f);
    }

    public static Color getDarker(Color color, Color color2) {
        return color == null ? color2 : MColor.getDarker(color);
    }

    public static int getDefaultFontSize() {
        return 12;
    }

    public static Font getFont(Component component) {
        Font font = component.getFont();
        return font != null ? font : UI.createDefaultFont();
    }

    public static synchronized Cursor getInvisibleCursor() {
        if (invisibleCursor == null) {
            invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(UI.createCompatibleImage(1, 1, true), new Point(), "invisible");
        }
        return invisibleCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LookAndFeelType getLookAndFeelType() {
        Class<UI> clazz = UI.class;
        synchronized (UI.class) {
            if (lookAndFeelType == null) {
                String string;
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                synth = lookAndFeel instanceof SynthLookAndFeel;
                String string2 = string = lookAndFeel == null ? null : lookAndFeel.getClass().getName();
                lookAndFeelType = string == null ? LookAndFeelType.UNKNOWN : ("com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(string) ? LookAndFeelType.GTK : ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(string) || "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel".equals(string) ? LookAndFeelType.WINDOWS : (UI.getNimbusClass().equals(string) || lookAndFeel != null && "Nimbus".equals(lookAndFeel.getName()) ? LookAndFeelType.NIMBUS : (lookAndFeel instanceof MetalLookAndFeel && MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme ? LookAndFeelType.METAL : ("apple.laf.AquaLookAndFeel".equals(string) || "com.apple.laf.AquaLookAndFeel".equals(string) || "com.apple.mrj.swing.MacLookAndFeel".equals(string) ? LookAndFeelType.MAC : ("a03.swing.plaf.A03LookAndFeel".equals(string) ? LookAndFeelType.A03 : ("ch.randelshofer.quaqua.QuaquaLookAndFeel".equals(string) ? LookAndFeelType.QUAQUA : ("com.lipstikLF.LipstikLookAndFeel".equals(string) ? LookAndFeelType.LIPSTIK : ("com.seaglasslookandfeel.SeaGlassLookAndFeel".equals(string) ? LookAndFeelType.SEA_GLASS : (string.startsWith("org.jvnet.substance.") || lookAndFeel != null && lookAndFeel.getName().startsWith("Substance ") ? LookAndFeelType.SUBSTANCE : ("org.makagiga.retro.RetroLookAndFeel".equals(string) ? LookAndFeelType.RETRO : LookAndFeelType.UNKNOWN)))))))))));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return lookAndFeelType;
        }
    }

    public static String getPreferredLookAndFeelClassName() {
        String string = UIManager.getSystemLookAndFeelClassName();
        if (UI.isBlacklisted(string) || "com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(string)) {
            string = "javax.swing.plaf.metal.MetalLookAndFeel";
        }
        if ("javax.swing.plaf.metal.MetalLookAndFeel".equals(string) && UI.isNimbusLookAndFeelAvailable()) {
            string = UI.getNimbusClass();
        }
        return string;
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static ButtonUI getSimpleButtonUI() {
        return LazySimpleButtonUIHolder.INSTANCE;
    }

    @Deprecated
    public static Dimension getWindowSize(WindowSize windowSize) {
        return windowSize.getDimension();
    }

    public static ButtonGroup group(AbstractButton ... abstractButtonArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (AbstractButton abstractButton : abstractButtonArray) {
            if (abstractButton == null) continue;
            buttonGroup.add(abstractButton);
        }
        return buttonGroup;
    }

    public static void hideToolTip(JComponent jComponent) {
        Action action;
        ActionMap actionMap = jComponent.getActionMap();
        if (actionMap != null && (action = actionMap.get("hideTip")) != null) {
            MAction.fire(action, (Object)jComponent);
        }
    }

    public static AWTEventListener installFocusEventDebug() {
        AWTEventListener aWTEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('\n').append("FocusEvent:\n");
                Component component = focusEvent.getComponent();
                if (component != null) {
                    stringBuilder.append("\t         Component: ").append(component.getClass().getName()).append('\n');
                }
                if ((component = focusEvent.getOppositeComponent()) != null) {
                    stringBuilder.append("\tOpposite Component: ").append(component.getClass().getName()).append('\n');
                }
                MLogger.debug("core", stringBuilder.toString());
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, 4L);
        return aWTEventListener;
    }

    public static <T> T invokeAndWait(final Callable<T> callable) throws Exception {
        if (EventQueue.isDispatchThread()) {
            return callable.call();
        }
        final Property property = new Property();
        final Property property2 = new Property();
        EventQueue.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    property2.set(callable.call());
                }
                catch (Exception exception) {
                    property.set(exception);
                }
            }
        });
        if (!property.isNull()) {
            throw (Exception)property.get();
        }
        return property2.get();
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeAndWait(runnable);
        }
    }

    public static void invokeLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static boolean isA03() {
        return UI.getLookAndFeelType() == LookAndFeelType.A03;
    }

    public static boolean isBlacklisted(String string) {
        return "com.sun.java.swing.plaf.motif.MotifLookAndFeel".equals(string);
    }

    public static boolean isLipstik() {
        return UI.getLookAndFeelType() == LookAndFeelType.LIPSTIK;
    }

    public static boolean isMac() {
        return UI.getLookAndFeelType() == LookAndFeelType.MAC;
    }

    public static boolean isNimbus() {
        return UI.getLookAndFeelType() == LookAndFeelType.NIMBUS;
    }

    public static boolean isNimbusLookAndFeelAvailable() {
        return OS.getJavaVersion() > 1.6f || OS.getJavaUpdate() >= 10;
    }

    public static boolean isQuaqua() {
        return UI.getLookAndFeelType() == LookAndFeelType.QUAQUA;
    }

    public static boolean isRTL(Component component) {
        return component.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT;
    }

    @Deprecated
    public static boolean isSizeVariantSupported() {
        return UI.getLookAndFeelType().isSizeVariantSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSynth() {
        UI.getLookAndFeelType();
        Class<UI> clazz = UI.class;
        synchronized (UI.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return synth;
        }
    }

    public static void paintFocus(Component component, Graphics2D graphics2D, int n) {
        int n2 = component.getWidth();
        int n3 = component.getHeight();
        Color color = component.getForeground();
        if (color == null) {
            color = Color.BLACK;
        }
        graphics2D.setColor(MColor.deriveAlpha(color, 127));
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.0f, 2, 1));
        graphics2D.drawRect(n, n, n2 - n - 2, n3 - n - 2);
        graphics2D.setStroke(stroke);
    }

    @Deprecated
    public static void replaceComponent(Container container, Component component, Component component2, Object object) {
        UI.replaceComponent(container, component, component2, object, true);
    }

    public static void replaceComponent(Container container, Component component, Component component2, Object object, boolean bl) {
        MComponent.replace(container, component, component2, object, bl);
    }

    public static Dimension setFixedSize(Component component, int n, int n2) {
        return MComponent.setFixedSize(component, n, n2);
    }

    public static void setHTMLEnabled(JComponent jComponent, boolean bl) {
        jComponent.putClientProperty("html.disable", bl ? null : Boolean.valueOf(true));
    }

    public static void setStyle(String string, Component ... componentArray) {
        if (TK.isEmpty(string)) {
            return;
        }
        try {
            Style style = new Style(componentArray[0].getFont(), string);
            for (Component component : componentArray) {
                style.apply(component);
            }
        }
        catch (ParseException parseException) {
            MLogger.exception(parseException);
        }
    }

    public static int getTypeForImageFormat(String string) {
        if (string == null) {
            return 2;
        }
        if (string.equalsIgnoreCase("BMP")) {
            return 5;
        }
        if (string.equalsIgnoreCase("JPG")) {
            return 1;
        }
        return 2;
    }

    public static Color getXorColor(Color color) {
        if (color == null) {
            return null;
        }
        return new Color(color.getRGB() ^ 0xFFFFFF);
    }

    public static void init() {
        Object object;
        Object object2;
        MLogger.debug("ui", "Current look and feel: %s", new Object[]{UI.getLookAndFeelType()});
        Item.sharedRenderer = null;
        MRenderer._instance = null;
        UIDefaults uIDefaults = UIManager.getDefaults();
        if (((Boolean)useCustomFont.get()).booleanValue()) {
            object2 = customFont.get();
            if (((Font)object2).getSize() < 8) {
                object2 = ((Font)object2).deriveFont(8.0f);
            } else if (((Font)object2).getSize() > 32) {
                object2 = ((Font)object2).deriveFont(32.0f);
            }
            for (Map.Entry object3 : uIDefaults.entrySet()) {
                object = object3.getKey().toString();
                if (!((String)object).endsWith(".font") && !((String)object).endsWith(".acceleratorFont")) continue;
                uIDefaults.put(object, object2);
            }
        }
        object2 = buttonIcons.booleanValue() ? MActionInfo.CANCEL.getIcon() : null;
        Icon icon = buttonIcons.booleanValue() ? MActionInfo.OK.getIcon() : null;
        uIDefaults.put("OptionPane.cancelButtonText", MActionInfo.CANCEL.getText());
        uIDefaults.put("OptionPane.cancelIcon", object2);
        uIDefaults.put("OptionPane.errorIcon", MIcon.stock("ui/error"));
        uIDefaults.put("OptionPane.informationIcon", MIcon.stock("ui/info"));
        uIDefaults.put("OptionPane.noIcon", object2);
        uIDefaults.put("OptionPane.okButtonText", MActionInfo.OK.getText());
        uIDefaults.put("OptionPane.okIcon", icon);
        uIDefaults.put("OptionPane.questionIcon", MIcon.stock("ui/question"));
        uIDefaults.put("OptionPane.yesIcon", icon);
        uIDefaults.put("OptionPane.warningIcon", MIcon.stock("ui/warning"));
        uIDefaults.put("OptionPane.buttonOrientation", (Object)4);
        uIDefaults.put("OptionPane.buttonPadding", (Object)15);
        uIDefaults.put("OptionPane.sameSizeButtons", (Object)true);
        OKCancelLayout.setupUI(uIDefaults);
        uIDefaults.put("Slider.paintValue", (Object)false);
        if (UI.isGTK()) {
            uIDefaults.put("ComboBox.squareButton", (Object)false);
        } else if (UI.isMetal()) {
            ColorUIResource colorUIResource;
            ColorUIResource colorUIResource2;
            uIDefaults.put("swing.boldMetal", (Object)false);
            List<Object> list = UI.createGradient(new Color(14543091), Color.WHITE);
            uIDefaults.put("Button.gradient", list);
            uIDefaults.put("MenuBar.gradient", list);
            uIDefaults.put("Slider.gradient", list);
            uIDefaults.put("Slider.focusGradient", list);
            uIDefaults.put("ScrollBar.gradient", list);
            uIDefaults.put("RadioButton.gradient", list);
            uIDefaults.put("RadioButtonMenuItem.gradient", list);
            uIDefaults.put("ToggleButton.gradient", list);
            uIDefaults.put("CheckBoxMenuItem.background", Color.WHITE);
            uIDefaults.put("Menu.background", Color.WHITE);
            uIDefaults.put("MenuItem.background", Color.WHITE);
            uIDefaults.put("PopupMenu.background", Color.WHITE);
            uIDefaults.put("RadioButtonMenuItem.background", Color.WHITE);
            uIDefaults.put("Separator.background", Color.WHITE);
            if (UI.isNativeLAF()) {
                colorUIResource2 = new ColorUIResource(SystemColor.info);
                colorUIResource = new ColorUIResource(SystemColor.infoText);
                object = new BorderUIResource.LineBorderUIResource(colorUIResource, 1);
            } else {
                colorUIResource2 = new ColorUIResource(TOOL_TIP_BACKGROUND_COLOR);
                colorUIResource = new ColorUIResource(TOOL_TIP_FOREGROUND_COLOR);
                object = BorderUIResource.getBlackLineBorderUIResource();
            }
            uIDefaults.put("ToolTip.background", colorUIResource2);
            uIDefaults.put("ToolTip.backgroundInactive", colorUIResource2);
            uIDefaults.put("ToolTip.foreground", colorUIResource);
            uIDefaults.put("ToolTip.foregroundInactive", colorUIResource);
            uIDefaults.put("ToolTip.border", object);
            uIDefaults.put("ToolTip.borderInactive", object);
            uIDefaults.put("TabbedPane.contentBorderInsets", UI.createInsets(1));
            uIDefaults.put("Tree.collapsedIcon", MIcon.small("ui/plus"));
            uIDefaults.put("Tree.expandedIcon", MIcon.small("ui/minus"));
            uIDefaults.put("Tree.leafIcon", (Object)null);
        } else if (UI.isSynth()) {
            uIDefaults.put("ScrollBar.allowsAbsolutePositioning", (Object)true);
        }
        if (((Boolean)useCustomColor.get()).booleanValue()) {
            UI.initCustomColor(uIDefaults);
        }
    }

    public static void initCustomColor(UIDefaults uIDefaults) {
        Color color = (Color)customColor.get();
        if (color == null) {
            return;
        }
        if (UI.isNimbus()) {
            if (oldControl == null) {
                oldControl = uIDefaults.getColor("control");
            }
            if (oldNimbusFocus == null) {
                oldNimbusFocus = uIDefaults.getColor("nimbusFocus");
            }
            if (oldNimbusSelectionBackground == null) {
                oldNimbusSelectionBackground = uIDefaults.getColor("nimbusSelectionBackground");
            }
            uIDefaults.put("nimbusBase", color);
            if (customColor.isDefaultValue()) {
                if (oldNimbusSelectionBackground != null) {
                    uIDefaults.put("nimbusSelectionBackground", oldNimbusSelectionBackground);
                }
                if (oldNimbusFocus != null) {
                    uIDefaults.put("nimbusFocus", oldNimbusFocus);
                }
                if (oldControl != null) {
                    uIDefaults.put("control", oldControl);
                }
            } else {
                uIDefaults.put("nimbusSelectionBackground", color);
                uIDefaults.put("nimbusFocus", MColor.getBrighter(color, 25));
                uIDefaults.put("control", MColor.getBrighter(color, 90));
            }
        }
    }

    public static boolean isEmpty(Image image) {
        return image == null || image.getWidth(null) < 1 || image.getHeight(null) < 1;
    }

    public static boolean isGTK() {
        return UI.getLookAndFeelType() == LookAndFeelType.GTK;
    }

    public static boolean isMetal() {
        return UI.getLookAndFeelType() == LookAndFeelType.METAL;
    }

    public static boolean isNativeLAF() {
        return OS.isMac() || OS.isWindows();
    }

    public static boolean isPopupTrigger(KeyEvent keyEvent) {
        if (TK.isKeyStroke(keyEvent, 525) || TK.isKeyStroke(keyEvent, 121, 1)) {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    public static boolean isRetro() {
        return UI.getLookAndFeelType() == LookAndFeelType.RETRO;
    }

    public static boolean isSeaGlass() {
        return UI.getLookAndFeelType() == LookAndFeelType.SEA_GLASS;
    }

    public static boolean isSubstance() {
        return UI.getLookAndFeelType() == LookAndFeelType.SUBSTANCE;
    }

    public static boolean isWindows() {
        return UI.getLookAndFeelType() == LookAndFeelType.WINDOWS;
    }

    public static String makeHTML(String string, int n) {
        String string2 = (n & 1) != 0 ? TK.escapeXML(string) : string;
        return HTML_BEGIN + string2 + HTML_END;
    }

    public static String makeHTML(String string) {
        return UI.makeHTML(string, 0);
    }

    @Deprecated
    public static void paintListText(Component component, Graphics graphics, String string, Color color, Color color2) {
        MList.paintListText(component, graphics, string, color, color2);
    }

    public static void paintRoundedBackground(JComponent jComponent, Graphics graphics) {
        if (jComponent.isBackgroundSet()) {
            UI.paintRoundedBackground(jComponent, graphics, jComponent.getBackground(), 9, UI.createInsets(0));
        }
    }

    public static void paintRoundedBackground(JComponent jComponent, Graphics graphics, Color color, int n, Insets insets) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(insets.left, insets.top, jComponent.getWidth() - (insets.left + insets.right), jComponent.getHeight() - (insets.top + insets.bottom), n, n);
        Object object = UI.setAntialiasing(graphics2D, true);
        graphics2D.fill(float_);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public static void paintText(int n, Graphics2D graphics2D, Rectangle rectangle, Color color, Color color2, String ... stringArray) {
        if (TK.isEmpty(stringArray)) {
            return;
        }
        Flags flags = new Flags(n);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        if (color != null) {
            graphics2D.setColor(color);
            int n3 = n2 * stringArray.length;
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, n3 + fontMetrics.getDescent());
        }
        Shape shape = graphics2D.getClip();
        int n4 = rectangle.y;
        graphics2D.setClip(rectangle);
        graphics2D.setColor(color2);
        for (String string : stringArray) {
            n4 += n2;
            if (flags.isSet(1L)) {
                graphics2D.drawString(string.trim(), rectangle.x + 4, n4);
            } else {
                graphics2D.drawString(string, rectangle.x + 4, n4);
            }
            if (n4 > rectangle.x + rectangle.height) break;
        }
        graphics2D.setClip(shape);
    }

    public static void requestFocus(Component component) {
        MComponent.requestFocus(component);
    }

    public static BufferedImage createCompatibleImage(Component component, Color color) {
        return MComponent.createScreenshot(component, color);
    }

    public static BufferedImage createCompatibleImage(int n, int n2, boolean bl) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        if (bl) {
            return graphicsConfiguration.createCompatibleImage(n, n2, 3);
        }
        return graphicsConfiguration.createCompatibleImage(n, n2);
    }

    public static VolatileImage createCompatibleVolatileImage(int n, int n2, int n3) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return graphicsConfiguration.createCompatibleVolatileImage(n, n2, n3);
    }

    public static Image scaleImage(Image image, int n, int n2, Quality quality) {
        float f;
        if (n < 0 && n2 < 0) {
            return image;
        }
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        if (n < 0) {
            f = (float)n2 / (float)n4;
            n = (int)((float)n3 * f);
        }
        if (n2 < 0) {
            f = (float)n / (float)n3;
            n2 = (int)((float)n4 * f);
        }
        if (n3 == n && n4 == n2) {
            return image;
        }
        switch (quality) {
            case LOW: {
                return UI.doScale(image, n, n2, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, true);
            }
            case MEDIUM: {
                return UI.doScale(image, n, n2, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
            }
            case HIGH: {
                if (n < n3 || n2 < n4) {
                    boolean bl = false;
                    float f2 = n3;
                    float f3 = n4;
                    Image image2 = null;
                    while (!bl) {
                        if (f2 > (float)n && (f2 /= 2.0f) < (float)n) {
                            f2 = n;
                        }
                        if (f3 > (float)n2 && (f3 /= 2.0f) < (float)n2) {
                            f3 = n2;
                        }
                        n3 = (int)f2;
                        n4 = (int)f3;
                        bl = n3 == n && n4 == n2;
                        image2 = UI.doScale(image2 != null ? image2 : image, n3, n4, RenderingHints.VALUE_INTERPOLATION_BILINEAR, bl);
                    }
                    return image2;
                }
                return UI.doScale(image, n, n2, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
            }
        }
        throw new WTFError(quality);
    }

    @SuppressWarnings(value="REC")
    public static boolean setAlpha(Window window, float f) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            method.invoke(null, window, Float.valueOf(f));
            return true;
        }
        catch (Exception exception) {
            if (OS.isMac() && window instanceof RootPaneContainer) {
                ((RootPaneContainer)RootPaneContainer.class.cast(window)).getRootPane().putClientProperty("Window.alpha", Float.valueOf(f));
                return true;
            }
            return false;
        }
    }

    @Deprecated
    @SuppressWarnings(value="REC")
    public static boolean setOpaque(Window window, boolean bl) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            method.invoke(null, window, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Object setAntialiasing(Graphics2D graphics2D, boolean bl) {
        RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
        Object object = graphics2D.getRenderingHint(key);
        graphics2D.setRenderingHint(key, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        return object;
    }

    public static void setHTMLHelp(JComponent jComponent, String string) {
        jComponent.setToolTipText(string == null ? null : UI.makeHTML(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLookAndFeel(LookAndFeel lookAndFeel) throws Exception {
        Class<UI> clazz = UI.class;
        synchronized (UI.class) {
            lookAndFeelType = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            MLogger.info("core", "Setting look and feel: %s", lookAndFeel.getName());
            UIManager.setLookAndFeel(lookAndFeel);
            UI.init();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLookAndFeel(String string) throws Exception {
        Class<UI> clazz = UI.class;
        synchronized (UI.class) {
            lookAndFeelType = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            MLogger.info("core", "Setting look and feel by class name: %s", string);
            UIManager.setLookAndFeel(string);
            UI.init();
            return;
        }
    }

    public static boolean setNimbusLookAndFeel() {
        try {
            UI.setLookAndFeel(UI.getNimbusClass());
            return true;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return false;
        }
    }

    @Deprecated
    public static boolean setSizeVariant(JComponent jComponent, SizeVariant sizeVariant) {
        sizeVariant.apply(jComponent);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTextAntialiasing(Graphics2D graphics2D, RenderingHints renderingHints) {
        if (renderingHints != null) {
            renderingHints.clear();
            for (Map.Entry object : graphics2D.getRenderingHints().entrySet()) {
                renderingHints.put(object.getKey(), object.getValue());
            }
        }
        Class<UI> clazz = UI.class;
        synchronized (UI.class) {
            if (!textAAInitialized) {
                textAAInitialized = true;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                UI.updateTextAA(toolkit);
                toolkit.addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        MLogger.debug("ui", "Text Antialiasing: Settings changed");
                        Class<UI> clazz = UI.class;
                        synchronized (UI.class) {
                            UI.updateTextAA(Toolkit.getDefaultToolkit());
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            if (textAA == null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                graphics2D.addRenderingHints(textAA);
            }
            return;
        }
    }

    @Deprecated
    public static Object setTextAntialiasing(Graphics2D graphics2D, boolean bl) {
        RenderingHints.Key key = RenderingHints.KEY_TEXT_ANTIALIASING;
        Object object = graphics2D.getRenderingHint(key);
        graphics2D.setRenderingHint(key, bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        return object;
    }

    public static void setWaitCursor(Component component, boolean bl) {
        component.setCursor(Cursor.getPredefinedCursor(bl ? 3 : 0));
    }

    public static void setWaitCursor(boolean bl) {
        Window window = MainView.getWindow();
        if (window != null) {
            UI.setWaitCursor(window, bl);
        }
    }

    public static void strikeThrough(Component component, Graphics graphics, String string) {
        UI.strikeThrough(component, graphics, MColor.deriveAlpha(Color.RED, 127), string);
    }

    public static void strikeThrough(Component component, Graphics graphics, Color color, String string) {
        if (TK.isEmpty(string)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        int n = component.getHeight() / 2;
        FontMetrics fontMetrics = graphics2D.getFontMetrics(component.getFont());
        int n2 = Math.min(component.getWidth() - 5, fontMetrics.stringWidth(string));
        graphics2D.drawLine(5, n, n2, n);
    }

    public static BufferedImage toBufferedImage(Icon icon) {
        BufferedImage bufferedImage = UI.createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), true);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image image, boolean bl) {
        if (bl && image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = UI.createCompatibleImage(image.getWidth(null), image.getHeight(null), true);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() {
        try {
            UI.setWaitCursor(true);
            for (Window window : Window.getWindows()) {
                SwingUtilities.updateComponentTreeUI(window);
            }
        }
        finally {
            UI.setWaitCursor(false);
        }
    }

    @Deprecated
    public static ButtonGroup updateVerticalPositionMenu(MMenu mMenu, VerticalPosition verticalPosition, MAction mAction, MAction mAction2) {
        mMenu.addTitle(UI._("Position"));
        return UI.group(mMenu.addRadioButton(mAction, verticalPosition == VerticalPosition.TOP), mMenu.addRadioButton(mAction2, verticalPosition == VerticalPosition.BOTTOM));
    }

    public static Window windowFor(Component component) {
        return SwingUtilities.getWindowAncestor(component);
    }

    private UI() {
    }

    private static BufferedImage doScale(Image image, int n, int n2, Object object, boolean bl) {
        BufferedImage bufferedImage = bl ? UI.createCompatibleImage(n, n2, true) : new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        graphics2D.drawImage(image, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static String getNimbusClass() {
        if (OS.getJavaVersion() > 1.6f) {
            return "javax.swing.plaf.nimbus.NimbusLookAndFeel";
        }
        return "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
    }

    private static void updateTextAA(Toolkit toolkit) {
        textAA = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
        if (textAA != null) {
            for (Map.Entry<Object, Object> entry : textAA.entrySet()) {
                MLogger.debug("ui", "Text Antialiasing: %s = %s", entry.getKey(), entry.getValue());
            }
        }
    }

    static boolean needScrollPane(JComponent jComponent) {
        return jComponent instanceof Scrollable && !(jComponent instanceof JScrollPane) && !(jComponent instanceof JTextField);
    }

    @Deprecated
    static interface ComponentExtensions {
    }

    private static final class LazySimpleButtonUIHolder {
        private static final SimpleButtonUI INSTANCE = new SimpleButtonUI();

        private LazySimpleButtonUIHolder() {
        }
    }

    public static class NimbusOverrides
    extends UIDefaults {
        public void install(JComponent jComponent, boolean bl) {
            jComponent.putClientProperty("Nimbus.Overrides.InheritDefaults", bl);
            jComponent.putClientProperty("Nimbus.Overrides", this);
        }
    }

    public static interface MouseWheelEventsControl {
        public boolean getMouseWheelEventsEnabled();

        public void setMouseWheelEventsEnabled(boolean var1);
    }

    public static interface EventsControl {
        public boolean getEventsEnabled();

        public void setEventsEnabled(boolean var1);
    }

    public static enum WindowSize {
        MEDIUM,
        LARGE,
        SCREEN;


        public Dimension getDimension() {
            Dimension dimension = new Dimension();
            Dimension dimension2 = UI.getScreenSize();
            switch (this) {
                case MEDIUM: {
                    dimension.width = (int)((float)dimension2.width / 1.6f);
                    dimension.height = (int)((float)dimension2.height / 1.6f);
                    break;
                }
                case LARGE: {
                    dimension.width = (int)((double)dimension2.width / 1.28);
                    dimension.height = (int)((double)dimension2.height / 1.28);
                    break;
                }
                case SCREEN: {
                    dimension.setSize(dimension2);
                    break;
                }
                default: {
                    throw new WTFError(this);
                }
            }
            return dimension;
        }

        public int getHeight() {
            return this.getDimension().height;
        }

        public int getWidth() {
            return this.getDimension().width;
        }
    }

    public static enum VerticalPosition {
        TOP,
        BOTTOM;

    }

    public static enum SizeVariant {
        NORMAL(null),
        MINI("mini"),
        SMALL("small"),
        LARGE("large");

        private final String value;

        public void apply(JComponent jComponent) {
            jComponent.putClientProperty("JComponent.sizeVariant", this.value);
        }

        public String toString() {
            return this.value;
        }

        private SizeVariant(String string2) {
            this.value = string2;
        }
    }

    public static enum LookAndFeelType {
        UNKNOWN(0),
        GTK(0),
        METAL(0),
        SUBSTANCE(0),
        WINDOWS(0),
        NIMBUS(1),
        LIPSTIK(0),
        A03(14),
        SEA_GLASS(1),
        RETRO(0),
        QUAQUA(0),
        MAC(1);

        private Flags flags;

        public boolean hasAlternateListRowColor() {
            return this.flags.isSet(2L);
        }

        public boolean hasAlternateTableRowColor() {
            return this.flags.isSet(8L);
        }

        public boolean hasAlternateTreeRowColor() {
            return this.flags.isSet(4L);
        }

        public boolean isSizeVariantSupported() {
            return this.flags.isSet(1L);
        }

        private LookAndFeelType(int n2) {
            this.flags = Flags.valueOf(n2);
        }
    }

    public static enum Quality {
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum OKCancelLayout {
        AUTO,
        OK_CANCEL,
        CANCEL_OK;


        public static OKCancelLayout getDefault() {
            if (OS.isGNOME() || OS.isMac() || OS.isXfce()) {
                return CANCEL_OK;
            }
            return OK_CANCEL;
        }

        public static boolean isReversed() {
            if (okCancelLayout.get() == AUTO) {
                return OKCancelLayout.getDefault() == CANCEL_OK;
            }
            return okCancelLayout.get() == CANCEL_OK;
        }

        public static void setupUI(UIDefaults uIDefaults) {
            uIDefaults.put("OptionPane.isYesLast", (Object)OKCancelLayout.isReversed());
        }

        public String toString() {
            switch (this) {
                case AUTO: {
                    return UI._("Auto");
                }
                case OK_CANCEL: {
                    return MActionInfo.OK.getText() + " - " + MActionInfo.CANCEL.getText();
                }
                case CANCEL_OK: {
                    return MActionInfo.CANCEL.getText() + " - " + MActionInfo.OK.getText();
                }
            }
            throw new WTFError(this);
        }
    }

    public static enum HorizontalPosition {
        LEFT,
        RIGHT;

    }
}

