/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.help;

import java.awt.Component;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.help.HelpContext;
import org.makagiga.commons.help.HelpSystem;

public final class Help {
    private static HelpSystem defaultHelpSystem;
    private static HelpSystem helpSystem;

    public static synchronized HelpSystem getHelpSystem() {
        return helpSystem;
    }

    public static synchronized void setHelpSystem(HelpSystem helpSystem) {
        Help.helpSystem = helpSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean show(Component component, HelpContext helpContext) {
        if (helpContext == null) {
            return false;
        }
        TK.checkNull(component, "source");
        Class<Help> clazz = Help.class;
        synchronized (Help.class) {
            HelpSystem helpSystem;
            if (Help.helpSystem == null) {
                if (defaultHelpSystem == null) {
                    defaultHelpSystem = new DefaultHelpSystem();
                }
                helpSystem = defaultHelpSystem;
            } else {
                helpSystem = Help.helpSystem;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            helpSystem.show(component, helpContext);
            return true;
        }
    }

    private Help() {
    }

    private static final class DefaultHelpSystem
    extends HelpSystem {
        private DefaultHelpSystem() {
        }

        @Override
        public void show(Component component, HelpContext helpContext) {
            if (helpContext.getType() == HelpContext.Type.URI) {
                MMainWindow.openURI(helpContext.getID());
            } else {
                MStatusBar.error(UI._("Could not display help for \"{0}\"", helpContext));
            }
        }
    }
}

