/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.icons;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.imageio.ImageIO;
import org.makagiga.commons.FS;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.icons.IconLoader;

public abstract class AbstractIconLoader
implements IconLoader {
    protected int baseSize;
    protected int smallSize;
    protected String name;

    public AbstractIconLoader(String string, int n, int n2) {
        this.name = string;
        this.baseSize = n;
        this.smallSize = n2;
    }

    @Override
    public int getBaseSize() {
        return this.baseSize;
    }

    public MIcon getExample(int n) {
        return this.load("ui/folder", n);
    }

    public String getID() {
        return this.name;
    }

    @Override
    public int getMediumSize() {
        return this.getSmallSize() + 8;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSmallSize() {
        return this.smallSize;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MIcon readIcon(final Class<?> clazz, String string, String string2) {
        if (string2 == null) {
            return null;
        }
        final StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('/').append(string2);
        String string3 = FS.getExtension(string2);
        if (string3 == null) {
            stringBuilder.append(".png");
        }
        try {
            BufferedImage bufferedImage;
            if ("gif".equals(string3)) {
                URL uRL = clazz.getResource(stringBuilder.toString());
                return uRL == null ? null : new MIcon(uRL);
            }
            SecurityManager securityManager = System.getSecurityManager();
            InputStream inputStream = securityManager == null ? clazz.getResourceAsStream(stringBuilder.toString()) : AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    return clazz.getResourceAsStream(stringBuilder.toString());
                }
            });
            if (inputStream == null) {
                return null;
            }
            boolean bl = ImageIO.getUseCache();
            try {
                if (bl) {
                    ImageIO.setUseCache(false);
                }
                bufferedImage = ImageIO.read(inputStream);
            }
            finally {
                if (bl) {
                    ImageIO.setUseCache(true);
                }
            }
            return bufferedImage == null ? null : new MIcon(bufferedImage);
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return null;
        }
    }
}

