/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.icons;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.util.CollectionMap;

public final class IconTheme {
    private static CollectionMap<String, String> aliases = new CollectionMap(CollectionMap.MapType.HASH_MAP, CollectionMap.CollectionType.ARRAY_LIST);
    private static Map<String, String> _toFreeDesktopMap;
    private static Map<String, String> _toMakagigaMap;
    private static final MLogger LOG;

    public static Map<String, List<String>> getAliases() {
        return aliases.getMap();
    }

    public static Map<String, String> getToFreeDesktopMap() {
        IconTheme.init();
        return _toFreeDesktopMap;
    }

    public static Map<String, String> getToMakagigaMap() {
        IconTheme.init();
        return _toMakagigaMap;
    }

    public static String toMakagiga(String string, String string2) {
        IconTheme.init();
        String string3 = string + "/" + string2;
        String string4 = _toMakagigaMap.get(string3);
        if (string4 == null) {
            LOG.warningFormat("No icon for \"%s\"", string3);
        }
        return string4;
    }

    private IconTheme() {
    }

    private static void add(String string, String string2) {
        _toFreeDesktopMap.put(string2, string);
        String string3 = _toMakagigaMap.get(string);
        if (string3 != null) {
            LOG.infoFormat("Creating alias for \"%s\": %s", string, string2);
            aliases.add(string, string2);
        } else {
            _toMakagigaMap.put(string, string2);
        }
    }

    private static void addAction(String string, String string2) {
        IconTheme.add("actions/" + string, string2);
    }

    private static void addApp(String string, String string2) {
        IconTheme.add("apps/" + string, string2);
    }

    private static void addCategory(String string, String string2) {
        IconTheme.add("categories/" + string, string2);
    }

    private static void addEmblem(String string, String string2) {
        IconTheme.add("emblems/" + string, string2);
    }

    private static void addEmote(String string, String string2) {
        IconTheme.add("emotes/" + string, string2);
    }

    private static void addMimetype(String string, String string2) {
        IconTheme.add("mimetypes/" + string, string2);
    }

    private static void addPlace(String string, String string2) {
        IconTheme.add("places/" + string, string2);
    }

    private static void addStatus(String string, String string2) {
        IconTheme.add("status/" + string, string2);
    }

    private static synchronized void init() {
        if (_toMakagigaMap != null) {
            return;
        }
        _toFreeDesktopMap = new HashMap<String, String>();
        _toMakagigaMap = new HashMap<String, String>();
        IconTheme.addAction("application-exit", "ui/quit");
        IconTheme.addAction("arrow-down", "ui/down");
        IconTheme.addAction("arrow-left", "ui/left");
        IconTheme.addAction("arrow-right", "ui/right");
        IconTheme.addAction("arrow-up", "ui/up");
        IconTheme.addAction("arrow-up-double", "ui/upload");
        IconTheme.addAction("bookmark-new", "ui/bookmark");
        IconTheme.addAction("download", "ui/download");
        IconTheme.addAction("draw-text", "ui/text");
        IconTheme.addAction("go-first-view", "ui/first");
        IconTheme.addAction("go-last-view", "ui/last");
        IconTheme.addAction("go-next", "ui/next");
        IconTheme.addAction("go-previous", "ui/previous");
        IconTheme.addAction("configure", "ui/configure");
        IconTheme.addAction("dashboard-show", "ui/desktop");
        IconTheme.addAction("dialog-cancel", "ui/cancel");
        IconTheme.addAction("dialog-close", "ui/close");
        IconTheme.addAction("dialog-ok", "ui/ok");
        IconTheme.addAction("dialog-ok-apply", "ui/apply");
        IconTheme.addAction("document-new", "ui/newfile");
        IconTheme.addAction("document-open", "ui/open");
        IconTheme.addAction("document-print", "ui/print");
        IconTheme.addAction("document-properties", "ui/properties");
        IconTheme.addAction("document-revert", "ui/revert");
        IconTheme.addAction("document-save", "ui/save");
        IconTheme.addAction("edit-clear-locationbar-ltr", "ui/clearright");
        IconTheme.addAction("edit-clear-locationbar-rtl", "ui/clearleft");
        IconTheme.addAction("edit-copy", "ui/copy");
        IconTheme.addAction("edit-cut", "ui/cut");
        IconTheme.addAction("edit-delete", "ui/delete");
        IconTheme.addAction("edit-find", "ui/find");
        IconTheme.addAction("edit-paste", "ui/paste");
        IconTheme.addAction("edit-redo", "ui/redo");
        IconTheme.addAction("edit-undo", "ui/undo");
        IconTheme.addAction("flag-black", "labels/flag-black");
        IconTheme.addAction("flag-blue", "labels/flag-blue");
        IconTheme.addAction("flag-green", "labels/flag-green");
        IconTheme.addAction("flag-red", "labels/flag-red");
        IconTheme.addAction("flag-yellow", "labels/flag-yellow");
        IconTheme.addAction("folder-new", "ui/newfolder");
        IconTheme.addAction("format-text-bold", "text/bold");
        IconTheme.addAction("format-text-italic", "text/italic");
        IconTheme.addAction("format-text-strikethrough", "text/strikethrough");
        IconTheme.addAction("format-text-underline", "text/underline");
        IconTheme.addAction("go-down-search", "ui/findnext");
        IconTheme.addAction("help-contents", "ui/help");
        IconTheme.addAction("media-playback-pause", "player/pause");
        IconTheme.addAction("media-playback-start", "player/start");
        IconTheme.addAction("object-flip-horizontal", "ui/fliphorizontal");
        IconTheme.addAction("object-flip-vertical", "ui/flipvertical");
        IconTheme.addAction("object-rotate-left", "ui/rotateleft");
        IconTheme.addAction("object-rotate-right", "ui/rotate");
        IconTheme.addAction("office-chart-pie", "ui/chart");
        IconTheme.addAction("process-stop", "ui/stop");
        IconTheme.addAction("rating", "ui/star");
        IconTheme.addAction("tools-check-spelling", "ui/checkspelling");
        IconTheme.addAction("tools-wizard", "ui/wizard");
        IconTheme.addAction("transform-crop", "crop");
        IconTheme.addAction("transform-scale", "ui/scale");
        IconTheme.addAction("view-calendar-tasks", "labels/todo");
        IconTheme.addAction("view-calendar-upcoming-events", "summary");
        IconTheme.addAction("view-conversation-balloon", "ui/conversation");
        IconTheme.addAction("view-file-columns", "ui/multicolumnview");
        IconTheme.addAction("view-fullscreen", "ui/fullscreen");
        IconTheme.addAction("view-grid", "ui/grid");
        IconTheme.addAction("view-list-text", "ui/detailedview");
        IconTheme.addAction("view-list-tree", "ui/tree");
        IconTheme.addAction("view-pim-calendar", "ui/calendar");
        IconTheme.addAction("view-presentation", "ui/presentation");
        IconTheme.addAction("view-refresh", "ui/refresh");
        IconTheme.addAction("zoom-in", "ui/zoomin");
        IconTheme.addAction("zoom-out", "ui/zoomout");
        IconTheme.addApp("accessories-text-editor", "notepad");
        IconTheme.addApp("preferences-desktop-font", "ui/font");
        IconTheme.addApp("preferences-desktop-locale", "ui/locale");
        IconTheme.addApp("preferences-plugin", "ui/plugin");
        IconTheme.addApp("utilities-terminal", "ui/console");
        IconTheme.addCategory("applications-internet", "ui/internet");
        IconTheme.addCategory("applications-system", "ui/misc");
        IconTheme.addCategory("system-help", "ui/question");
        IconTheme.addEmblem("emblem-favorite", "labels/valuable");
        IconTheme.addEmote("face-smile", "labels/emotion/happy");
        IconTheme.addMimetype("application-rss+xml", "ui/feed");
        IconTheme.addMimetype("image-x-generic", "ui/image");
        IconTheme.addMimetype("unknown", "labels/unknown");
        IconTheme.addMimetype("x-office-document", "ui/file");
        IconTheme.addPlace("folder", "ui/folder");
        IconTheme.addPlace("folder-cyan", "labels/folder-cyan");
        IconTheme.addPlace("folder-development", "labels/folder-development");
        IconTheme.addPlace("folder-downloads", "labels/folder-downloads");
        IconTheme.addPlace("folder-favorites", "labels/folder-favorites");
        IconTheme.addPlace("folder-green", "labels/folder-green");
        IconTheme.addPlace("folder-grey", "labels/folder-grey");
        IconTheme.addPlace("folder-image", "labels/folder-image");
        IconTheme.addPlace("folder-important", "labels/folder-important");
        IconTheme.addPlace("folder-locked", "labels/folder-locked");
        IconTheme.addPlace("folder-orange", "dynamicfolder");
        IconTheme.addPlace("folder-print", "labels/folder-print");
        IconTheme.addPlace("folder-red", "labels/folder-red");
        IconTheme.addPlace("folder-remote", "labels/folder-remote");
        IconTheme.addPlace("folder-sound", "labels/folder-sound");
        IconTheme.addPlace("folder-txt", "labels/folder-txt");
        IconTheme.addPlace("folder-violet", "labels/folder-violet");
        IconTheme.addPlace("folder-yellow", "labels/folder-yellow");
        IconTheme.addPlace("user-home", "ui/home");
        IconTheme.addPlace("user-trash", "emptytrashcan");
        IconTheme.addStatus("dialog-error", "ui/error");
        IconTheme.addStatus("dialog-information", "ui/info");
        IconTheme.addStatus("dialog-password", "ui/password");
        IconTheme.addStatus("dialog-warning", "ui/warning");
        IconTheme.addStatus("dialog-warning", "labels/important");
        IconTheme.addStatus("object-locked", "ui/locked");
        IconTheme.addStatus("object-unlocked", "ui/unlocked");
        IconTheme.addStatus("task-complete", "ui/complete");
        IconTheme.addStatus("user-trash-full", "fulltrashcan");
    }

    static {
        LOG = MLogger.get("icon-theme");
    }
}

