/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.io;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.makagiga.commons.TK;
import org.makagiga.commons.io.DataHeader;
import org.makagiga.commons.io.DataType;

public class MDataOutputStream
extends DataOutputStream {
    public MDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeArray(Object ... objectArray) throws IOException {
        TK.checkNull(objectArray);
        DataType.ARRAY.writeID(this);
        this.writeInt(objectArray.length);
        for (Object object : objectArray) {
            this.writeProperty(object);
        }
    }

    public void writeCollection(Collection<?> collection) throws IOException {
        TK.checkNull(collection);
        DataType.COLLECTION.writeID(this);
        this.writeInt(collection.size());
        for (Object obj : collection) {
            this.writeProperty(obj);
        }
    }

    public void writeHeader(DataHeader dataHeader) throws IOException {
        this.writePropertyMap(dataHeader);
    }

    public void writeProperty(Object object) throws IOException {
        if (object == null) {
            DataType.NULL.writeID(this);
        } else if (object instanceof Boolean) {
            DataType.BOOLEAN.writeID(this);
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            DataType.BYTE.writeID(this);
            this.writeByte(((Byte)object).byteValue());
        } else if (object instanceof Character) {
            DataType.CHARACTER.writeID(this);
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Double) {
            DataType.DOUBLE.writeID(this);
            this.writeDouble((Double)object);
        } else if (object instanceof Float) {
            DataType.FLOAT.writeID(this);
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Integer) {
            DataType.INTEGER.writeID(this);
            this.writeInt((Integer)object);
        } else if (object instanceof Long) {
            DataType.LONG.writeID(this);
            this.writeLong((Long)object);
        } else if (object instanceof Short) {
            DataType.SHORT.writeID(this);
            this.writeShort(((Short)object).shortValue());
        } else if (object instanceof String) {
            DataType.STRING.writeID(this);
            this.writeUTF((String)object);
        } else if (object instanceof byte[]) {
            DataType.BYTE_ARRAY.writeID(this);
            byte[] byArray = (byte[])object;
            this.writeInt(byArray.length);
            this.write(byArray);
        } else if (object instanceof Date) {
            DataType.DATE.writeID(this);
            this.writeLong(((Date)Date.class.cast(object)).getTime());
        } else if (object instanceof Color) {
            DataType.COLOR.writeID(this);
            Color color = (Color)object;
            this.writeByte(color.getRed());
            this.writeByte(color.getGreen());
            this.writeByte(color.getBlue());
            this.writeByte(color.getAlpha());
        } else {
            throw new IOException("Unsupported property type: " + object + " (" + object.getClass().getName() + ")");
        }
    }

    public void writeProperty(String string, Object object) throws IOException {
        this.writeUTF(TK.checkNull(string));
        this.writeProperty(object);
    }

    public void writePropertyMap(Map<String, ?> map) throws IOException {
        TK.checkNull(map);
        DataType.MAP.writeID(this);
        this.writeInt(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.writeProperty(entry.getKey(), entry.getValue());
        }
    }
}

