/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.painters;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.AbstractPainter;

public class LinearGradientPainter
extends AbstractPainter {
    private Color secondaryColor;
    private float primaryColorFactor;
    private float secondaryColorFactor;

    public LinearGradientPainter(Color color, Color color2) {
        super(color, null);
        this.cache = new AbstractPainter.Cache();
        this.setSecondaryColor(color2);
    }

    public LinearGradientPainter(float f, float f2) {
        super(null, null);
        this.primaryColorFactor = f;
        this.secondaryColorFactor = f2;
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public void setSecondaryColor(Color color) {
        if (TK.isChange(this.secondaryColor, color)) {
            this.secondaryColor = color;
            this.cache.invalidate();
        }
    }

    @Override
    public void paint(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Color color;
        if (this.cache.paint(this, component, graphics2D, n, n2, n3, n4)) {
            return;
        }
        Color color2 = this.getPrimaryColor();
        if (color2 == null) {
            color2 = UI.getColor(component.getBackground(), this.primaryColorFactor, Color.WHITE);
        }
        if ((color = this.getSecondaryColor()) == null) {
            color = UI.getColor(component.getBackground(), this.secondaryColorFactor, Color.WHITE);
        }
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(n, n2, n, component.getHeight() + n2 - 1, new float[]{0.3f, 0.7f}, new Color[]{color2, color});
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fillRect(n, n2, n3, n4);
    }
}

