/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.print;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.print.PrinterException;
import javax.swing.AbstractButton;
import javax.swing.JTable;
import org.makagiga.commons.Config;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MFileChooser;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRadioButton;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.print.PrintInfo;
import org.makagiga.commons.print.PrintPreviewPanel;

public class PrintDialog
extends MDialog {
    private JTable table;
    private MCheckBox printFooter;
    private MCheckBox printHeader;
    private MRadioButton fitWidthTablePrintMode;
    private MRadioButton normalTablePrintMode;
    private PrintInfo printInfo;
    private PrintInfo.PrintResult printResult = PrintInfo.PrintResult.UNKNOWN;
    private PrintPreviewPanel printPreview;

    public PrintDialog(Window window, PrintInfo printInfo) {
        super(window, UI._("\"{0}\" - Print Preview", TK.centerSqueeze(printInfo.getPrintTitle())), "ui/print", 199);
        this.printInfo = printInfo;
        if (printInfo.getPrintComponent() instanceof JTable) {
            this.table = (JTable)printInfo.getPrintComponent();
        }
        printInfo.beforePrint();
        this.changeButton((AbstractButton)this.getOKButton(), MActionInfo.CONTINUE);
        Config config = Config.getDefault();
        Dimension dimension = UI.WindowSize.LARGE.getDimension();
        Dimension dimension2 = UI.WindowSize.MEDIUM.getDimension();
        this.setSize(config.readInt("PrintPreview.width", dimension.width, dimension2.width), config.readInt("PrintPreview.height", dimension.height, dimension2.height));
        this.printPreview = new PrintPreviewPanel(printInfo);
        this.printPreview.orientation = config.readInt("PrintPreview.orientation", 1);
        this.addCenter(this.printPreview);
        MPanel mPanel = this.getButtonsPanel();
        mPanel.addSeparator(UI._("Page"));
        mPanel.add(this.printPreview.getPagePanel());
        mPanel.addSeparator(UI._("Options"));
        this.createComponents(mPanel);
        this.updatePreview();
    }

    public static PrintInfo.PrintResult printDocument(PrintInfo printInfo, Flags flags) {
        PrintInfo.PrintResult printResult;
        try {
            printResult = printInfo.printDocument(flags);
            PrintDialog.showMessage(printResult);
        }
        catch (PrinterException printerException) {
            printResult = PrintInfo.PrintResult.ERROR;
            PrintDialog.showMessage(printResult, printerException);
        }
        return printResult;
    }

    public static void showMessage(PrintInfo.PrintResult printResult) {
        PrintDialog.showMessage(printResult, null);
    }

    public static void showMessage(PrintInfo.PrintResult printResult, Throwable throwable) {
        switch (printResult) {
            case CANCELLED: {
                if (throwable != null) {
                    MLogger.exception(throwable);
                }
                MStatusBar.error(UI._("Printing cancelled"));
                break;
            }
            case ERROR: {
                MMessage.error(null, throwable, UI._("Print failed"));
                break;
            }
            case IN_PROGRESS: {
                if (throwable != null) {
                    MLogger.exception(throwable);
                }
                MStatusBar.info(UI._("Printing in progress"));
                break;
            }
            case COMPLETE: {
                if (throwable != null) {
                    MLogger.exception(throwable);
                }
                MStatusBar.info(UI._("Printing complete"));
                break;
            }
        }
    }

    public void updatePreview() {
        this.printPreview.flags = this.getPrintFlags();
        this.printPreview.refresh(true);
    }

    @Override
    protected boolean onAccept() {
        MFileChooser.init();
        Config config = Config.getDefault();
        if (this.printFooter.isEnabled()) {
            config.write("Print.footer", this.printFooter.isSelected());
        }
        if (this.printHeader.isEnabled()) {
            config.write("Print.header", this.printHeader.isSelected());
        }
        config.write("PrintPreview.orientation", this.getSelectedOrientation());
        if (this.fitWidthTablePrintMode != null) {
            config.write("Print.tablePrintMode", this.fitWidthTablePrintMode.isSelected() ? JTable.PrintMode.FIT_WIDTH.toString() : JTable.PrintMode.NORMAL.toString());
        }
        config.sync();
        this.printPreview.shutdown();
        this.printResult = PrintDialog.printDocument(this.printInfo, this.getPrintFlags());
        return true;
    }

    @Override
    protected void onClose() {
        if (this.printPreview != null) {
            this.printPreview.dispose();
            this.printPreview = null;
        }
        Config config = Config.getDefault();
        config.write("PrintPreview", this.getSize());
        config.sync();
        this.printInfo.afterPrint(this.printResult);
        this.printInfo = TK.dispose(this.printInfo);
    }

    private void createComponents(MPanel mPanel) {
        Config config = Config.getDefault();
        MRadioButton mRadioButton = new MRadioButton(UI._("Portrait")){

            @Override
            protected void onClick() {
                PrintDialog.this.setPageFormat(1);
            }
        };
        mRadioButton.setSelected(this.printPreview.orientation == 1);
        mRadioButton.setToolTipText(UI._("Orientation"));
        mPanel.add(mRadioButton);
        MRadioButton mRadioButton2 = new MRadioButton(UI._("Landscape")){

            @Override
            protected void onClick() {
                PrintDialog.this.setPageFormat(0);
            }
        };
        mRadioButton2.setSelected(this.printPreview.orientation == 0);
        mRadioButton2.setToolTipText(UI._("Orientation"));
        mPanel.add(mRadioButton2);
        UI.group(mRadioButton, mRadioButton2);
        mPanel.addGap();
        Flags flags = new Flags(this.printInfo.getPrintingCapabilities());
        this.printHeader = new MCheckBox(UI._("Print Header")){

            @Override
            protected void onClick() {
                PrintDialog.this.updatePreview();
                MScrollPane.scrollToTop(((PrintDialog)PrintDialog.this).printPreview.preview, false);
            }
        };
        this.printHeader.setToolTipText(UI._("Select this option to print page number and title."));
        if (flags.isSet(8L)) {
            this.printHeader.setSelected(config.read("Print.header", true));
        } else {
            this.printHeader.setEnabled(false);
        }
        mPanel.add(this.printHeader);
        this.printFooter = new MCheckBox(UI._("Print Footer")){

            @Override
            protected void onClick() {
                PrintDialog.this.updatePreview();
                MScrollPane.scrollToBottom(((PrintDialog)PrintDialog.this).printPreview.preview, false);
            }
        };
        this.printFooter.setToolTipText(UI._("Select this option to print current date and time."));
        if (flags.isSet(4L)) {
            this.printFooter.setSelected(config.read("Print.footer", true));
        } else {
            this.printFooter.setEnabled(false);
        }
        mPanel.add(this.printFooter);
        if (this.table != null) {
            mPanel.addSeparator(UI._("Table"));
            this.fitWidthTablePrintMode = new MRadioButton(UI._("Fit Width"));
            this.fitWidthTablePrintMode.onClick(this, "updatePreview");
            UI.setHTMLHelp(this.fitWidthTablePrintMode, UI._("Printing mode that scales the output smaller,<br>if necessary, to fit the table's entire width on each page."));
            mPanel.add(this.fitWidthTablePrintMode);
            this.normalTablePrintMode = new MRadioButton(UI._("Normal"));
            this.normalTablePrintMode.onClick(this, "updatePreview");
            UI.setHTMLHelp(this.normalTablePrintMode, UI._("Printing mode that prints the table at its current size,<br>spreading both columns and rows across multiple pages if necessary."));
            mPanel.add(this.normalTablePrintMode);
            UI.group(this.fitWidthTablePrintMode, this.normalTablePrintMode);
            JTable.PrintMode printMode = EnumProperty.parse(config.read("Print.tablePrintMode", null), JTable.PrintMode.FIT_WIDTH);
            switch (printMode) {
                case FIT_WIDTH: {
                    this.fitWidthTablePrintMode.setSelected(true);
                    break;
                }
                case NORMAL: {
                    this.normalTablePrintMode.setSelected(true);
                    break;
                }
                default: {
                    throw new WTFError(printMode);
                }
            }
        }
    }

    private Flags getPrintFlags() {
        long l = 0L;
        if (this.fitWidthTablePrintMode != null) {
            if (this.fitWidthTablePrintMode.isSelected()) {
                l |= 1L;
            } else if (this.normalTablePrintMode.isSelected()) {
                l |= 2L;
            }
        }
        if (this.printHeader.isEnabled() && this.printHeader.isSelected()) {
            l |= 8L;
        }
        if (this.printFooter.isEnabled() && this.printFooter.isSelected()) {
            l |= 4L;
        }
        int n = this.getSelectedOrientation();
        switch (n) {
            case 1: {
                l |= 0x20L;
                break;
            }
            case 0: {
                l |= 0x10L;
                break;
            }
            case 2: {
                l |= 0x50L;
                break;
            }
            default: {
                throw new WTFError("Uknown page format orientation: " + n);
            }
        }
        return new Flags(l);
    }

    private int getSelectedOrientation() {
        return this.printPreview != null ? this.printPreview.orientation : 1;
    }

    private void setPageFormat(int n) {
        if (this.printPreview != null && this.printHeader != null) {
            this.printPreview.orientation = n;
            this.updatePreview();
        }
    }
}

