/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.makagiga.commons.FS;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.proxy.ProxyInfo;
import org.makagiga.commons.proxy.ProxyModel;

public final class ProxyManager {
    private static boolean initDone;
    private static MGuardedObject<ProxyModel> _guardedModel;
    private static ProxySelector defaultSelector;

    public static Proxy createProxy(Proxy.Type type, String string, int n) {
        if (type == Proxy.Type.DIRECT) {
            return Proxy.NO_PROXY;
        }
        try {
            return new Proxy(type, InetSocketAddress.createUnresolved(string, n));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MLogger.exception(illegalArgumentException);
            return Proxy.NO_PROXY;
        }
    }

    public static synchronized void disableProxy() {
        MLogger.debug("proxy", "Setting no proxy");
        ProxyManager.setSelector(null);
        System.clearProperty("java.net.useSystemProxies");
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyHost");
        System.clearProperty("https.proxyPort");
        System.clearProperty("socksProxyHost");
        System.clearProperty("socksProxyPort");
    }

    public static synchronized void enableProxy(Proxy proxy, boolean bl) {
        MLogger.debug("proxy", "Setting proxy: %s", proxy);
        InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
        if (inetSocketAddress == null) {
            ProxyManager.disableProxy();
            return;
        }
        System.clearProperty("java.net.useSystemProxies");
        String string = inetSocketAddress.getHostName();
        String string2 = Integer.toString(inetSocketAddress.getPort());
        switch (proxy.type()) {
            case DIRECT: {
                ProxyManager.disableProxy();
                break;
            }
            case HTTP: {
                System.setProperty("http.proxyHost", string);
                System.setProperty("http.proxyPort", string2);
                if (!bl) break;
                System.setProperty("https.proxyHost", string);
                System.setProperty("https.proxyPort", string2);
                break;
            }
            case SOCKS: {
                System.setProperty("http.proxyHost", string);
                System.setProperty("http.proxyPort", string2);
                if (bl) {
                    System.setProperty("https.proxyHost", string);
                    System.setProperty("https.proxyPort", string2);
                }
                System.setProperty("socksProxyHost", string);
                System.setProperty("socksProxyPort", string2);
                break;
            }
            default: {
                throw new WTFError(proxy.type());
            }
        }
    }

    public static String getDefaultFile() {
        return FS.makeConfigPath("proxy.xml");
    }

    public static synchronized ProxyModel getModel() {
        if (_guardedModel == null) {
            ProxyModel proxyModel = new ProxyModel();
            _guardedModel = new MGuardedObject<ProxyModel>(proxyModel, "org.makagiga.commons.proxy.ProxyModel", PermissionInfo.ThreatLevel.HIGH, "Proxy");
            try {
                proxyModel.read(ProxyManager.getDefaultFile());
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
            }
        }
        return _guardedModel.get();
    }

    public static synchronized void init() {
        ProxyModel proxyModel = ProxyManager.getModel();
        if (proxyModel.isSystem()) {
            ProxyManager.disableProxy();
            System.setProperty("java.net.useSystemProxies", "true");
            return;
        }
        if (!proxyModel.isEnabled() || proxyModel.isEmpty()) {
            ProxyManager.disableProxy();
            return;
        }
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>(proxyModel.getRowCount());
        for (ProxyInfo proxyInfo : proxyModel) {
            if (!proxyInfo.isEnabled()) continue;
            arrayList.add(proxyInfo.createProxy());
        }
        if (arrayList.isEmpty()) {
            ProxyManager.disableProxy();
            return;
        }
        ProxyManager.setSelector(new Selector(arrayList));
    }

    private ProxyManager() {
    }

    private static void setSelector(ProxySelector proxySelector) {
        if (!initDone) {
            initDone = true;
            defaultSelector = ProxySelector.getDefault();
        }
        ProxySelector.setDefault(proxySelector);
    }

    private static final class Selector
    extends ProxySelector {
        private int failures;
        private Proxy current;
        private List<Proxy> noProxy;
        private List<Proxy> proxyList;

        @Override
        public synchronized void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
            if (uRI == null) {
                throw new IllegalArgumentException("\"uri\" is null");
            }
            if (socketAddress == null) {
                throw new IllegalArgumentException("\"sa\" is null");
            }
            if (iOException == null) {
                throw new IllegalArgumentException("\"ioe\" is null");
            }
            if (this.current != null) {
                ++this.failures;
                if (this.failures >= 3) {
                    this.failures = 0;
                    MLogger.exception(iOException);
                    MLogger.debug("proxy-selector", "Proxy failed; removing from the selector: %s (%s)", this.current, uRI);
                    this.proxyList.remove(this.current);
                    this.current = null;
                }
            } else if (defaultSelector != null) {
                defaultSelector.connectFailed(uRI, socketAddress, iOException);
            }
        }

        @Override
        public synchronized List<Proxy> select(URI uRI) {
            if (uRI == null) {
                throw new IllegalArgumentException("\"uri\" is null");
            }
            if (this.proxyList.isEmpty()) {
                MLogger.debug("proxy-selector", "No proxy found: %s", uRI);
                return defaultSelector == null ? this.noProxy : defaultSelector.select(uRI);
            }
            String string = uRI.getScheme();
            if ("http".equalsIgnoreCase(string) || "https".equalsIgnoreCase(string)) {
                MLogger.debug("proxy-selector", "Returning proxy list: %d (%s)", this.proxyList.size(), uRI);
                if (this.current == null) {
                    this.current = this.next();
                }
                if (this.current != null) {
                    return new MArrayList<Proxy>(this.current);
                }
                MLogger.debug("proxy-selector", "No proxy found (2): %s", uRI);
                return defaultSelector == null ? this.noProxy : defaultSelector.select(uRI);
            }
            MLogger.debug("proxy-selector", "Unsupported protocol: %s", uRI);
            return defaultSelector == null ? this.noProxy : defaultSelector.select(uRI);
        }

        private Selector(List<Proxy> list) {
            this.proxyList = list;
            this.noProxy = new ArrayList<Proxy>(1);
            this.noProxy.add(Proxy.NO_PROXY);
        }

        private Proxy next() {
            this.failures = 0;
            this.current = this.proxyList.isEmpty() ? null : this.proxyList.get(0);
            return this.current;
        }
    }
}

