/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.proxy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Proxy;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.Config;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.MUndoManager;
import org.makagiga.commons.OS;
import org.makagiga.commons.SimpleXMLReader;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.XMLBuilder;
import org.makagiga.commons.proxy.ProxyInfo;

public class ProxyModel
extends AbstractListTableModel<ProxyInfo> {
    private boolean enabled;
    private boolean system;
    private MUndoManager undoManager;
    static final int COLUMN_ENABLED = 0;
    static final int COLUMN_ADDRESS = 1;
    static final int COLUMN_PORT = 2;
    static final int COLUMN_DESCRIPTION = 3;
    static final int COLUMN_TYPE = 4;

    public ProxyModel() {
        super(new AbstractListTableModel.ColumnInfo(UI._("Enabled"), Boolean.class), new AbstractListTableModel.ColumnInfo(UI._("Address"), String.class), new AbstractListTableModel.ColumnInfo(UI._("Port"), Integer.class), new AbstractListTableModel.ColumnInfo(UI._("Description"), String.class), new AbstractListTableModel.ColumnInfo(UI._("Type"), Proxy.Type.class));
        if (!OS.isHeadless()) {
            this.undoManager = new MUndoManager();
            this.addUndoableEditListener(this.undoManager.createUndoableEditListener());
        }
    }

    public MUndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ProxyInfo proxyInfo = (ProxyInfo)this.getRowAt(n);
        switch (n2) {
            case 0: {
                return proxyInfo.isEnabled();
            }
            case 1: {
                return proxyInfo.getAddress();
            }
            case 2: {
                return proxyInfo.getPort();
            }
            case 3: {
                return proxyInfo.getDescription();
            }
            case 4: {
                return proxyInfo.getType();
            }
        }
        throw new WTFError("Unknown proxy model column: " + n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ProxyInfo proxyInfo = (ProxyInfo)this.getRowAt(n);
        ProxyInfo proxyInfo2 = this.createCopyForUndo(proxyInfo);
        switch (n2) {
            case 0: {
                proxyInfo.setEnabled((Boolean)object);
                break;
            }
            case 1: {
                proxyInfo.setAddress((String)object);
                break;
            }
            case 2: {
                proxyInfo.setPort((Integer)object);
                break;
            }
            case 3: {
                proxyInfo.setDescription((String)object);
                break;
            }
            case 4: {
                proxyInfo.setType((Proxy.Type)((Object)object));
                break;
            }
            default: {
                throw new WTFError("Unknown proxy model column: " + n2);
            }
        }
        this.fireTableCellUpdated(n, n2);
        this.fireUndoableEditHappened(new AbstractListTableModel.ChangeUndo(proxyInfo2, this.createCopyForUndo(proxyInfo), n));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean bl) {
        this.system = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String string) throws IOException {
        try {
            this.setEventsEnabled(false);
            this.clear();
            SimpleXMLReader simpleXMLReader = new SimpleXMLReader(){
                private boolean inItem;
                private boolean inProxy;
                private ProxyInfo info;

                @Override
                protected void onEnd(String string) {
                    if (this.inProxy) {
                        if (this.inItem && "item".equals(string)) {
                            this.inItem = false;
                            ProxyModel.this.addRow(this.info);
                            this.info = null;
                        } else if ("proxy".equals(string)) {
                            this.inProxy = false;
                        }
                    }
                }

                @Override
                protected void onStart(String string) {
                    if (this.inItem) {
                        if ("address".equals(string)) {
                            this.info.setAddress(this.getValue(this.info.getAddress()));
                            this.info.setPort(this.getIntegerAttribute("port", this.info.getPort()));
                        } else if ("description".equals(string)) {
                            this.info.setDescription(this.getValue());
                        }
                    } else if (this.inProxy && "item".equals(string)) {
                        this.inItem = true;
                        this.info = new ProxyInfo();
                        this.info.setEnabled(this.getBooleanAttribute("enabled", this.info.isEnabled()));
                        this.info.setType(EnumProperty.parse(this.getStringAttribute("type"), this.info.getType()));
                    } else if (!this.inProxy && "proxy".equals(string)) {
                        this.inProxy = true;
                        ProxyModel.this.setEnabled(this.getBooleanAttribute("enabled", ProxyModel.this.isEnabled()));
                        ProxyModel.this.setSystem(this.getBooleanAttribute("system", ProxyModel.this.isSystem()));
                    }
                }
            };
            simpleXMLReader.read(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.addRow(new ProxyInfo("localhost", 3128, "Squid - proxy caching server for web clients"));
        }
        finally {
            this.setEventsEnabled(true);
        }
    }

    public void write(String string) throws IOException {
        XMLBuilder xMLBuilder = new XMLBuilder();
        String string2 = Config.getDefaultComment();
        if (string2 != null) {
            xMLBuilder.addComment(string2);
        }
        xMLBuilder.beginTag("proxy", "enabled", this.enabled, "system", this.system);
        for (ProxyInfo proxyInfo : this) {
            xMLBuilder.beginTag("item", new Object[]{"enabled", proxyInfo.isEnabled(), "type", proxyInfo.getType()});
            xMLBuilder.doubleTag("address", XMLBuilder.escape(proxyInfo.getAddress()), "port", proxyInfo.getPort());
            xMLBuilder.doubleTag("description", XMLBuilder.escape(proxyInfo.getDescription()), new Object[0]);
            xMLBuilder.endTag("item");
        }
        xMLBuilder.endTag("proxy");
        xMLBuilder.save(string);
    }

    @Override
    protected ProxyInfo createCopyForUndo(ProxyInfo proxyInfo) {
        return (ProxyInfo)proxyInfo.clone();
    }
}

