/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.request;

import java.awt.EventQueue;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.request.RequestInfo;
import org.makagiga.commons.request.RequestProperties;
import org.makagiga.commons.request.RequestSource;

public abstract class AbstractRequestManager<T> {
    protected volatile boolean finishing;
    @Deprecated
    protected ExecutorService threadPool;
    protected int maxThreads;
    protected long threadSleep;
    private volatile int count;

    public AbstractRequestManager(int n, long l) {
        this.maxThreads = n;
        this.threadSleep = l;
        this.initThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Runnable> cancelAll() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("\"cancelAll\" should be invoked on EDT");
        }
        this.count = 0;
        AbstractRequestManager abstractRequestManager = this;
        synchronized (abstractRequestManager) {
            return this.threadPool.shutdownNow();
        }
    }

    public synchronized void finishAll() {
        List<Runnable> list = this.cancelAll();
        if (!TK.isEmpty(list)) {
            this.finishing = true;
            for (Runnable runnable : list) {
                runnable.run();
            }
        }
        this.initThreadPool();
    }

    public int getCount() {
        return this.count;
    }

    public synchronized RequestInfo<T> startRequest(final RequestSource<T> requestSource, RequestProperties requestProperties) {
        final RequestInfo<T> requestInfo = new RequestInfo<T>(requestSource, requestProperties);
        try {
            ++this.count;
            this.threadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!AbstractRequestManager.this.finishing && AbstractRequestManager.this.threadSleep > 0L && !requestInfo.isCancelled()) {
                        TK.sleep(AbstractRequestManager.this.threadSleep);
                    }
                    try {
                        AbstractRequestManager abstractRequestManager;
                        if (requestInfo.isCancelled()) {
                            abstractRequestManager = null;
                            MLogger.debug("request", "Cancelled: %s", requestInfo);
                        } else {
                            abstractRequestManager = (AbstractRequestManager)AbstractRequestManager.this.getResult(requestInfo);
                        }
                        if (AbstractRequestManager.this.finishing) {
                            requestSource.requestDone(requestInfo, abstractRequestManager);
                        } else {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    requestSource.requestDone(requestInfo, abstractRequestManager);
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        MLogger.exception(exception);
                    }
                    finally {
                        AbstractRequestManager abstractRequestManager = AbstractRequestManager.this;
                        synchronized (abstractRequestManager) {
                            AbstractRequestManager.this.count--;
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            --this.count;
            MLogger.exception(rejectedExecutionException);
            requestInfo.setCancelled(true);
        }
        return requestInfo;
    }

    protected abstract T getResult(RequestInfo<T> var1) throws Exception;

    protected ExecutorService getThreadPool() {
        return this.threadPool;
    }

    protected void initThreadPool() {
        this.count = 0;
        this.finishing = false;
        this.threadPool = Executors.newFixedThreadPool(this.maxThreads);
    }
}

