/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.script;

import java.awt.event.MouseEvent;
import javax.script.ScriptException;
import javax.swing.JComponent;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MainView;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public final class ScriptError
extends CoolHeader {
    private boolean showFullText = true;
    private final boolean showStatusBarOnError;
    private static ScriptError _instance;
    private Throwable error;

    public ScriptError(boolean bl) {
        this.showStatusBarOnError = bl;
        this.setStyle("margin: 0 5 0 5");
        this.setToolTipText(UI._("Error"));
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ScriptError getSharedInstance() {
        if (_instance == null) {
            ScriptError scriptError = new ScriptError(true);
            JComponent jComponent = scriptError;
            synchronized (jComponent) {
                scriptError.showFullText = false;
            }
            scriptError.setCursor(12);
            scriptError.addMouseListener(new MMouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (1.isLeft(mouseEvent)) {
                        ScriptError scriptError = (ScriptError)mouseEvent.getSource();
                        scriptError.setVisible(false);
                        if (scriptError.error != null) {
                            MMessage.errorDetails(UI.windowFor(scriptError), scriptError.error);
                            scriptError.error = null;
                        }
                    }
                }
            });
            jComponent = MainView.getStatusBar();
            if (jComponent != null) {
                MPanel mPanel = ((MStatusBar)jComponent).getButtonPanel();
                mPanel.add(scriptError);
                mPanel.validate();
            }
            _instance = scriptError;
        }
        return _instance;
    }

    public synchronized void showError(Throwable throwable) {
        Throwable throwable2;
        this.error = throwable;
        if (throwable == null) {
            return;
        }
        MLogger.exception(throwable);
        String string = null;
        string = throwable instanceof ScriptException ? this.getScriptErrorMessage((ScriptException)throwable) : ((throwable2 = throwable.getCause()) == null ? throwable.getMessage() : (throwable2 instanceof ScriptException ? this.getScriptErrorMessage((ScriptException)throwable2) : throwable2.getMessage()));
        this.setErrorMessage(this.showFullText ? UI.makeHTML(TK.escapeXML(string)) : null);
        this.setToolTipText(string);
        this.doShow(true);
    }

    public synchronized void showResult(Object object) {
        String string;
        String string2 = string = object == null ? UI._("OK") : object.toString();
        if (string.isEmpty()) {
            string = UI._("OK");
        }
        this.setOKMessage(this.showFullText ? UI.makeHTML(TK.escapeXML(string)) : null);
        this.setToolTipText(string);
        this.doShow(false);
    }

    private void doShow(boolean bl) {
        MStatusBar mStatusBar;
        this.setVisible(true);
        if (bl && this.showStatusBarOnError && (mStatusBar = MainView.getStatusBar()) != null) {
            mStatusBar.setVisible(true);
        }
    }

    private String getScriptErrorMessage(ScriptException scriptException) {
        String string = scriptException.getMessage();
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(n + 2);
        }
        string = scriptException.getLineNumber() + ": " + string;
        return string;
    }
}

