/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;

public class CollectionMap<K, T>
implements Iterable<Map.Entry<K, Collection<T>>>,
Map<K, Collection<T>> {
    private final CollectionType collectionType;
    private final Map<K, Collection<T>> map;
    private final MapType mapType;

    public CollectionMap(MapType mapType, CollectionType collectionType) {
        this.mapType = TK.checkNull(mapType);
        this.collectionType = TK.checkNull(collectionType);
        this.map = this.createMap();
    }

    public Collection<T> add(K k, T t) {
        Collection<T> collection = this.map.get(k);
        if (collection == null) {
            collection = this.createCollection();
            this.map.put(k, collection);
        }
        collection.add(t);
        return collection;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return ((Object)this.map).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public Map<K, ? extends Collection<T>> getMap() {
        return this.map;
    }

    @Override
    public Iterator<Map.Entry<K, Collection<T>>> iterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Set<Map.Entry<K, Collection<T>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Collection<T> get(Object object) {
        return this.map.get(object);
    }

    @Override
    public Collection<T> put(K k, Collection<T> collection) {
        return this.map.put(k, collection);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<T>> map) {
        this.map.putAll(map);
    }

    @Override
    public Collection<T> remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public Collection<Collection<T>> values() {
        return this.map.values();
    }

    private Collection<T> createCollection() {
        switch (this.collectionType) {
            case ARRAY_LIST: {
                return new ArrayList();
            }
            case HASH_SET: {
                return new HashSet();
            }
            case LINKED_HASH_SET: {
                return new LinkedHashSet();
            }
            case TREE_SET: {
                return new TreeSet();
            }
            case SYNCHRONIZED_ARRAY_LIST: {
                return new Vector();
            }
        }
        throw new WTFError(this.collectionType);
    }

    private Map<K, Collection<T>> createMap() {
        switch (this.mapType) {
            case HASH_MAP: {
                return new HashMap();
            }
            case LINKED_HASH_MAP: {
                return new LinkedHashMap();
            }
            case SYNCHRONIZED_HASH_MAP: {
                return new Hashtable();
            }
            case TREE_MAP: {
                return new TreeMap();
            }
        }
        throw new WTFError(this.mapType);
    }

    public static enum MapType {
        HASH_MAP,
        SYNCHRONIZED_HASH_MAP,
        LINKED_HASH_MAP,
        TREE_MAP;

    }

    public static enum CollectionType {
        ARRAY_LIST,
        SYNCHRONIZED_ARRAY_LIST,
        HASH_SET,
        LINKED_HASH_SET,
        TREE_SET;

    }
}

