/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.UIManager;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.FS;
import org.makagiga.commons.ImageBorder;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MSettingsDialog;
import org.makagiga.commons.MSettingsPage;
import org.makagiga.commons.UI;
import org.makagiga.commons.swing.Input;
import org.makagiga.desktop.Desktop;
import org.makagiga.desktop.ui.WidgetDesktopPaneUI;

public class DesktopSettings
extends MSettingsPage {
    private ActionListener wallpaperActionListener;
    private final BooleanProperty wallpaper = new BooleanProperty();
    private final EnumMap<ImageBorder.Position, ImagePosition> positionMap;
    private final EnumProperty<ImagePosition> imagePosition = EnumProperty.create(ImagePosition.CENTERED, ImagePosition.class);
    private MButton selectImageButton;
    private final WeakReference<Desktop> desktopRef;

    @Deprecated
    public DesktopSettings() {
        this(Desktop.getInstance());
    }

    public DesktopSettings(Desktop desktop) {
        super(UI._("Background"), "ui/image");
        this.desktopRef = new WeakReference<Desktop>(desktop);
        this.positionMap = new EnumMap(ImageBorder.Position.class);
        this.positionMap.put(ImageBorder.Position.CENTERED, ImagePosition.CENTERED);
        this.positionMap.put(ImageBorder.Position.COMPONENT_SIZE, ImagePosition.STRETCHED);
        ImagePosition imagePosition = this.positionMap.get(Desktop.backgroundImagePosition.get());
        if (imagePosition != null) {
            this.imagePosition.set(imagePosition);
        }
        this.wallpaper.set(!Desktop.backgroundImage.isEmpty());
        this.bind(Desktop.backgroundColor, UI._("Color"));
        this.addSeparator(UI._("Wallpaper"));
        MCheckBox mCheckBox = (MCheckBox)this.bind(this.wallpaper, UI._("Enabled"));
        this.wallpaperActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MCheckBox mCheckBox = (MCheckBox)actionEvent.getSource();
                DesktopSettings.this.updateComponents(mCheckBox.isSelected());
                if (mCheckBox.isSelected()) {
                    DesktopSettings.this.selectImageButton.requestFocusInWindow();
                }
            }
        };
        mCheckBox.addActionListener(this.wallpaperActionListener);
        this.addGap();
        this.selectImageButton = new MButton(UI._("Select Image...")){

            @Override
            protected void onClick() {
                File file = Input.getImageFile(this.getWindowAncestor());
                if (file != null) {
                    String string = FS.getPortableConfigPath(file.getPath());
                    Desktop.backgroundImage.set(string);
                }
            }
        };
        this.selectImageButton.setIconNameUI("ui/image");
        this.add(this.selectImageButton);
        this.addGap();
        this.bind(this.imagePosition, UI._("Position:"));
        this.setEnumText(ImagePosition.CENTERED, UI._("Centered"));
        this.setEnumText(ImagePosition.STRETCHED, UI._("Stretched"));
        this.updateComponents((Boolean)this.wallpaper.get());
    }

    @Override
    protected Color[] createColorPalette() {
        MArrayList<Color> mArrayList = new MArrayList<Color>(2);
        Color color = UIManager.getColor("Desktop.background");
        if (color != null) {
            mArrayList.add(color);
        }
        Color color2 = (Color)UI.customColor.get();
        if (((Boolean)UI.useCustomColor.get()).booleanValue() && color2 != null && !mArrayList.contains(color2)) {
            mArrayList.add(color2);
        }
        return mArrayList.toArray(Color.class);
    }

    @Override
    protected void onClose() {
        this.selectImageButton = null;
        if (this.wallpaperActionListener != null) {
            MCheckBox mCheckBox = (MCheckBox)this.getEditorView(this.wallpaper);
            mCheckBox.removeActionListener(this.wallpaperActionListener);
            this.wallpaperActionListener = null;
        }
    }

    @Override
    protected void onOK() {
        super.onOK();
        for (Map.Entry<ImageBorder.Position, ImagePosition> entry : this.positionMap.entrySet()) {
            if (entry.getValue() != this.imagePosition.get()) continue;
            Desktop.backgroundImagePosition.set(entry.getKey());
            break;
        }
        if (!((Boolean)this.wallpaper.get()).booleanValue()) {
            Desktop.backgroundImage.set(null);
        }
        Window window = this.getParentWindow();
        ((Desktop)this.desktopRef.get()).updateBackground(true, window);
    }

    private void updateComponents(boolean bl) {
        this.selectImageButton.setEnabled(bl);
        this.getEditorView(this.imagePosition).setEnabled(bl);
    }

    public static final class Advanced
    extends MSettingsPage {
        public Advanced() {
            super(UI._("Advanced"), MActionInfo.ADVANCED.getIconName());
            this.bind(Desktop.widgetsPainterType, UI._("Gradient:"));
            this.setEnumText(WidgetDesktopPaneUI.PainterType.FLAT, UI._("Plain Color"));
            this.setEnumText(WidgetDesktopPaneUI.PainterType.GLASS, UI._("Glass Gradient"));
            this.setEnumText(WidgetDesktopPaneUI.PainterType.GRADIENT, UI._("Simple Gradient"));
        }
    }

    public static final class Action
    extends MDataAction.Weak<Desktop> {
        @Deprecated
        public Action() {
            this(Desktop.getInstance());
        }

        public Action(Desktop desktop) {
            super(desktop, MActionInfo.SETTINGS);
        }

        @Override
        public void onAction() {
            MSettingsDialog<MSettingsPage> mSettingsDialog = new MSettingsDialog<MSettingsPage>(this.getSourceWindow(), MActionInfo.SETTINGS.getDialogTitle(), MActionInfo.SETTINGS.getIcon(), 1031, "desktop", 1);
            mSettingsDialog.setAutoResizeWindow(true);
            mSettingsDialog.addPage(new DesktopSettings((Desktop)this.get()));
            mSettingsDialog.addPage(new Advanced());
            mSettingsDialog.exec();
        }
    }

    private static enum ImagePosition {
        CENTERED,
        STRETCHED;

    }
}

