/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.clock;

import java.awt.Window;
import java.util.Calendar;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.ConfigEntry;
import org.makagiga.commons.FontProperty;
import org.makagiga.commons.MCalendar;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MSettingsPage;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.UI;
import org.makagiga.desktop.Widget;
import org.makagiga.plugins.PluginInfo;

public abstract class AbstractClockWidget
extends Widget {
    @ConfigEntry(value="x.showBackground")
    public final BooleanProperty showBackground = new BooleanProperty(true);
    @ConfigEntry(value="x.showSeconds")
    public final BooleanProperty showSeconds = new BooleanProperty(false);
    @ConfigEntry(value="x.useCustomColor")
    public final BooleanProperty useCustomColor = new BooleanProperty(true);
    @ConfigEntry(value="x.backgroundColor")
    public final ColorProperty backgroundColor = new ColorProperty(MColor.FOREST_GREEN);
    @ConfigEntry(value="x.foregroundColor")
    public final ColorProperty foregroundColor = new ColorProperty(MColor.BLACK);
    @ConfigEntry(value="x.font")
    public final FontProperty font = new FontProperty("Monospaced", 1, 24);
    private int lastHour = -1;
    private int lastMinute = -1;
    private int lastSecond = -1;
    private MTimer updateTimer = new MTimer(MTimer.Format.SECONDS, 1){

        @Override
        protected boolean onTimeout() {
            AbstractClockWidget.this.updateDisplay(false);
            return true;
        }
    };

    public AbstractClockWidget(PluginInfo pluginInfo) {
        super(pluginInfo);
        this.setSettingsActionVisible(true);
    }

    @Deprecated
    public void configure() {
        this.onSettings(this.getWindowAncestor());
    }

    @Override
    public void onRestoreSession() {
        Config config = this.getConfig();
        config.read(this.getClass(), this);
        this.updateDisplay(true);
        this.reconfigureFromConfig();
        this.updateTimer.start();
    }

    protected boolean isPropertySupported(PropertyAccess<?> propertyAccess) {
        return true;
    }

    @Override
    protected void onSettings(Window window) {
        boolean bl = this.isPropertySupported(this.useCustomColor);
        boolean bl2 = this.isPropertySupported(this.font);
        boolean bl3 = this.isPropertySupported(this.showBackground);
        boolean bl4 = this.isPropertySupported(this.showSeconds);
        MSettingsPage mSettingsPage = new MSettingsPage(){

            @Override
            protected void onOK() {
                AbstractClockWidget.this.applySettings();
            }
        };
        mSettingsPage.setDialogFlags(1031);
        mSettingsPage.addSeparator(UI._("Colors"));
        if (bl3) {
            mSettingsPage.bind(this.showBackground, UI._("Show Background"));
        }
        if (bl) {
            mSettingsPage.bind(this.useCustomColor, UI._("Use Custom Color"));
        }
        mSettingsPage.bind(this.backgroundColor, UI._("Background"));
        mSettingsPage.bind(this.foregroundColor, UI._("Text"));
        if (bl) {
            mSettingsPage.bind(this.useCustomColor, "selected", this.backgroundColor, "enabled");
            mSettingsPage.bind(this.useCustomColor, "selected", this.foregroundColor, "enabled");
        }
        if (bl2 || bl4 || bl3) {
            mSettingsPage.addSeparator(UI._("View"));
        }
        if (bl2) {
            mSettingsPage.bind(this.font, null);
            if (bl4 || bl3) {
                mSettingsPage.addGap();
            }
        }
        if (bl4) {
            mSettingsPage.bind(this.showSeconds, UI._("Show Seconds"));
        }
        mSettingsPage.exec(window);
    }

    protected abstract void onTimeChange(Calendar var1);

    @Override
    protected void onShutDown() {
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
    }

    protected abstract void reconfigureFromConfig();

    protected void updateDisplay(boolean bl) {
        MCalendar mCalendar = MCalendar.now();
        int n = mCalendar.getHour();
        int n2 = mCalendar.getMinute();
        int n3 = mCalendar.getSecond();
        if (bl || n != this.lastHour || n2 != this.lastMinute || n3 != this.lastSecond && ((Boolean)this.showSeconds.get()).booleanValue()) {
            this.lastHour = n;
            this.lastMinute = n2;
            this.lastSecond = n3;
            this.onTimeChange(mCalendar);
        }
    }

    private void applySettings() {
        this.updateDisplay(true);
        this.reconfigureFromConfig();
        Config config = this.getConfig();
        config.write(this.getClass(), this);
        config.sync();
    }
}

