/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.todo;

import java.io.File;
import javax.swing.event.TableModelEvent;
import org.makagiga.commons.Config;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.UI;
import org.makagiga.commons.print.PrintDialog;
import org.makagiga.commons.print.TablePrintInfo;
import org.makagiga.commons.script.ScriptYourself;
import org.makagiga.desktop.SessionEvent;
import org.makagiga.desktop.SessionListener;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.todo.Todo;
import org.makagiga.fs.MetaInfo;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.todo.Column;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskModel;
import org.makagiga.todo.TaskPanel;
import org.makagiga.tree.tracker.Tracker;
import org.makagiga.tree.tracker.TrackerEvent;

public final class TodoWidget
extends Widget
implements Focusable,
SessionListener {
    private boolean loaded;
    private boolean readError;
    private File taskFile;
    private final TaskPanel<Todo> taskPanel;
    private Todo todo;
    MetaInfo metaInfo;

    public TodoWidget(PluginInfo pluginInfo) {
        super(pluginInfo);
        this.setDefaultSize(Column.CIRCLE.getPreferredWidth() + Column.SUMMARY.getPreferredWidth() + Column.DATE_TIME.getPreferredWidth(), 250);
        this.setToolBarEnabled(true);
        this.addSessionListener(this);
        this.todo = new Todo(){

            @Override
            protected void onChange(TableModelEvent tableModelEvent) {
                if (TodoWidget.this.loaded && ((TaskModel)this.getModel()).getEventsEnabled()) {
                    TodoWidget.this.sync();
                    Tracker.notifyTaskChange(TodoWidget.this.metaInfo, this, tableModelEvent);
                }
            }
        };
        this.todo.getColumnManager().setDefaultColumnOrder(Column.CIRCLE, Column.SUMMARY, Column.DATE_TIME);
        this.addCenter(this.todo, 2);
        this.taskPanel = new TaskPanel<Todo>(this.todo);
        this.taskPanel.getFilterPanel().setVisible(false);
        this.addNorth(this.taskPanel);
    }

    @Override
    public void focus() {
        Object object = this.getClientProperty(Task.class.getName());
        if (object instanceof Task) {
            this.putClientProperty(Task.class.getName(), null);
            this.todo.requestFocusInWindow();
            this.todo.selectTask((Task)object);
        } else {
            this.taskPanel.focus();
        }
    }

    @Override
    public void restoreSession(SessionEvent sessionEvent) {
        this.loaded = true;
        this.taskFile = new File(this.getWorkingDirectory(), "To-Do.mgtodo");
        this.metaInfo = MetaInfo.createFile(null, this.taskFile.getPath(), "mgtodo");
        this.metaInfo.setProperty("metaInfo.override.name", this.getPluginInfo() + " - " + UI._("Widget"));
        this.metaInfo.setProperty("metaInfo.owner", this);
        try {
            this.todo.read(this.taskFile);
            ((TaskModel)this.todo.getModel()).fireTableDataChanged();
            this.todo.getEditActionGroup().update();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.taskPanel.setVisible(false);
            this.readError = true;
            throw new RuntimeException(throwable);
        }
        Config config = this.getConfig();
        this.todo.read(Config.getDefault(), config, this.getPluginInfo().getPlugin());
    }

    @Override
    public void saveSession(SessionEvent sessionEvent) {
        this.sync();
        if (!this.readError) {
            Config config = this.getConfig();
            this.todo.write(Config.getDefault(), config, this.getPluginInfo().getPlugin());
        }
    }

    @Override
    protected void onDelete() {
        if (this.metaInfo != null) {
            Tracker.add(this.metaInfo, TrackerEvent.ID.ITEM_REMOVED);
        }
    }

    @Override
    protected void onShutDown() {
        if (this.metaInfo != null) {
            this.metaInfo.clearProperty("metaInfo.owner");
        }
        this.todo = null;
    }

    @Override
    protected void updateToolBar(MToolBar mToolBar) {
        if (this.readError) {
            return;
        }
        mToolBar.add(new MApplication.PrintAction(){

            @Override
            public void onAction() {
                TodoWidget.this.print();
            }
        });
        mToolBar.addSeparator();
        this.todo.getEditActionGroup().updateToolBar(mToolBar);
        ScriptYourself.install(mToolBar, "todo-widget");
    }

    void print() {
        TablePrintInfo tablePrintInfo = new TablePrintInfo(this.getTitle(), this.todo, this.getTitle(), TablePrintInfo.getCurrentDateTime());
        PrintDialog printDialog = new PrintDialog(this.getWindowAncestor(), tablePrintInfo);
        printDialog.exec();
    }

    void sync() {
        if (this.readError) {
            return;
        }
        try {
            ((TaskModel)this.todo.getModel()).saveToXML(this.taskFile);
        }
        catch (Exception exception) {
            MMessage.error(this.getWindowAncestor(), exception);
        }
    }
}

