/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import java.awt.Component;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.Config;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.Linkify;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MLinkAction;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MText;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.print.PrintInfo;
import org.makagiga.commons.print.TextPrintInfo;
import org.makagiga.editors.DocumentLinks;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorPrint;
import org.makagiga.editors.EditorSearch;
import org.makagiga.editors.EditorZoom;
import org.makagiga.editors.TextUtils;
import org.makagiga.plugins.PluginMenu;

public abstract class AbstractTextEditor<C extends JTextComponent>
extends Editor<C>
implements DocumentLinks,
EditorPrint,
EditorSearch,
EditorZoom,
FlavorListener,
Focusable,
PluginMenu {
    protected int fontSize;
    private StaticCoreHandler staticCoreHandler;

    public AbstractTextEditor(C c) {
        this(c, true);
    }

    public AbstractTextEditor(C c, boolean bl) {
        this.setCore(c);
        if (bl) {
            this.addCenter((JComponent)c, 2);
        }
        MText.updatePasteAction(c);
        try {
            MClipboard.getDefault().addFlavorListener(this);
        }
        catch (NullPointerException nullPointerException) {
            MLogger.exception(nullPointerException);
        }
        catch (SecurityException securityException) {
            MLogger.warning("core", "Clipboard flavor listener disabled by Security Manager: %s", securityException.getMessage());
        }
        this.staticCoreHandler = new StaticCoreHandler();
        ((Component)c).addMouseListener(this.staticCoreHandler);
    }

    @Override
    public boolean getSupportsToolBarUnderTabs() {
        return true;
    }

    @Override
    public boolean isLocked() {
        return !((JTextComponent)this.core).isEditable();
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        ((JTextComponent)this.core).setEditable(!bl);
    }

    @Override
    public void onClose() {
        if (this.staticCoreHandler != null) {
            ((JTextComponent)this.core).removeMouseListener(this.staticCoreHandler);
            this.staticCoreHandler = null;
        }
        try {
            MClipboard.getDefault().removeFlavorListener(this);
        }
        catch (NullPointerException nullPointerException) {
            MLogger.exception(nullPointerException);
        }
        TextUtils.uninstallSearchHighlighter((JTextComponent)this.core);
    }

    @Override
    public void updateActions() {
        MText.updateActions((JTextComponent)this.core);
    }

    @Override
    public Collection<MLinkAction> getDocumentLinks() {
        Set<URI> set = Linkify.getInstance().findAll(MText.getPlainText((JTextComponent)this.core));
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        MArrayList<MLinkAction> mArrayList = new MArrayList<MLinkAction>(set.size());
        for (URI uRI : set) {
            mArrayList.add(new MLinkAction(uRI));
        }
        return mArrayList;
    }

    @Override
    public Printable getPrintable(Flags flags, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        return ((JTextComponent)this.core).getPrintable(messageFormat, messageFormat2);
    }

    @Override
    public PrintInfo.PrintResult printDocument(Flags flags, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        return TextPrintInfo.printDocument((JTextComponent)this.core, flags, messageFormat, messageFormat2, this.getPrintTitle());
    }

    @Override
    public EditorSearch.SearchResult findText(String string, Flags flags) {
        return TextUtils.findText((JTextComponent)this.core, string, flags);
    }

    @Override
    public EditorSearch.SearchResult findNextText(String string, Flags flags) {
        return TextUtils.findNextText((JTextComponent)this.core, string, flags);
    }

    @Override
    public String getDefaultSearchText() {
        return ((JTextComponent)this.core).getSelectedText();
    }

    @Override
    public int getSupportedSearchOptions() {
        return 1;
    }

    @Override
    public JComponent getZoomComponent() {
        return null;
    }

    @Override
    public boolean isZoomEnabled(EditorZoom.ZoomType zoomType) {
        return TextUtils.canZoom((JComponent)this.core, zoomType);
    }

    @Override
    public void zoom(EditorZoom.ZoomType zoomType) {
        this.fontSize = TextUtils.zoom((JComponent)this.core, zoomType).getSize();
        Config config = Config.getDefault();
        this.writeFontSize(config);
        config.sync();
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        MText.updatePasteAction((JTextComponent)this.core);
    }

    @Override
    public void focus() {
        ((JTextComponent)this.core).requestFocusInWindow();
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if (string.equals("EDIT_MENU")) {
            mMenu.addItemsFromMenu(MText.createMenu((JTextComponent)this.core));
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        if (string.equals("EDITOR_TOOL_BAR")) {
            MText.updateToolBar((JTextComponent)this.core, mToolBar);
        }
    }

    protected void restorePosition(Config config) {
        int n = config.readInt("Text.position", -1);
        if (n != -1) {
            try {
                ((JTextComponent)this.core).setCaretPosition(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected void writeFontSize(Config config) {
        if (this.fontSize != -1 && this.getMetaInfo().getFS() != null) {
            config.write(this.getGlobalEntry("Font.size"), this.fontSize);
        }
    }

    protected void writePosition(Config config) {
        config.write("Text.position", ((JTextComponent)this.core).getCaretPosition());
    }

    private static final class StaticCoreHandler
    extends MMouseAdapter {
        private StaticCoreHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Editor<?> editor;
            if (MMouseAdapter.isLeft(mouseEvent) && (editor = Editor.getCurrentEditor()) != null) {
                editor.showLockInfo();
            }
        }
    }
}

