/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.makagiga.Tabs;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MText;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.UI;
import org.makagiga.commons.mods.Mod;
import org.makagiga.commons.mods.Mods;
import org.makagiga.console.Console;
import org.makagiga.editors.AbstractTextEditor;
import org.makagiga.editors.EditorZoom;

public class ConsoleTab
extends AbstractTextEditor<JTextComponent> {
    private final Console console;

    public ConsoleTab(Console console) {
        super(console.getOutput(), false);
        this.console = console;
        this.setMetaInfo(UI._("Console"), MIcon.stock("ui/console"));
        console.getToolBar().setVisible(false);
        this.addCenter(console);
    }

    @Override
    public void focus() {
        this.console.getCommandLine().makeDefault();
    }

    @Override
    public MToolBar.TextPosition getPreferredToolBarTextPosition() {
        return MToolBar.TextPosition.ALONGSIDE_ICONS;
    }

    @Override
    public boolean getSupportsToolBarUnderTabs() {
        return true;
    }

    public static boolean install() {
        Mods.replace("close@org.makagiga.console.Console", new Mod(){

            @Override
            public Object exec(Object object, String string, Object ... objectArray) {
                if (object instanceof Console) {
                    Tabs tabs = Tabs.getInstance();
                    ConsoleTab consoleTab = tabs.findEditor(ConsoleTab.class);
                    if (consoleTab != null) {
                        tabs.closeEditorAt(tabs.findEditor(consoleTab.getMetaInfo()), 1);
                    }
                    return true;
                }
                return false;
            }
        });
        Mods.replace("show@org.makagiga.console.Console", new Mod(){

            @Override
            public Object exec(Object object, String string, Object ... objectArray) {
                if (object instanceof Console) {
                    Tabs tabs = Tabs.getInstance();
                    ConsoleTab consoleTab = tabs.findEditor(ConsoleTab.class);
                    if (consoleTab != null) {
                        tabs.selectEditor(consoleTab);
                    } else {
                        tabs.addEditor(new ConsoleTab((Console)object));
                    }
                    return true;
                }
                return false;
            }
        });
        return true;
    }

    @Override
    @Deprecated
    public JComponent getZoomComponent() {
        return super.getZoomComponent();
    }

    @Override
    @Deprecated
    public boolean isZoomEnabled(EditorZoom.ZoomType zoomType) {
        return super.isZoomEnabled(zoomType);
    }

    @Override
    public void zoom(EditorZoom.ZoomType zoomType) {
        super.zoom(zoomType);
        MApplication.consoleFontSize.set(this.fontSize);
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if (string.equals("EDIT_MENU")) {
            mMenu.add(MText.getAction((JTextComponent)this.core, "org.makagiga.commons.MText.copy"));
        } else if (string.equals("VIEW_MENU_EDITOR")) {
            this.console.getActionGroup().updateMenu(mMenu);
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        if (string.equals("EDITOR_TOOL_BAR")) {
            mToolBar.add(MText.getAction((JTextComponent)this.core, "org.makagiga.commons.MText.copy"));
            mToolBar.addSeparator();
            this.console.getActionGroup().updateToolBar(mToolBar);
        }
    }
}

