/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image.tools;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MNumberSpinner;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.UI;
import org.makagiga.editors.image.tools.Tool;
import org.makagiga.editors.image.tools.ToolPanel;

public abstract class AbstractRectangleTool
extends Tool {
    protected Rectangle bounds = new Rectangle();
    private int startX;
    private int startY;
    private Panel panel;

    public AbstractRectangleTool(String string, Icon icon, String string2) {
        super(string, icon, string2);
        if (this.getToolPanel() instanceof Panel) {
            this.panel = (Panel)this.getToolPanel();
        }
    }

    public void begin(Point point) {
        this.startX = point.x;
        this.startY = point.y;
        this.bounds.setBounds(point.x, point.y, 0, 0);
        if (this.panel != null) {
            this.panel.update();
        }
    }

    public void clear() {
        this.bounds.setBounds(0, 0, 0, 0);
        if (this.panel != null) {
            this.panel.update();
        }
    }

    public void end(Point point, BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            this.normalizeBounds(point, bufferedImage);
        }
        if (this.panel != null) {
            this.panel.update();
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.bounds = new Rectangle(n, n2, n3, n4);
        this.fixBounds(this.core.getCanvas());
        if (this.panel != null) {
            this.panel.update();
        }
        this.core.repaint();
        this.editor.updateActions();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.end(this.convertPoint(mouseEvent), this.core.getCanvas());
        this.core.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.begin(this.convertPoint(mouseEvent));
        this.core.repaint();
        this.editor.updateActions();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.end(this.convertPoint(mouseEvent), this.core.getCanvas());
        super.mouseReleased(mouseEvent);
        this.core.repaint();
        this.editor.updateActions();
    }

    @Override
    protected ToolPanel createToolPanel() {
        return new Panel();
    }

    protected void fixBounds(Image image) {
        if (image != null) {
            this.bounds = this.bounds.intersection(new Rectangle(0, 0, image.getWidth(null), image.getHeight(null)));
        }
    }

    protected void normalizeBounds(Point point, Image image) {
        this.startX = Math.max(this.startX, 0);
        this.startY = Math.max(this.startY, 0);
        int n = Math.max(point.x, 0);
        int n2 = Math.max(point.y, 0);
        this.bounds.x = this.startX > n ? n : this.startX;
        this.bounds.width = Math.abs(this.startX - n);
        this.bounds.y = this.startY > n2 ? n2 : this.startY;
        this.bounds.height = Math.abs(this.startY - n2);
        this.fixBounds(image);
    }

    AbstractRectangleTool(String string, String string2) {
        this(string, MIcon.get(AbstractRectangleTool.class, string2 + ".png", MIcon.getSmallSize()), string2);
    }

    private final class Panel
    extends ToolPanel
    implements ChangeListener {
        private boolean inUpdate;
        private MNumberSpinner<Integer> x;
        private MNumberSpinner<Integer> y;
        private MNumberSpinner<Integer> width;
        private MNumberSpinner<Integer> height;

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!this.inUpdate) {
                AbstractRectangleTool.this.setBounds(this.x.getNumber(), this.y.getNumber(), this.width.getNumber(), this.height.getNumber());
            }
        }

        private Panel() {
            super(AbstractRectangleTool.this);
            this.setComponent(this.createComponent());
        }

        private MPanel createComponent() {
            this.width = this.createSpinner();
            this.height = this.createSpinner();
            this.x = this.createSpinner();
            this.y = this.createSpinner();
            MPanel mPanel = MPanel.createGroupPanel(true);
            mPanel.getGroupLayout().beginRows().beginColumns().addComponent(this.width, UI._("Width:")).end().beginColumns().addComponent(this.height, UI._("Height:")).end().end().beginRows().beginColumns().addComponent(this.x, "X:").end().beginColumns().addComponent(this.y, "Y:").end().end();
            mPanel.getGroupLayout().linkLabelSize(this.width, this.height);
            mPanel.getGroupLayout().linkLabelSize(this.x, this.y);
            return mPanel;
        }

        private MNumberSpinner<Integer> createSpinner() {
            MNumberSpinner<Integer> mNumberSpinner = new MNumberSpinner<Integer>();
            mNumberSpinner.addChangeListener(this);
            return mNumberSpinner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            if (this.inUpdate) {
                return;
            }
            if (AbstractRectangleTool.this.core == null) {
                return;
            }
            BufferedImage bufferedImage = AbstractRectangleTool.this.core.getCanvas();
            if (bufferedImage == null) {
                return;
            }
            this.inUpdate = true;
            try {
                int n = ((Image)bufferedImage).getWidth(null);
                int n2 = ((Image)bufferedImage).getHeight(null);
                this.x.setRange((Comparable<Integer>)0, (Comparable<Integer>)(n - 1));
                this.y.setRange((Comparable<Integer>)0, (Comparable<Integer>)(n2 - 1));
                this.width.setRange((Comparable<Integer>)1, (Comparable<Integer>)n);
                this.height.setRange((Comparable<Integer>)1, (Comparable<Integer>)n2);
                Rectangle rectangle = AbstractRectangleTool.this.bounds;
                this.x.setNumber(rectangle.x);
                this.y.setNumber(rectangle.y);
                this.width.setNumber(Math.max(1, rectangle.width));
                this.height.setNumber(Math.max(1, rectangle.height));
            }
            finally {
                this.inUpdate = false;
            }
        }
    }
}

